/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.NutritionCategoryConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.NutritionCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.NutritionTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.NutritionTypeComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class NutritionTypeConfig
extends MasterDataInsert<NutritionTypeComplete> {
    private static final long serialVersionUID = 1L;

    public NutritionTypeConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public DetailsPanel getDetails() {
        return new NutritionCategoryConfigPanel();
    }

    @Override
    public String getInsertName() {
        return "Meal Types";
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(NutritionCategoryComplete.class);
                return ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllUnCached(NutritionTypeConfig.this.getMasterDataClass(), true);
            }

            @Override
            public RemoteLoader getInvoker() {
                return NutritionTypeConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public NutritionTypeComplete getNewObject() {
        NutritionTypeComplete a = new NutritionTypeComplete();
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        return a;
    }

    @Override
    public Class<? extends NutritionTypeComplete> getMasterDataClass() {
        return NutritionTypeComplete.class;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(NutritionTypeComplete_.code).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(NutritionTypeComplete_.code).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Code " + n.getChildNamed(NutritionTypeComplete_.code).getValue() + " is not unique."));
                continue;
            }
            codes.add((String)n.getChildNamed(NutritionTypeComplete_.code).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Codes are set"));
        }
        return a;
    }

    private class NutritionCategoryConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> name;
        private TitledItem<TextField> code;
        private TitledItem<TextField> description;
        private TitledItem<ComboBox> category;

        public NutritionCategoryConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.name = new TitledItem<TextField>(new TextField(null), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
            this.code = new TitledItem<TextField>(new TextField(null), Words.CODE, TitledItem.TitledItemOrientation.NORTH);
            this.description = new TitledItem<TextField>(new TextField(null), Words.DESCRIPTION, TitledItem.TitledItemOrientation.NORTH);
            this.category = new TitledItem<ComboBox>(new ComboBox(null, null, ConverterRegistry.getConverter(NutritionCategoryConverter.class)), Words.CATEGORY, TitledItem.TitledItemOrientation.NORTH);
            this.setLayout(new AALayout());
            this.add(this.name);
            this.add(this.code);
            this.add(this.description);
            this.add(this.category);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.name);
            CheckedListAdder.addToList(a, this.code);
            CheckedListAdder.addToList(a, this.description);
            CheckedListAdder.addToList(a, this.category);
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.code.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.code.setVisibleContainer(pane);
            this.description.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.name.kill();
            this.code.kill();
            this.description.kill();
            this.category.kill();
            this.name = null;
            this.code = null;
            this.description = null;
            this.category = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = isEnabled;
            b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.name.setEnabled(b);
            this.code.setEnabled(b);
            this.description.setEnabled(b);
            this.category.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.name.getElement().setNode(node.getChildNamed(NutritionTypeComplete_.name));
            this.code.getElement().setNode(node.getChildNamed(NutritionTypeComplete_.code));
            this.description.getElement().setNode(node.getChildNamed(NutritionTypeComplete_.description));
            this.category.getElement().setNode(node.getChildNamed(NutritionTypeComplete_.category));
            this.category.getElement().refreshPossibleValues(NodeToolkit.getAffixClass(NutritionCategoryComplete.class));
            this.setEnabled(true);
            NutritionTypeConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return NutritionTypeComplete_.code;
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                NutritionCategoryConfigPanel.this.name.setLocation(NutritionTypeConfig.this.masterDataTable.getCellPadding(), NutritionTypeConfig.this.masterDataTable.getCellPadding());
                NutritionCategoryConfigPanel.this.name.setSize(200, (int)NutritionCategoryConfigPanel.this.name.getPreferredSize().getHeight());
                NutritionCategoryConfigPanel.this.code.setLocation(NutritionTypeConfig.this.masterDataTable.getCellPadding(), NutritionCategoryConfigPanel.this.name.getY() + NutritionCategoryConfigPanel.this.name.getHeight() + NutritionTypeConfig.this.masterDataTable.getCellPadding());
                NutritionCategoryConfigPanel.this.code.setSize(200, (int)NutritionCategoryConfigPanel.this.code.getPreferredSize().getHeight());
                NutritionCategoryConfigPanel.this.description.setLocation(NutritionTypeConfig.this.masterDataTable.getCellPadding(), NutritionCategoryConfigPanel.this.code.getY() + NutritionCategoryConfigPanel.this.code.getHeight() + NutritionTypeConfig.this.masterDataTable.getCellPadding());
                NutritionCategoryConfigPanel.this.description.setSize(200, (int)NutritionCategoryConfigPanel.this.description.getPreferredSize().getHeight());
                NutritionCategoryConfigPanel.this.category.setLocation(NutritionTypeConfig.this.masterDataTable.getCellPadding(), NutritionCategoryConfigPanel.this.description.getY() + NutritionCategoryConfigPanel.this.description.getHeight() + NutritionTypeConfig.this.masterDataTable.getCellPadding());
                NutritionCategoryConfigPanel.this.category.setSize(200, (int)NutritionCategoryConfigPanel.this.category.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

