/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.LanguageCodeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.LanguageCodeComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class LanguageCodeConfig
extends MasterDataInsert<LanguageCodeComplete> {
    private static final long serialVersionUID = 1L;

    public LanguageCodeConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public DetailsPanel getDetails() {
        return new LanguageCodeConfigPanel();
    }

    @Override
    public String getInsertName() {
        return "Language Codes";
    }

    @Override
    public LanguageCodeComplete getNewObject() {
        LanguageCodeComplete a = new LanguageCodeComplete();
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        return a;
    }

    @Override
    public Class<? extends LanguageCodeComplete> getMasterDataClass() {
        return LanguageCodeComplete.class;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(LanguageCodeComplete_.languageCode).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(LanguageCodeComplete_.languageCode).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Code " + n.getChildNamed(LanguageCodeComplete_.languageCode).getValue() + " is not unique."));
                continue;
            }
            codes.add((String)n.getChildNamed(LanguageCodeComplete_.languageCode).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Codes are set"));
        }
        return a;
    }

    private class LanguageCodeConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> code;
        private TitledItem<TextField> sequence;
        private TitledItem<TextField> description;
        private TitledItem<CheckBox> showOnAis;

        public LanguageCodeConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.code = new TitledItem<TextField>(new TextField(null), "Language Code", TitledItem.TitledItemOrientation.NORTH);
            this.sequence = new TitledItem<TextField>(new TextField(null, TextFieldType.INT), Words.SEQUENCE_NUMBER, TitledItem.TitledItemOrientation.NORTH);
            this.description = new TitledItem<TextField>(new TextField(), Words.DESCRIPTION, TitledItem.TitledItemOrientation.NORTH);
            this.showOnAis = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_ON_AIS, TitledItem.TitledItemOrientation.EAST);
            this.setLayout(new AALayout());
            this.add(this.code);
            this.add(this.sequence);
            this.add(this.description);
            this.add(this.showOnAis);
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.code.getFocusComponents();
            CheckedListAdder.addToList(a, this.sequence);
            CheckedListAdder.addToList(a, this.description);
            CheckedListAdder.addToList(a, this.showOnAis);
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.code.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.code.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.code.kill();
            this.code = null;
            this.sequence.kill();
            this.sequence = null;
            this.description.kill();
            this.description = null;
            this.showOnAis.kill();
            this.showOnAis = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = isEnabled;
            b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.code.setEnabled(b);
            this.sequence.setEnabled(b);
            this.description.setEnabled(b);
            this.showOnAis.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.code.getElement().setNode(node.getChildNamed(LanguageCodeComplete_.languageCode));
            this.sequence.getElement().setNode(node.getChildNamed(LanguageCodeComplete_.sequenceNumber));
            this.description.getElement().setNode(node.getChildNamed(LanguageCodeComplete_.description));
            this.showOnAis.getElement().setNode(node.getChildNamed(LanguageCodeComplete_.showOnAIS));
            this.setEnabled(true);
            LanguageCodeConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return LanguageCodeComplete_.languageCode;
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                LanguageCodeConfigPanel.this.code.setLocation(LanguageCodeConfig.this.masterDataTable.getCellPadding(), LanguageCodeConfig.this.masterDataTable.getCellPadding());
                LanguageCodeConfigPanel.this.code.setSize(200, (int)LanguageCodeConfigPanel.this.code.getPreferredSize().getHeight());
                LanguageCodeConfigPanel.this.sequence.setLocation(LanguageCodeConfig.this.masterDataTable.getCellPadding(), LanguageCodeConfigPanel.this.code.getY() + LanguageCodeConfigPanel.this.code.getHeight() + LanguageCodeConfig.this.masterDataTable.getCellPadding());
                LanguageCodeConfigPanel.this.sequence.setSize(LanguageCodeConfigPanel.this.sequence.getPreferredSize());
                LanguageCodeConfigPanel.this.description.setLocation(LanguageCodeConfig.this.masterDataTable.getCellPadding(), LanguageCodeConfigPanel.this.sequence.getY() + LanguageCodeConfigPanel.this.sequence.getHeight() + LanguageCodeConfig.this.masterDataTable.getCellPadding());
                LanguageCodeConfigPanel.this.description.setSize(250, (int)LanguageCodeConfigPanel.this.description.getPreferredSize().getHeight());
                LanguageCodeConfigPanel.this.showOnAis.setLocation(LanguageCodeConfig.this.masterDataTable.getCellPadding(), LanguageCodeConfigPanel.this.description.getY() + LanguageCodeConfigPanel.this.description.getHeight() + LanguageCodeConfig.this.masterDataTable.getCellPadding());
                LanguageCodeConfigPanel.this.showOnAis.setSize(LanguageCodeConfigPanel.this.showOnAis.getPreferredSize());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

