/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.PurchasePriceFactorComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PurchasePriceFactorComplete_;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ArticleSalesPriceFactorsConfig
extends MasterDataInsert<PurchasePriceFactorComplete> {
    private static final long serialVersionUID = 1L;

    public ArticleSalesPriceFactorsConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public DetailsPanel getDetails() {
        return new ArticlePurchaseFactorConfigPanel();
    }

    @Override
    public PurchasePriceFactorComplete getNewObject() {
        PurchasePriceFactorComplete a = new PurchasePriceFactorComplete();
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        a.setDefaultValue(Double.valueOf(0.0));
        return a;
    }

    @Override
    public Class<? extends PurchasePriceFactorComplete> getMasterDataClass() {
        return PurchasePriceFactorComplete.class;
    }

    @Override
    public String getInsertName() {
        return Words.ARTICLE_PRICE_FACTORS;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean nameSet = true;
        boolean descriptionSet = true;
        boolean defaultValue = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(PurchasePriceFactorComplete_.name).getValue() == null) {
                nameSet = false;
            }
            if (n.getChildNamed(PurchasePriceFactorComplete_.description).getValue() == null) {
                descriptionSet = false;
            }
            if (n.getChildNamed(PurchasePriceFactorComplete_.defaultValue).getValue() == null) {
                defaultValue = false;
            }
            if (codes.contains(n.getChildNamed(PurchasePriceFactorComplete_.name).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.ENSURE_NAME_IS_UNIQUE, (Object[])new Object[]{n.getChildNamed(PurchasePriceFactorComplete_.name).getValue()})));
                continue;
            }
            codes.add((String)n.getChildNamed(PurchasePriceFactorComplete_.name).getValue());
        }
        if (!nameSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_ALL_NAMES_ARE_SET));
        }
        if (!descriptionSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_ALL_DESCRIPTIONS_ARE_SET));
        }
        if (!defaultValue) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_ALL_DEFAULT_VALUES_ARE_SET));
        }
        return a;
    }

    private class ArticlePurchaseFactorConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> name;
        private TitledItem<TextField> description;
        private TitledItem<TextField> defaultValue;

        public ArticlePurchaseFactorConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.name = new TitledItem<TextField>(new TextField(null), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
            this.description = new TitledItem<TextField>(new TextField(null), Words.DESCRIPTION, TitledItem.TitledItemOrientation.NORTH);
            this.defaultValue = new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.DOUBLE), Words.DEFAULT_VALUE, TitledItem.TitledItemOrientation.NORTH);
            this.setLayout(new AALayout());
            this.add(this.description);
            this.add(this.name);
            this.add(this.defaultValue);
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> focusList = this.name.getFocusComponents();
            focusList.addAll(this.description.getFocusComponents());
            focusList.addAll(this.defaultValue.getFocusComponents());
            return focusList;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.name.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.name.setVisibleContainer(pane);
            this.description.setVisibleContainer(pane);
            this.defaultValue.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.description.kill();
            this.name.kill();
            this.defaultValue.kill();
            this.description = null;
            this.name = null;
            this.defaultValue = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.name.setEnabled(b);
            this.description.setEnabled(b);
            this.defaultValue.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.name.getElement().setNode(node.getChildNamed(PurchasePriceFactorComplete_.name));
            this.description.getElement().setNode(node.getChildNamed(PurchasePriceFactorComplete_.description));
            this.defaultValue.getElement().setNode(node.getChildNamed(PurchasePriceFactorComplete_.defaultValue));
            this.setEnabled(true);
            ArticleSalesPriceFactorsConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return PurchasePriceFactorComplete_.name;
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                ArticlePurchaseFactorConfigPanel.this.name.setLocation(ArticleSalesPriceFactorsConfig.this.masterDataTable.getCellPadding(), ArticleSalesPriceFactorsConfig.this.masterDataTable.getCellPadding());
                ArticlePurchaseFactorConfigPanel.this.name.setSize(200, (int)ArticlePurchaseFactorConfigPanel.this.name.getPreferredSize().getHeight());
                ArticlePurchaseFactorConfigPanel.this.description.setLocation(ArticleSalesPriceFactorsConfig.this.masterDataTable.getCellPadding(), ArticlePurchaseFactorConfigPanel.this.name.getY() + ArticlePurchaseFactorConfigPanel.this.name.getHeight() + ArticleSalesPriceFactorsConfig.this.masterDataTable.getCellPadding());
                ArticlePurchaseFactorConfigPanel.this.description.setSize(200, (int)ArticlePurchaseFactorConfigPanel.this.description.getPreferredSize().getHeight());
                ArticlePurchaseFactorConfigPanel.this.defaultValue.setLocation(ArticleSalesPriceFactorsConfig.this.masterDataTable.getCellPadding(), ArticlePurchaseFactorConfigPanel.this.description.getY() + ArticlePurchaseFactorConfigPanel.this.description.getHeight() + ArticleSalesPriceFactorsConfig.this.masterDataTable.getCellPadding());
                ArticlePurchaseFactorConfigPanel.this.defaultValue.setSize(200, (int)ArticlePurchaseFactorConfigPanel.this.defaultValue.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

