/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.internalconsumption.details;

import ch.icit.pegasus.client.converter.ProductComponentGroupConverter;
import ch.icit.pegasus.client.converter.StockLevelConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.searchbox.StorePositionSearchBox;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.StoreServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.loaders.BasicArticleLoader;
import ch.icit.pegasus.client.util.loaders.ProductVariantLoader;
import ch.icit.pegasus.client.util.toolkits.nodebased.UnitConversionToolkitNodeBased;
import ch.icit.pegasus.client.util.variantaccessor.CurrencyVariantAccessorImpl;
import ch.icit.pegasus.client.util.variantaccessor.RecipeVariantAccessorImpl;
import ch.icit.pegasus.server.core.calculator.IBasicArticle;
import ch.icit.pegasus.server.core.calculator.UnitCalculator;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionComplete_;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionLight;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionLight_;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionMovementComplete;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionMovementComplete_;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionMovementInformationComplete;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionStateE;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionTypeE;
import ch.icit.pegasus.server.core.dtos.dataexchange.NoProExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.product.ComplexProductVariantComplete_;
import ch.icit.pegasus.server.core.dtos.product.CompoundComponentComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight;
import ch.icit.pegasus.server.core.dtos.product.SimpleProductComponentGroupComplete;
import ch.icit.pegasus.server.core.dtos.recipe.LinearQuantityInterpolationComplete;
import ch.icit.pegasus.server.core.dtos.recipe.QuantityInterpolationComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantComplete;
import ch.icit.pegasus.server.core.dtos.serviceproduct.ServiceProductComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StorePositionComplete;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.store.StoreTypeE;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.MapWrapper;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.dtos.utils.PriceQuantityCombination;
import ch.icit.pegasus.server.core.dtos.utils.ProductRecipeAmountCalculationToolkit;
import ch.icit.pegasus.server.core.dtos.utils.RecipeProductConversionToolkit;
import ch.icit.pegasus.server.core.dtos.utils.StoreToolkit;
import ch.icit.pegasus.server.core.dtos.utils.TransactionType;
import ch.icit.pegasus.server.core.dtos.utils.accessor.CurrencyVariantAccessor;
import ch.icit.pegasus.server.core.dtos.utils.accessor.RecipeVariantAccessor;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ComponentSearchDetailsPanel
extends DefaultDetailsPanel<InternalConsumptionLight>
implements ItemListener,
SearchTextField2Listener,
NodeListener {
    private static final long serialVersionUID = 1L;
    private final boolean isNoPro;
    private TitledItem<ComboBox> searchType;
    private TitledItem<SearchTextField2<?>> searchField;
    private TitledItem<ComboBox> productGroups;
    private TitledItem<InputComboBox2> amount;
    private TitledItem<TextLabel> currentStock;
    private TextButton addButton;
    private TextButton cleanAll;
    private TitledItem<StorePositionSearchBox> defaultTargetPosition;
    private TextButton applyDefaults;
    private TitledItem<CheckBox> overrideExisting;
    private TitledItem<RDCheckBox> process;
    private RecipeVariantAccessor recipeVariantAccessor = new RecipeVariantAccessorImpl();
    private CurrencyVariantAccessor currencyAccessor = new CurrencyVariantAccessorImpl();
    private Node movements;
    private Node details;

    public ComponentSearchDetailsPanel(RowEditor<InternalConsumptionLight> editor, RDProvider provider) {
        super(editor, provider);
        this.isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)this.settings);
        this.setTitleText(Words.COMPONENT_SEARCH);
        this.setCustomLayouter(new Layout());
        this.cleanAll = new TextButton(Words.CLEAR_ALL);
        this.applyDefaults = new TextButton(Words.APPLY_DEFAULTS);
        StorePositionSearchBox storePositionSearchBox = new StorePositionSearchBox(true, null);
        this.defaultTargetPosition = new TitledItem<StorePositionSearchBox>(storePositionSearchBox, Words.TARGET, TitledItem.TitledItemOrientation.NORTH);
        this.overrideExisting = new TitledItem<CheckBox>(new CheckBox(), Words.OVERRIDE_EXISTING, TitledItem.TitledItemOrientation.EAST);
        this.process = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.PROCESS, TitledItem.TitledItemOrientation.EAST);
        this.process.getElement().addButtonListener((source, x, y) -> {
            Iterator it = editor.getModel().getNode().getChildNamed(InternalConsumptionComplete_.movementInformations).getFailSafeChildIterator();
            while (it.hasNext()) {
                Node node = (Node)it.next();
                Node doit = node.getChildNamed(new String[]{"performit"});
                if (doit == null) continue;
                doit.setValue((Object)this.process.getElement().isChecked(), 0L);
            }
        });
        if (!this.isNoPro) {
            this.currentStock = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(StockLevelConverter.class)), Words.STOCK, TitledItem.TitledItemOrientation.NORTH);
        }
        this.searchType = new TitledItem<ComboBox>(new ComboBox(), Words.TYPE, TitledItem.TitledItemOrientation.NORTH);
        this.searchField = new TitledItem<SearchTextField2<BasicArticleLight>>(SearchTextField2Factory.getBasicArticleSearchField(true, new DTOProxyNode()), Words.NAME_OR_NUMBER, TitledItem.TitledItemOrientation.NORTH);
        if (!CompanyUtil.isNoPro((SystemSettingsComplete)this.settings)) {
            this.productGroups = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), null, ConverterRegistry.getConverter(ProductComponentGroupConverter.class)), Words.GROUP, TitledItem.TitledItemOrientation.NORTH);
        }
        this.amount = new TitledItem<InputComboBox2>(new InputComboBox2(null, null, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE), Words.QTY, TitledItem.TitledItemOrientation.NORTH);
        this.amount.getElement().getEnterField().addActionListener(e -> this.addButton.requestFocusInWindowNow());
        this.addButton = new TextButton(Words.ADD);
        this.addButton.addButtonListener(this);
        this.cleanAll.addButtonListener(this);
        if (this.applyDefaults != null) {
            this.applyDefaults.addButtonListener(this);
        }
        this.fillCombo();
        this.searchType.getElement().addItemListener(this);
        this.searchField.getElement().addSearchTextFieldListener(this);
        this.addToView(this.applyDefaults);
        this.addToView(this.defaultTargetPosition);
        this.addToView(this.overrideExisting);
        this.addToView(this.process);
        if (!this.isNoPro) {
            this.addToView(this.currentStock);
        }
        this.addToView(this.searchField);
        this.addToView(this.searchType);
        if (this.productGroups != null) {
            this.addToView(this.productGroups);
        }
        this.addToView(this.amount);
        this.addToView(this.addButton);
        this.addToView(this.cleanAll);
        if (CompanyUtil.isNoPro((SystemSettingsComplete)this.settings)) {
            this.configSearchFieldAndAmount();
        }
    }

    private void fillCombo() {
        if (!CompanyUtil.isNoPro((SystemSettingsComplete)this.settings)) {
            this.searchType.getElement().addItem(Words.ARTICLE);
            this.searchType.getElement().addItem(Words.PRODUCT);
            this.searchType.getElement().addItem(Words.RECIPE);
            this.searchType.getElement().addItem(Words.PRODUCT_COMPONENT);
            this.searchType.getElement().setSelectedItem(Words.ARTICLE);
        } else {
            this.searchType.getElement().addItem(Words.RECIPE);
            this.searchType.getElement().addItem(Words.HOURLY_WORK);
            this.searchType.getElement().setSelectedItem(Words.RECIPE);
        }
    }

    private void startAnimation(String text) {
        this.editor.setEnabled(false);
        this.editor.showCommittingAnimation(text);
    }

    private void stopAnimation() {
        this.editor.setEnabled(true);
        this.editor.hideCommittingAnimation();
    }

    public void loadData(final Runnable run) {
        ThreadSafeLoader.run(new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                run.run();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        ComponentSearchDetailsPanel.this.stopAnimation();
                    }

                    public void errorOccurred(ClientException exception) {
                        ComponentSearchDetailsPanel.this.stopAnimation();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        });
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source == this.addButton) {
            try {
                if (this.searchType.getElement().getSelectedItem().equals(Words.ARTICLE)) {
                    this.startAnimation(Words.ADD_ARTICLE);
                    this.loadData(() -> this.addArticle((BasicArticleComplete)this.searchField.getElement().getNode().getValue(BasicArticleComplete.class), this.getDefaultPosition(), this.amount.getElement().getValueNode(), (Node<UnitComplete>)this.amount.getElement().getUnitNode()));
                } else if (this.searchType.getElement().getSelectedItem().equals(Words.PRODUCT)) {
                    this.startAnimation(Words.ADD_PRODUCT);
                    this.loadData(() -> this.addProduct((ProductVariantComplete)this.searchField.getElement().getNode().getValue(ProductVariantComplete.class), this.amount.getElement().getValueNode(), (Node<UnitComplete>)this.amount.getElement().getUnitNode()));
                } else if (this.searchType.getElement().getSelectedItem().equals(Words.RECIPE)) {
                    this.startAnimation(Words.ADD_RECIPE);
                    this.loadData(() -> this.addRecipe((RecipeComplete)this.searchField.getElement().getNode().getValue(RecipeComplete.class), this.amount.getElement().getValueNode(), (Node<UnitComplete>)this.amount.getElement().getUnitNode()));
                } else if (this.searchType.getElement().getSelectedItem().equals(Words.PRODUCT_COMPONENT)) {
                    this.startAnimation(Words.ADD_PRODUCT_COMPONENT);
                    this.loadData(() -> this.addProductComponent((ProductVariantComplete)this.searchField.getElement().getNode().getValue(ProductVariantComplete.class), (SimpleProductComponentGroupComplete)this.productGroups.getElement().getNode().getValue(SimpleProductComponentGroupComplete.class), this.amount.getElement().getValueNode(), (Node<UnitComplete>)this.amount.getElement().getUnitNode()));
                } else if (this.searchType.getElement().getSelectedItem().equals(Words.HOURLY_WORK)) {
                    this.loadData(() -> this.addHourlyWork((ServiceProductComplete)this.searchField.getElement().getNode().getValue(ServiceProductComplete.class), this.amount.getElement().getValueNode(), (Node<UnitComplete>)this.amount.getElement().getUnitNode()));
                }
            }
            catch (Exception e) {
                InnerPopupFactory.showErrorDialog(e, (Component)this);
            }
            this.searchField.requestFocusInWindowNow();
        } else if (source == this.cleanAll) {
            this.startAnimation(Words.CLEAR);
            this.loadData(this::clearList);
            this.searchField.requestFocusInWindowNow();
        } else if (source == this.applyDefaults) {
            this.startAnimation(Words.APPLY_DEFAULTS);
            this.loadData(() -> this.changeStore());
        }
        this.stopAnimation();
    }

    public void changeStore() {
        StorePositionComplete targetStore = null;
        Object targetRemark = null;
        targetStore = this.getDefaultPosition();
        boolean overrideAnyway = this.overrideExisting.getElement().isChecked();
        if (targetStore != null) {
            Iterator it = this.movements.getFailSafeChildIterator();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                Node position = n.getChildNamed(InternalConsumptionMovementComplete_.targetPosition);
                if (position.getValue() != null && !overrideAnyway) continue;
                position.setValue((Object)targetStore, 0L);
            }
        }
    }

    public void clearList() {
        Iterator it = this.movements.getFailSafeChildIterator();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            this.movements.removeChild(n, 0L);
        }
        Iterator it2 = this.details.getFailSafeChildIterator();
        while (it2.hasNext()) {
            Node n = (Node)it2.next();
            this.details.removeChild(n, 0L);
        }
    }

    private void addProductComponent(ProductVariantComplete productVariant, SimpleProductComponentGroupComplete value, Node valueNode, Node<UnitComplete> unitNode) {
        try {
            Double d = null;
            Object v = valueNode.getValue();
            d = v instanceof Long ? Double.valueOf(((Long)v).doubleValue()) : (v instanceof Integer ? Double.valueOf(((Integer)v).doubleValue()) : (v instanceof Double ? (Double)v : Double.valueOf(0.0)));
            Date consumptionDate = (Date)this.editor.getModel().getNode().getChildNamed(InternalConsumptionLight_.consumptionDate).getValue();
            HashMap articles = ProductRecipeAmountCalculationToolkit.getAmount4SimpleProductComponentGroup((SimpleProductComponentGroupComplete)value, (double)d, (ModificationStateE)ModificationStateE.DRAFT, (Timestamp)new Timestamp(consumptionDate.getTime()), (RecipeVariantAccessor)this.recipeVariantAccessor, (CurrencyVariantAccessor)this.currencyAccessor, null, (boolean)false);
            for (Map.Entry e : articles.entrySet()) {
                if (Boolean.TRUE.equals(((BasicArticleComplete)e.getKey()).getReUsable())) continue;
                this.addArticle((BasicArticleComplete)e.getKey(), ((PriceQuantityCombination)e.getValue()).getQuantity(), this.getDefaultPosition());
            }
            String groupInfo = value.getNumber() + " " + value.getName();
            this.addDetails(InternalConsumptionTypeE.PRODUCT_COMPONENT, null, null, productVariant.getProduct(), groupInfo, null, new QuantityComplete(d, (UnitComplete)unitNode.getValue()), consumptionDate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.searchField.getElement().getNode().setValue(null, 0L);
    }

    private void addHourlyWork(ServiceProductComplete value, Node valueNode, Node<UnitComplete> unitNode) {
        if (!Boolean.TRUE.equals(value.getHourlyWork())) {
            InnerPopupFactory.showErrorDialog("Selected Service Product is not type 'hourly work'", (Component)this);
            this.searchField.getElement().getNode().setValue(null, 0L);
            return;
        }
        try {
            Double d = null;
            Object v = valueNode.getValue();
            d = v instanceof Long ? Double.valueOf(((Long)v).doubleValue()) : (v instanceof Integer ? Double.valueOf(((Integer)v).doubleValue()) : (v instanceof Double ? (Double)v : Double.valueOf(0.0)));
            Date consumptionDate = (Date)this.editor.getModel().getNode().getChildNamed(InternalConsumptionLight_.consumptionDate).getValue();
            this.addDetails(InternalConsumptionTypeE.HOURLY_WORK, null, null, null, "", value, new QuantityComplete(d, (UnitComplete)unitNode.getValue()), consumptionDate);
        }
        catch (Exception e) {
            InnerPopupFactory.showErrorDialog(e, (Component)this);
            e.printStackTrace();
        }
        this.searchField.getElement().getNode().setValue(null, 0L);
    }

    private void addRecipe(RecipeComplete recipe, Node valueNode, Node<UnitComplete> unitNode) {
        try {
            Double d = null;
            Object v = valueNode.getValue();
            d = v instanceof Long ? Double.valueOf(((Long)v).doubleValue()) : (v instanceof Integer ? Double.valueOf(((Integer)v).doubleValue()) : (v instanceof Double ? (Double)v : Double.valueOf(0.0)));
            LinearQuantityInterpolationComplete q = new LinearQuantityInterpolationComplete();
            q.setResultingQuantity(new QuantityComplete(d, (UnitComplete)unitNode.getValue()));
            Date consumptionDate = (Date)this.editor.getModel().getNode().getChildNamed(InternalConsumptionLight_.consumptionDate).getValue();
            Timestamp ts = new Timestamp(consumptionDate.getTime());
            RecipeVariantComplete variant = (RecipeVariantComplete)this.recipeVariantAccessor.loadData((Object)recipe, ts);
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            UnitComplete stUnit = settings.getPieceUnit();
            UnitComplete kgUnit = settings.getDefaultCustomsPenaltyUnit();
            CompoundComponentComplete cc = (CompoundComponentComplete)RecipeProductConversionToolkit.convertToProductComponent((RecipeVariantComplete)variant, (QuantityInterpolationComplete)q, (QuantityInterpolationComplete)q, (Timestamp)ts, (RecipeVariantAccessor)this.recipeVariantAccessor, (UnitComplete)stUnit, (UnitComplete)kgUnit, null, (boolean)false);
            Map articles = new HashMap();
            articles = ProductRecipeAmountCalculationToolkit.calculateRecipe(articles, (CompoundComponentComplete)cc, (double)1.0, (QuantityComplete)variant.getYield(), (QuantityComplete)null, (ModificationStateE)ModificationStateE.DRAFT, (boolean)false, (Timestamp)ts, (RecipeVariantAccessor)this.recipeVariantAccessor, (CurrencyVariantAccessor)this.currencyAccessor, null, (boolean)false);
            for (Map.Entry e : articles.entrySet()) {
                if (!this.isNoPro && Boolean.TRUE.equals(((BasicArticleComplete)e.getKey()).getReUsable())) continue;
                this.addArticle((BasicArticleComplete)e.getKey(), ((PriceQuantityCombination)e.getValue()).getQuantity(), this.getDefaultPosition());
            }
            this.addDetails(InternalConsumptionTypeE.RECIPE, null, recipe, null, "", null, new QuantityComplete(d, (UnitComplete)unitNode.getValue()), consumptionDate);
        }
        catch (Exception e) {
            InnerPopupFactory.showErrorDialog(e, (Component)this);
            e.printStackTrace();
        }
        this.searchField.getElement().getNode().setValue(null, 0L);
    }

    private void addProduct(ProductVariantComplete productVariant, Node valueNode, Node<UnitComplete> unitNode) {
        try {
            Double d = null;
            Object v = valueNode.getValue();
            d = v instanceof Long ? Double.valueOf(((Long)v).doubleValue()) : (v instanceof Integer ? Double.valueOf(((Integer)v).doubleValue()) : (v instanceof Double ? (Double)v : Double.valueOf(0.0)));
            Date consumptionDate = (Date)this.editor.getModel().getNode().getChildNamed(InternalConsumptionLight_.consumptionDate).getValue();
            Map articles = ProductRecipeAmountCalculationToolkit.getAmount4Product((ProductVariantComplete)productVariant, (double)d, (ModificationStateE)productVariant.getState(), (Timestamp)new Timestamp(consumptionDate.getTime()), (RecipeVariantAccessor)this.recipeVariantAccessor, (CurrencyVariantAccessor)this.currencyAccessor);
            for (Map.Entry e : articles.entrySet()) {
                if (Boolean.TRUE.equals(((BasicArticleComplete)e.getKey()).getReUsable())) continue;
                this.addArticle((BasicArticleComplete)e.getKey(), ((PriceQuantityCombination)e.getValue()).getQuantity(), this.getDefaultPosition());
            }
            this.addDetails(InternalConsumptionTypeE.PRODUCT, null, null, productVariant.getProduct(), "", null, new QuantityComplete(d, (UnitComplete)unitNode.getValue()), consumptionDate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.searchField.getElement().getNode().setValue(null, 0L);
    }

    private StorePositionComplete getDefaultPosition() {
        StorePositionLight positionLight = null;
        positionLight = (StorePositionLight)this.defaultTargetPosition.getElement().getNode().getValue();
        if (positionLight == null && this.isNoPro) {
            NoProExchangeSettingsComplete noProSettings = (NoProExchangeSettingsComplete)NodeToolkit.getAffixClass(NoProExchangeSettingsComplete.class).getValue();
            positionLight = noProSettings.getProductionStore().getDefaultStorePosition();
        }
        if (positionLight != null) {
            try {
                return (StorePositionComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getStore(positionLight).getValue();
            }
            catch (ClientServerCallException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void addArticle(BasicArticleComplete article, StorePositionComplete storePosition, Node value, Node<UnitComplete> unit) {
        Double d = null;
        Object v = value.getValue();
        d = v instanceof Long ? Double.valueOf(((Long)v).doubleValue()) : (v instanceof Integer ? Double.valueOf(((Integer)v).doubleValue()) : (v instanceof Double ? (Double)v : Double.valueOf(0.0)));
        Date consumptionDate = (Date)this.editor.getModel().getNode().getChildNamed(InternalConsumptionLight_.consumptionDate).getValue();
        this.addArticle(article, new QuantityComplete(d, (UnitComplete)unit.getValue()), storePosition);
        this.addDetails(InternalConsumptionTypeE.ARTICLE, article, null, null, "", null, new QuantityComplete(d, (UnitComplete)unit.getValue()), consumptionDate);
        this.searchField.getElement().getNode().setValue(null, 0L);
    }

    private void addArticle(BasicArticleComplete article, QuantityComplete q, StorePositionComplete storePosition) {
        InternalConsumptionMovementComplete move = new InternalConsumptionMovementComplete();
        move.setClientOId(Long.valueOf(ADTO.getNextId()));
        move.setArticle((BasicArticleLight)article);
        move.setTargetPosition((StorePositionLight)storePosition);
        move.setQuantity(new StoreQuantityComplete(Long.valueOf(q.getQuantity().longValue()), q.getUnit()));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)move, true, false);
        this.movements.addChild(n, 0L);
    }

    private void addDetails(InternalConsumptionTypeE type, BasicArticleComplete article, RecipeComplete recipe, ProductComplete product, String productGroup, ServiceProductComplete serviceProduct, QuantityComplete q, Date consumptionDate) {
        InternalConsumptionMovementInformationComplete info = new InternalConsumptionMovementInformationComplete();
        info.setClientOId(Long.valueOf(ADTO.getNextId()));
        info.setType(type);
        if (article != null) {
            info.setArticle((BasicArticleLight)article);
            info.setGroupInfo("");
        } else if (recipe != null) {
            info.setRecipe(recipe);
            info.setGroupInfo("");
        } else if (product != null && productGroup != null && !productGroup.isEmpty()) {
            info.setProduct(product);
            info.setGroupInfo(productGroup);
        } else if (product != null) {
            info.setProduct(product);
            info.setGroupInfo("");
        } else if (serviceProduct != null) {
            info.setServiceProduct(serviceProduct);
            info.setGroupInfo("");
        }
        info.setConsumptionDate(consumptionDate);
        info.setQuantity(new QuantityComplete(q.getQuantity(), q.getUnit()));
        Node i = INodeCreator.getDefaultImpl().getNode4DTO((Object)info, true, false);
        this.details.addChild(i, 0L);
    }

    private void configSearchFieldAndAmount() {
        this.searchField.getElement().getNode().setValue(null, 0L);
        if (this.productGroups != null) {
            this.productGroups.getElement().getNode().setValue(null, 0L);
            this.productGroups.getElement().setPossibleValues(null);
        }
        if (this.searchType.getElement().getSelectedItem().equals(Words.ARTICLE)) {
            this.currentStock.setVisible(true);
            SearchTextField2Factory.config2BasicArticleSearchField(this.searchField.getElement(), false);
        } else if (this.searchType.getElement().getSelectedItem().equals(Words.PRODUCT)) {
            this.currentStock.setVisible(false);
            SearchTextField2Factory.config2ProductVariantSearchField(this.searchField.getElement());
        } else if (this.searchType.getElement().getSelectedItem().equals(Words.RECIPE)) {
            if (this.currentStock != null) {
                this.currentStock.setVisible(false);
            }
            SearchTextField2Factory.config2RecipeSearchField(this.searchField.getElement());
        } else if (this.searchType.getElement().getSelectedItem().equals(Words.PRODUCT_COMPONENT)) {
            this.currentStock.setVisible(false);
            SearchTextField2Factory.config2ProductVariantSearchField(this.searchField.getElement());
        } else if (this.searchType.getElement().getSelectedItem().equals(Words.HOURLY_WORK)) {
            if (this.currentStock != null) {
                this.currentStock.setVisible(false);
            }
            SearchTextField2Factory.config2ServiceProductSearchField(this.searchField.getElement());
        }
        this.setEnabled(this.isEnabled());
    }

    @Override
    public void requestFocusInWindowNow() {
        this.searchType.getElement();
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.searchType);
        CheckedListAdder.addToList(a, this.searchField);
        CheckedListAdder.addToList(a, this.productGroups);
        CheckedListAdder.addToList(a, this.amount);
        CheckedListAdder.addToList(a, this.defaultTargetPosition);
        CheckedListAdder.addToList(a, this.addButton);
        CheckedListAdder.addToList(a, this.cleanAll);
        CheckedListAdder.addToList(a, this.applyDefaults);
        CheckedListAdder.addToList(a, this.overrideExisting);
        CheckedListAdder.addToList(a, this.process);
        return a;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        boolean hasProcessedItems = this.editor.getModel().getNode().getChildNamed(InternalConsumptionLight_.transactionState).getValue() != InternalConsumptionStateE.NOTHING;
        boolean isAdd = !hasProcessedItems || this.editor.isAdding() && !Boolean.TRUE.equals(this.editor.getModel().getNode().getChildNamed(InternalConsumptionComplete_.process).getValue());
        if (this.editor.getModel().isAddRow()) {
            isAdd = true;
        }
        boolean doIt = isEnabled && isAdd;
        this.searchType.setEnabled(doIt);
        this.searchField.setEnabled(doIt);
        boolean groups = false;
        if (this.searchType.getElement().getSelectedItem().equals(Words.PRODUCT_COMPONENT) && this.searchField.getElement().getNode().getValue() != null) {
            groups = true;
        }
        if (this.productGroups != null) {
            this.productGroups.setEnabled(groups && doIt);
        }
        this.amount.setEnabled(this.searchField.getElement().isItemSelected() && doIt);
        this.addButton.setEnabled(this.searchField.getElement().isItemSelected() && doIt);
        this.defaultTargetPosition.setEnabled(isEnabled);
        this.applyDefaults.setEnabled(isEnabled);
        this.overrideExisting.setEnabled(isEnabled);
        this.process.setEnabled(isEnabled && (!hasProcessedItems || isAdd));
        this.cleanAll.setEnabled(doIt);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.searchType.kill();
        this.searchType = null;
        this.searchField.kill();
        this.searchField = null;
        if (this.productGroups != null) {
            this.productGroups.kill();
        }
        this.productGroups = null;
        this.amount.kill();
        this.amount = null;
        this.addButton.kill();
        this.addButton = null;
        this.defaultTargetPosition.kill();
        this.applyDefaults.kill();
        this.overrideExisting.kill();
        this.process.kill();
        this.defaultTargetPosition = null;
        this.applyDefaults = null;
        this.overrideExisting = null;
        this.process = null;
        this.cleanAll.kill();
        this.cleanAll = null;
        if (this.currentStock != null) {
            this.currentStock.kill();
        }
        this.currentStock = null;
        try {
            this.editor.getModel().getTypeSafeNode().getChildNamed(InternalConsumptionComplete_.consumptionDate).removeNodeListener((NodeListener)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.movements = node.getChildNamed(InternalConsumptionComplete_.movementInformations);
        this.details = node.getChildNamed(InternalConsumptionComplete_.movementDetailInformation);
        Node settingsNode = NodeToolkit.getAffixClass(SystemSettingsComplete.class);
        DTOProxyNode pos = new DTOProxyNode();
        if (CompanyUtil.isNoPro((SystemSettingsComplete)this.settings)) {
            NoProExchangeSettingsComplete noProSettings = (NoProExchangeSettingsComplete)NodeToolkit.getAffixClass(NoProExchangeSettingsComplete.class).getValue();
            pos.setValue((Object)noProSettings.getProductionStore().getDefaultStorePosition(), 0L);
            this.defaultTargetPosition.getElement().setNode((Node<StorePositionLight>)pos);
        } else {
            pos.setValue((Object)((SystemSettingsComplete)settingsNode.getValue()).getDefaultInternalConsumptionWasteStore(), 0L);
            this.defaultTargetPosition.getElement().setNode((Node<StorePositionLight>)pos);
        }
        node.getChildNamed(InternalConsumptionComplete_.consumptionDate).addNodeListener((NodeListener)this);
        this.process.getElement().setNode(node.getChildNamed(InternalConsumptionComplete_.process));
    }

    public void valueChanged(Node<?> node) {
        Node<?> articleNode = null;
        if (this.searchField != null) {
            articleNode = this.searchField.getElement().getNode();
        }
        if (articleNode != null) {
            this.updateSelectableUnits((BasicArticleComplete)articleNode.getValue(BasicArticleComplete.class));
        }
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?>[] nodes) {
    }

    public boolean isSwingOnly() {
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent arg0) {
        if (arg0.getStateChange() == 1) {
            this.configSearchFieldAndAmount();
        }
    }

    @Override
    public void newValueSelected(SearchTextField2 source, Node<?> n) throws ClientServerCallException {
        if (this.searchType.getElement().getSelectedItem().equals(Words.ARTICLE)) {
            if (source.isItemSelected()) {
                this.amount.requestFocusInWindowNow();
                if (n.getValue(BasicArticleComplete.class) == null) {
                    new BasicArticleLoader((BasicArticleReference)n.getValue(BasicArticleLight.class), new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            ComponentSearchDetailsPanel.this.updateArticle(node);
                        }

                        public void errorOccurred(ClientException exception) {
                            InnerPopupFactory.showErrorDialog((Exception)exception, (Component)ComponentSearchDetailsPanel.this);
                        }
                    }, n, this);
                } else {
                    this.updateArticle(n);
                }
            }
        } else if (this.searchType.getElement().getSelectedItem().equals(Words.PRODUCT)) {
            if (source.isItemSelected()) {
                this.amount.requestFocusInWindowNow();
                if (n.getValue(ProductVariantComplete.class) == null) {
                    new ProductVariantLoader((ProductVariantLight)n.getValue(ProductVariantLight.class), new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            ComponentSearchDetailsPanel.this.updateProduct(node);
                        }

                        public void errorOccurred(ClientException exception) {
                            InnerPopupFactory.showErrorDialog((Exception)exception, (Component)ComponentSearchDetailsPanel.this);
                        }
                    }, n, this);
                } else {
                    this.updateProduct(n);
                }
            }
        } else if (this.searchType.getElement().getSelectedItem().equals(Words.RECIPE)) {
            if (source.isItemSelected()) {
                this.amount.requestFocusInWindowNow();
                this.updateRecipeComponent(n);
            }
        } else if (this.searchType.getElement().getSelectedItem().equals(Words.PRODUCT_COMPONENT)) {
            if (source.isItemSelected()) {
                this.productGroups.requestFocusInWindowNow();
                if (n.getValue(ProductVariantComplete.class) == null) {
                    new ProductVariantLoader((ProductVariantLight)n.getValue(ProductVariantLight.class), new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            ComponentSearchDetailsPanel.this.updateProductComponent(node);
                        }

                        public void errorOccurred(ClientException exception) {
                            InnerPopupFactory.showErrorDialog((Exception)exception, (Component)ComponentSearchDetailsPanel.this);
                        }
                    }, n, this);
                } else {
                    this.updateProductComponent(n);
                }
            }
        } else if (this.searchType.getElement().getSelectedItem().equals(Words.HOURLY_WORK) && source.isItemSelected()) {
            this.amount.requestFocusInWindowNow();
            this.updateHourlyWork(n);
        }
    }

    private void updateHourlyWork(Node<?> n) {
        SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        this.amount.getElement().setMaxKommaStellen(2);
        QuantityComplete q = new QuantityComplete(Double.valueOf(0.0), s.getDefaultTimeUnit());
        this.amount.getElement().setNode(INodeCreator.getDefaultImpl().getNode4DTO((Object)q, false, false));
        ArrayList<UnitComplete> list = new ArrayList<UnitComplete>();
        list.add(s.getDefaultTimeUnit());
        this.amount.getElement().setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(list));
        this.setEnabled(this.isEnabled());
    }

    private void updateProduct(Node<?> n) {
        SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        this.amount.getElement().setMaxKommaStellen(-1);
        QuantityComplete q = new QuantityComplete(Double.valueOf(0.0), s.getPieceUnit());
        this.amount.getElement().setNode(INodeCreator.getDefaultImpl().getNode4DTO((Object)q, false, false));
        ArrayList<UnitComplete> list = new ArrayList<UnitComplete>();
        list.add(s.getPieceUnit());
        this.amount.getElement().setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(list));
        this.setEnabled(this.isEnabled());
    }

    private void updateRecipeComponent(Node<?> n) {
        this.amount.getElement().setMaxKommaStellen(-1);
        QuantityComplete q = new QuantityComplete(Double.valueOf(0.0), ((RecipeComplete)n.getValue(RecipeComplete.class)).getCurrentVariant().getYield().getUnit());
        this.amount.getElement().setNode(INodeCreator.getDefaultImpl().getNode4DTO((Object)q, false, false));
        ArrayList<UnitComplete> list = new ArrayList<UnitComplete>();
        list.add(q.getUnit());
        this.amount.getElement().setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(list));
        this.setEnabled(this.isEnabled());
    }

    protected void updateProductComponent(Node<?> node) {
        this.amount.getElement().setMaxKommaStellen(-1);
        SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        QuantityComplete q = new QuantityComplete(Double.valueOf(0.0), s.getPieceUnit());
        this.amount.getElement().setNode(INodeCreator.getDefaultImpl().getNode4DTO((Object)q, false, false));
        ArrayList<UnitComplete> list = new ArrayList<UnitComplete>();
        list.add(s.getPieceUnit());
        this.amount.getElement().setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(list));
        this.productGroups.getElement().refreshPossibleValues(node.getChildNamed(ComplexProductVariantComplete_.productComponentGroups));
        this.setEnabled(this.isEnabled());
    }

    protected void updateArticle(Node<?> n) {
        this.amount.getElement().setMaxKommaStellen(-1);
        final BasicArticleComplete article = (BasicArticleComplete)n.getValue(BasicArticleComplete.class);
        if (article == null) {
            return;
        }
        QuantityComplete q = new QuantityComplete(Double.valueOf(0.0), article.getFloatStoreUnit());
        if (this.amount == null || this.amount.getElement() == null) {
            return;
        }
        this.amount.getElement().setNode(INodeCreator.getDefaultImpl().getNode4DTO((Object)q, false, false));
        this.updateSelectableUnits((BasicArticleComplete)n.getValue(BasicArticleComplete.class));
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                MapWrapper stock = ((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getStockPerStore(new BasicArticleReference(article.getId()));
                Node ret = new Node();
                ret.setValue((Object)stock, 0L);
                return ret;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        MapWrapper value = (MapWrapper)node.getValue();
                        List conversion = UnitCalculator.getArticlePackagingQuantities((IBasicArticle)article, (Timestamp)new Timestamp(System.currentTimeMillis()));
                        QuantityComplete qty = new QuantityComplete(Double.valueOf(0.0), article.getFloatStoreUnit());
                        for (Map.Entry entry : value.getMap().entrySet()) {
                            QuantityComplete nq;
                            if (Boolean.TRUE.equals(((StoreLight)entry.getKey()).getMainStore()) || ((StoreLight)entry.getKey()).getStoreType() != StoreTypeE.NORMAL || !Boolean.TRUE.equals(((StoreLight)entry.getKey()).getAutoCheckoutStore())) continue;
                            qty = nq = (QuantityComplete)UnitCalculator.addQuantitiesNormal((IBasicArticle)article, (Object)new QuantityComplete((StoreQuantityComplete)entry.getValue()), (List)conversion, (Object)qty, (List)conversion);
                        }
                        ((TextLabel)ComponentSearchDetailsPanel.this.currentStock.getElement()).setNode(INodeCreator.getDefaultImpl().getNode4DTO((Object)qty, false, false));
                        ((TextLabel)ComponentSearchDetailsPanel.this.currentStock.getElement()).updateString();
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, "Unable to load stock level", (Component)ComponentSearchDetailsPanel.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        this.setEnabled(this.isEnabled());
    }

    protected void updateSelectableUnits(BasicArticleComplete articleComplete) {
        if (articleComplete != null) {
            Date date = (Date)this.editor.getModel().getNode().getChildNamed(InternalConsumptionComplete_.consumptionDate).getValue();
            List possibleUnits = StoreToolkit.getPossibleUnits((BasicArticleLight)articleComplete, null, (Timestamp)new Timestamp(date.getTime()), (TransactionType)TransactionType.INTERNAL_CONSUMPTION, (UserComplete)this.currentUser, null, null, (SystemSettingsComplete)this.settings);
            this.amount.getElement().setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(possibleUnits));
            if (possibleUnits.isEmpty()) {
                this.amount.getElement().clearSelectedUnit();
                this.addButton.setEnabled(false);
            } else if (possibleUnits.contains(articleComplete.getBaseUnit())) {
                this.amount.getElement().setSelectedUnit(articleComplete.getBaseUnit());
            } else if (possibleUnits.contains(articleComplete.getFloatStoreUnit())) {
                this.amount.getElement().setSelectedUnit(articleComplete.getFloatStoreUnit());
            } else {
                this.amount.getElement().setSelectedUnit((UnitComplete)possibleUnits.get(0));
            }
        }
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        return validationObjects;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            ComponentSearchDetailsPanel.this.searchType.setLocation(ComponentSearchDetailsPanel.this.horizontalBorder, ComponentSearchDetailsPanel.this.verticalBorder);
            ComponentSearchDetailsPanel.this.searchType.setSize(120, (int)ComponentSearchDetailsPanel.this.searchType.getPreferredSize().getHeight());
            ComponentSearchDetailsPanel.this.searchField.setLocation(ComponentSearchDetailsPanel.this.searchType.getX() + ComponentSearchDetailsPanel.this.searchType.getWidth() + ComponentSearchDetailsPanel.this.inner_horizontalBorder, ComponentSearchDetailsPanel.this.verticalBorder);
            ComponentSearchDetailsPanel.this.searchField.setSize(240, (int)ComponentSearchDetailsPanel.this.searchField.getPreferredSize().getHeight());
            int currentX = ComponentSearchDetailsPanel.this.searchField.getX() + ComponentSearchDetailsPanel.this.searchField.getWidth();
            if (ComponentSearchDetailsPanel.this.currentStock != null) {
                ComponentSearchDetailsPanel.this.currentStock.setLocation(currentX + ComponentSearchDetailsPanel.this.inner_horizontalBorder, ComponentSearchDetailsPanel.this.verticalBorder);
                ComponentSearchDetailsPanel.this.currentStock.setSize(120, (int)ComponentSearchDetailsPanel.this.currentStock.getPreferredSize().getHeight());
                currentX = ComponentSearchDetailsPanel.this.currentStock.getX() + ComponentSearchDetailsPanel.this.currentStock.getWidth();
            }
            if (ComponentSearchDetailsPanel.this.productGroups != null) {
                ComponentSearchDetailsPanel.this.productGroups.setLocation(currentX + ComponentSearchDetailsPanel.this.inner_horizontalBorder, ComponentSearchDetailsPanel.this.verticalBorder);
                ComponentSearchDetailsPanel.this.productGroups.setSize(240, (int)ComponentSearchDetailsPanel.this.productGroups.getPreferredSize().getHeight());
                currentX = ComponentSearchDetailsPanel.this.productGroups.getX() + ComponentSearchDetailsPanel.this.productGroups.getWidth();
            }
            ComponentSearchDetailsPanel.this.amount.setLocation(currentX + ComponentSearchDetailsPanel.this.inner_horizontalBorder, ComponentSearchDetailsPanel.this.verticalBorder);
            ComponentSearchDetailsPanel.this.amount.setSize(ComponentSearchDetailsPanel.this.amount.getPreferredSize());
            ComponentSearchDetailsPanel.this.addButton.setLocation(ComponentSearchDetailsPanel.this.amount.getX() + ComponentSearchDetailsPanel.this.amount.getWidth() + ComponentSearchDetailsPanel.this.inner_horizontalBorder, (int)((double)(ComponentSearchDetailsPanel.this.verticalBorder + ComponentSearchDetailsPanel.this.amount.getHeight()) - ComponentSearchDetailsPanel.this.addButton.getPreferredSize().getHeight()));
            ComponentSearchDetailsPanel.this.addButton.setSize(ComponentSearchDetailsPanel.this.addButton.getPreferredSize());
            ComponentSearchDetailsPanel.this.cleanAll.setLocation(ComponentSearchDetailsPanel.this.addButton.getX() + ComponentSearchDetailsPanel.this.addButton.getWidth() + ComponentSearchDetailsPanel.this.inner_horizontalBorder, ComponentSearchDetailsPanel.this.addButton.getY());
            ComponentSearchDetailsPanel.this.cleanAll.setSize(ComponentSearchDetailsPanel.this.cleanAll.getPreferredSize());
            ComponentSearchDetailsPanel.this.defaultTargetPosition.setLocation(ComponentSearchDetailsPanel.this.horizontalBorder, ComponentSearchDetailsPanel.this.searchType.getY() + ComponentSearchDetailsPanel.this.searchType.getHeight() + ComponentSearchDetailsPanel.this.inner_verticalBorder);
            ComponentSearchDetailsPanel.this.defaultTargetPosition.setSize(300, (int)ComponentSearchDetailsPanel.this.defaultTargetPosition.getPreferredSize().getHeight());
            ComponentSearchDetailsPanel.this.applyDefaults.setLocation(ComponentSearchDetailsPanel.this.defaultTargetPosition.getX() + ComponentSearchDetailsPanel.this.defaultTargetPosition.getWidth() + ComponentSearchDetailsPanel.this.inner_horizontalBorder, (int)((double)(ComponentSearchDetailsPanel.this.defaultTargetPosition.getY() + ComponentSearchDetailsPanel.this.defaultTargetPosition.getHeight()) - ComponentSearchDetailsPanel.this.applyDefaults.getPreferredSize().getHeight()));
            ComponentSearchDetailsPanel.this.applyDefaults.setSize(ComponentSearchDetailsPanel.this.applyDefaults.getPreferredSize());
            ComponentSearchDetailsPanel.this.overrideExisting.setLocation(ComponentSearchDetailsPanel.this.applyDefaults.getX() + ComponentSearchDetailsPanel.this.applyDefaults.getWidth() + ComponentSearchDetailsPanel.this.inner_horizontalBorder, (int)((double)ComponentSearchDetailsPanel.this.applyDefaults.getY() + ((double)ComponentSearchDetailsPanel.this.applyDefaults.getHeight() - ComponentSearchDetailsPanel.this.overrideExisting.getPreferredSize().getHeight()) / 2.0));
            ComponentSearchDetailsPanel.this.overrideExisting.setSize(ComponentSearchDetailsPanel.this.overrideExisting.getPreferredSize());
            ComponentSearchDetailsPanel.this.process.setLocation(ComponentSearchDetailsPanel.this.overrideExisting.getX() + ComponentSearchDetailsPanel.this.overrideExisting.getWidth() + ComponentSearchDetailsPanel.this.inner_horizontalBorder, (int)((double)ComponentSearchDetailsPanel.this.applyDefaults.getY() + ((double)ComponentSearchDetailsPanel.this.applyDefaults.getHeight() - ComponentSearchDetailsPanel.this.overrideExisting.getPreferredSize().getHeight()) / 2.0));
            ComponentSearchDetailsPanel.this.process.setSize(ComponentSearchDetailsPanel.this.process.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            int h = ComponentSearchDetailsPanel.this.verticalBorder;
            h = (int)((double)h + ComponentSearchDetailsPanel.this.amount.getPreferredSize().getHeight());
            h += ComponentSearchDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + ComponentSearchDetailsPanel.this.defaultTargetPosition.getPreferredSize().getHeight());
            return new Dimension(0, h += ComponentSearchDetailsPanel.this.verticalBorder);
        }
    }
}

