/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.incidentlog.details;

import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table.commiter.RemoteCommitter;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.ViewButton;
import ch.icit.pegasus.client.gui.utils.file.FileChooserPanel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferState;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentLogComplete_;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentLogDocAttachmentComplete;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentLogDocAttachmentComplete_;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentLogLight;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentStateE;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.IncidentLogAccess;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DocAttachmentPanel
extends TableDetailsPanel<IncidentLogLight> {
    public DocAttachmentPanel(RowEditor<IncidentLogLight> editor, RDProvider provider) {
        super(editor, provider, true);
        this.setTitleText(Words.DOCS);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int dw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + this.table.getCellPadding() * 2;
        columns.add(new TableColumnInfo(Words.COMMENT, null, null, null, "", 40, Integer.MAX_VALUE, 40));
        columns.add(new TableColumnInfo(Words.FILE, null, null, null, "", dw, Integer.MAX_VALUE, dw));
        columns.add(new TableColumnInfo("", null, null, null, "", dw, dw, dw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setDontUseScrollBar(15);
        table.setSortedColumn(2);
        table.setSortDirection(false);
        table.setUseWriteAccessRight(true);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean isSupervisor = this.provider.isWritable(IncidentLogAccess.INCIDENT_LOG_SUPERVISOR);
        boolean editable = false;
        IncidentStateE currentState = (IncidentStateE)this.getEditor().getModel().getNode().getChildNamed(IncidentLogComplete_.state).getValue();
        if (currentState == IncidentStateE.CLOSED) {
            if (isSupervisor) {
                editable = true;
            }
        } else {
            editable = true;
        }
        boolean e = isEnabled && editable;
        super.setEnabled(e);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        IncidentLogDocAttachmentComplete file = new IncidentLogDocAttachmentComplete();
        file.setClientOId(Long.valueOf(ADTO.getNextId()));
        Node node = INodeCreator.getDefaultImpl().getNode4DTO((Object)file, false, false);
        this.table.getModel().getNode().addChild(node, 0L);
    }

    @Override
    public void childRemoved() {
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl p = new TableRowImpl(model);
        p.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return p;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.table.getModel().setNode(node.getChildNamed(IncidentLogComplete_.docAttachments));
    }

    @Override
    public List<RemoteCommitter> commitParagraph() {
        ArrayList<RemoteCommitter> committers = new ArrayList<RemoteCommitter>();
        for (Table2RowPanel row : this.table.getRows()) {
            TableRowImpl r = (TableRowImpl)row;
            List<RemoteCommitter> remoteCommitters = r.commitParagraph();
            if (remoteCommitters == null) continue;
            committers.addAll(remoteCommitters);
        }
        return committers;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextField comment;
        private FileChooserPanel fileChooser;
        private ViewButton viewFile;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.comment = new TextField(m.getNode().getChildNamed(IncidentLogDocAttachmentComplete_.comment));
            this.fileChooser = new FileChooserPanel((Node<PegasusFileComplete>)m.getNode().getChildNamed(IncidentLogDocAttachmentComplete_.attachment), false);
            this.viewFile = new ViewButton();
            this.viewFile.addButtonListener(this);
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new Layout3());
            this.add(this.comment);
            this.add(this.fileChooser);
            this.add(this.viewFile);
            this.add(this.delete);
        }

        public List<RemoteCommitter> commitParagraph() {
            return this.fileChooser.commitFile();
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
            } else if (source == this.viewFile && this.model.getNode().getChildNamed(IncidentLogDocAttachmentComplete_.attachment).getValue() != null) {
                try {
                    FileTransferUtil.download((PegasusFileComplete)((PegasusFileComplete)this.model.getNode().getChildNamed(IncidentLogDocAttachmentComplete_.attachment).getValue()), (FileTransferListener[])new FileTransferListener[]{new FileTransferListener(){

                        public void statusChanged(File file, FileTransferState state) {
                            if (state.getState() == FileTransferState.State.FINISHED) {
                                try {
                                    Desktop.getDesktop().open(file);
                                }
                                catch (IOException e) {
                                    InnerPopupFactory.showErrorDialog(e, (Component)DocAttachmentPanel.this);
                                }
                            }
                        }

                        public void exceptionOccurred(Exception exception) {
                            InnerPopupFactory.showErrorDialog(exception, (Component)DocAttachmentPanel.this);
                        }
                    }});
                }
                catch (Exception e) {
                    InnerPopupFactory.showErrorDialog(e, (Component)DocAttachmentPanel.this);
                }
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.delete.kill();
            this.comment.kill();
            this.fileChooser.kill();
            this.viewFile.kill();
            this.delete = null;
            this.comment = null;
            this.fileChooser = null;
            this.viewFile = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.comment);
            CheckedListAdder.addToList(a, this.fileChooser);
            CheckedListAdder.addToList(a, this.viewFile);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private class Layout3
        extends DefaultLayout {
            private Layout3() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.comment.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.comment.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.comment.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.comment.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.fileChooser.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.fileChooser.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.fileChooser.setSize((int)((double)w - ((double)(2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.getInnerCellPadding()) + TableRowImpl.this.viewFile.getPreferredSize().getWidth())), (int)TableRowImpl.this.fileChooser.getPreferredSize().getHeight());
                TableRowImpl.this.viewFile.setLocation(TableRowImpl.this.fileChooser.getX() + TableRowImpl.this.fileChooser.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.viewFile.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.viewFile.setSize(TableRowImpl.this.viewFile.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.setColorIndex(currentX);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

