/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.importer.utils;

import ch.icit.pegasus.client.gui.modules.importer.utils.ImporterItemView;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class ImporterItemGroupView
extends DefaultPanel {
    private static final long serialVersionUID = 2L;
    private TextLabel label;
    private List<ImporterItemView> items = new ArrayList<ImporterItemView>();

    public ImporterItemGroupView(String name) {
        this.label = new TextLabel(name);
        this.setLayout(new Layout());
        this.add(this.label);
    }

    public void addItem(ImporterItemView item) {
        this.add(item);
        this.items.add(item);
        this.revalidate();
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        for (ImporterItemView i : this.items) {
            CheckedListAdder.addToList(a, i);
        }
        return a;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    public List<ImporterItemView> getItems() {
        return this.items;
    }

    private class Layout
    extends DefaultLayout {
        int itemBorder = 5;
        int titleBorder = 3;

        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = (int)ImporterItemGroupView.this.label.getPreferredSize().getHeight();
            h += this.titleBorder;
            for (ImporterItemView i : ImporterItemGroupView.this.items) {
                h = (int)((double)h + i.getPreferredSize().getHeight());
                h += this.itemBorder;
            }
            return new Dimension(0, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            int cy = 0;
            ImporterItemGroupView.this.label.setLocation(0, cy);
            ImporterItemGroupView.this.label.setSize(parent.getWidth(), (int)ImporterItemGroupView.this.label.getPreferredSize().getHeight());
            cy += ImporterItemGroupView.this.label.getHeight();
            cy += this.titleBorder;
            for (ImporterItemView i : ImporterItemGroupView.this.items) {
                i.setLocation(0, cy);
                i.setSize(parent.getWidth(), (int)i.getPreferredSize().getHeight());
                cy = (int)((double)cy + i.getPreferredSize().getHeight());
                cy += this.itemBorder;
            }
        }
    }
}

