/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.handlingcosts.details.utils;

import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.IntegerPlusPlusConverter;
import ch.icit.pegasus.client.converter.UnitConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.formatter.FormatterRegistry;
import ch.icit.pegasus.client.gui.modules.handlingcosts.details.utils.StepComparator;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.icons.ArrowConnectorIcon;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDInputComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.handlingcost.StepPriceFunctionComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StepPricePopupInsert
extends PopUpInsert {
    private static final long serialVersionUID = 1L;
    private Table2 table;
    private Node steps;
    private ViewNode compUnits;
    private ViewNode allUnits;
    private DecimalFormat format;
    private boolean isDouble = true;
    private boolean showPriceUnit = false;
    private boolean isDeletable;
    private DtoField overrideName;
    private RDProvider provider;
    private boolean useUnit;

    public StepPricePopupInsert(boolean useUnit, ListNode steps, List<Node> prodUnitList, Node yieldUnit, String pattern, boolean isDouble, boolean showPriceUnit, RDProvider provider, DtoField name) {
        this.provider = provider;
        this.overrideName = name;
        this.isDouble = isDouble;
        this.showPriceUnit = showPriceUnit;
        this.useUnit = useUnit;
        this.format = FormatterRegistry.getDecimalFormat(pattern);
        this.isDeletable = provider.isWritable(name);
        this.compUnits = new ViewNode("ProdUnits");
        if (prodUnitList != null) {
            this.compUnits.addChildren(prodUnitList);
        }
        this.allUnits = new ViewNode("allUnits");
        this.allUnits.addChildren(yieldUnit.getChildsAsList());
        this.setOpaque(false);
        this.steps = steps;
        this.table = new Table2(true, Words.ADD);
        this.table.setUseWriteAccessRight(true);
        this.table.setOverrideName(name);
        this.table.setProvider(provider);
        this.table.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                StepPricePopupInsert.this.popup.createFocusCycle();
                StepPricePopupInsert.this.table.relayoutRequested();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                Node lastStep = null;
                if (StepPricePopupInsert.this.steps.getChildCount() > 0) {
                    lastStep = StepPricePopupInsert.this.steps.getChildAt(StepPricePopupInsert.this.steps.getChildCount() - 1);
                }
                StepPriceFunctionComplete step = new StepPriceFunctionComplete();
                step.setClientOId(Long.valueOf(ADTO.getNextId()));
                step.setSequenceNumber(Integer.valueOf(StepPricePopupInsert.this.table.getRowCount()));
                QuantityComplete upQuant = new QuantityComplete();
                PriceComplete resQuant = new PriceComplete();
                if (lastStep != null) {
                    upQuant.setQuantity(Double.valueOf((Double)lastStep.getChildNamed(new String[]{"upperLimit-quantity"}).getValue() + 1.0));
                    upQuant.setUnit((UnitComplete)lastStep.getChildNamed(new String[]{"upperLimit-unit"}).getValue());
                    resQuant.setPrice(Double.valueOf((Double)lastStep.getChildNamed(new String[]{"price-price"}).getValue() + 1.0));
                    resQuant.setCurrency((CurrencyComplete)lastStep.getChildNamed(new String[]{"price-currency"}).getValue());
                } else {
                    upQuant.setQuantity(Double.valueOf(1.0));
                    if (StepPricePopupInsert.this.compUnits != null && StepPricePopupInsert.this.compUnits.getChildCount() > 0) {
                        upQuant.setUnit((UnitComplete)StepPricePopupInsert.this.compUnits.getChildAt(0).getValue());
                    }
                    resQuant.setPrice(Double.valueOf(1.0));
                    resQuant.setCurrency((CurrencyComplete)StepPricePopupInsert.this.allUnits.getChildAt(0).getValue());
                }
                step.setPrice(resQuant);
                step.setUpperLimit(upQuant);
                Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)step, true, false);
                StepPricePopupInsert.this.steps.addChild(n, System.currentTimeMillis());
                StepPricePopupInsert.this.ensureSequenceNumber();
                StepPricePopupInsert.this.popup.createFocusCycle();
                StepPricePopupInsert.this.table.relayoutRequested();
                Table2RowPanel p = StepPricePopupInsert.this.table.getRowPanel4Node(n);
                if (p != null) {
                    p.requestFocusInWindowNow();
                }
            }
        });
        this.table.setComparator(ComparatorRegistry.getComparator(StepComparator.class));
        int delSpace = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + 2 * this.table.getCellPadding();
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.STEP, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(Words.FROM, null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo("", null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo(Words.TO, null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo("", null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo(Words.AMOUNT, null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo("", null, null, null, "", delSpace, delSpace, delSpace));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.24);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.4);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.36);
        ((TableColumnInfo)columns.get(6)).setxExpand(0.0);
        this.table.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.table.getModel().setNode(this.steps);
        this.table.updateOrder();
        this.setLayout(new Layout());
        this.add(this.table);
    }

    public StepPricePopupInsert(boolean useUnit, ListNode steps, List<Node> prodUnitList, Node yieldUnit, RDProvider provider, DtoField name) {
        this(useUnit, steps, prodUnitList, yieldUnit, Words.LOADINGINSTRUCTION_ROW_AMOUNT_PATTERN, true, false, provider, name);
    }

    private void ensureSequenceNumber() {
        int count = 0;
        long currentId = System.currentTimeMillis();
        for (Table2RowPanel p : this.table.getRows()) {
            p.getModel().getNode().getChildNamed(new String[]{"sequenceNumber"}).setValue((Object)count, currentId);
            ++count;
        }
        this.table.updateOrder();
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.table.kill();
        this.table = null;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        return new Object[1];
    }

    @Override
    public boolean isInnerComponent(Component c) {
        for (Table2RowPanel p : this.table.getRows()) {
            TableRowImpl pp = (TableRowImpl)p;
            if (!pp.isInnerComponent(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean tryToGrabFocus() {
        if (this.table.getAddButton() != null) {
            this.table.getAddButton().requestFocusInWindow();
            return true;
        }
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        return this.table.getFocusComponents();
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    NodeListener {
        private static final long serialVersionUID = 1L;
        private TextLabel step;
        private TextLabel from;
        private ArrowConnectorIcon arrow;
        private RDInputComboBox toField;
        private TextLabel equals;
        private RDInputComboBox resultingField;
        private TextLabel unit;
        private DeleteButton delete;
        private Node IReadableNodekill;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            Converter aV = ConverterRegistry.getConverter(IntegerPlusPlusConverter.class);
            this.step = new TextLabel(this.model.getNode().getChildNamed(new String[]{"sequenceNumber"}), aV);
            Converter fromConverter = new Converter(){

                public Object convert(Object o, Node currentNode, Object ... param) {
                    Node seqNr = TableRowImpl.this.model.getNode().getChildNamed(new String[]{"sequenceNumber"});
                    int nIndex = (Integer)seqNr.getValue() - 1;
                    Node quant = TableRowImpl.this.getAmount4Sequence(nIndex);
                    if (quant == null || quant.getValue() == null) {
                        return "0";
                    }
                    String t = "> " + StepPricePopupInsert.this.format.format(quant.getChildNamed(new String[]{"quantity"}).getValue());
                    Node unit = quant.getChildNamed(new String[]{"unit"});
                    if (unit != null && unit.getValue() != null) {
                        Node unS = unit.getChildNamed(new String[]{"shortName"});
                        t = unS != null ? t + " " + (String)unS.getValue() : t + " " + ((UnitComplete)unit.getValue()).getShortName();
                    }
                    return t;
                }

                public Class getParameterClass() {
                    return null;
                }
            };
            this.from = new TextLabel(m.getNode(), fromConverter);
            this.arrow = new ArrowConnectorIcon();
            if (StepPricePopupInsert.this.compUnits != null && StepPricePopupInsert.this.compUnits.getChildCount() > 0) {
                this.toField = new RDInputComboBox(StepPricePopupInsert.this.provider, StepPricePopupInsert.this.isDouble ? InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE : InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG);
                this.toField.setOverrideName(StepPricePopupInsert.this.overrideName);
                this.toField.setNode(m.getNode().getChildNamed(new String[]{"upperLimit-quantity"}), m.getNode().getChildNamed(new String[]{"upperLimit-unit"}));
            } else {
                this.toField = new RDInputComboBox(StepPricePopupInsert.this.provider, StepPricePopupInsert.this.isDouble ? InputComboBox.InputComboBoxType.PRICE_DOUBLE : InputComboBox.InputComboBoxType.PRICE_LONG);
                this.toField.setOverrideName(StepPricePopupInsert.this.overrideName);
                this.toField.setNode(m.getNode().getChildNamed(new String[]{"upperLimit-quantity"}), m.getNode().getChildNamed(new String[]{"upperLimit-unit"}));
            }
            if (StepPricePopupInsert.this.compUnits != null) {
                this.toField.setPossibleUnits((Node)StepPricePopupInsert.this.compUnits);
            }
            this.toField.allowMinus(false);
            this.toField.setMaxKommaStellen(3);
            this.toField.setUseMaxKommaStellen(true);
            this.equals = new TextLabel("=");
            this.resultingField = new RDInputComboBox(StepPricePopupInsert.this.provider, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
            this.resultingField.setOverrideName(StepPricePopupInsert.this.overrideName);
            this.resultingField.setMaxKommaStellen(3);
            this.resultingField.setUseMaxKommaStellen(true);
            this.resultingField.setNode(m.getNode().getChildNamed(new String[]{"price-price"}), m.getNode().getChildNamed(new String[]{"price-currency"}));
            this.resultingField.allowMinus(false);
            this.resultingField.setPossibleUnits((Node)StepPricePopupInsert.this.allUnits);
            if (StepPricePopupInsert.this.showPriceUnit && StepPricePopupInsert.this.compUnits != null) {
                this.unit = new TextLabel("/" + ((UnitConverter)ConverterRegistry.getConverter(UnitConverter.class)).convert((UnitComplete)StepPricePopupInsert.this.compUnits.getChildAt(0).getValue(), null, new Object[0]));
            }
            this.setLayout(new TableRowImplLayout());
            if (StepPricePopupInsert.this.isDeletable) {
                this.delete = new DeleteButton();
                this.delete.addButtonListener(this);
                this.add(this.delete);
            }
            this.from.setProgress(1.0f);
            this.toField.setProgress(1.0f);
            this.resultingField.setProgress(1.0f);
            this.add(this.step);
            this.add(this.from);
            this.add(this.arrow);
            this.add(this.toField);
            this.add(this.equals);
            this.add(this.resultingField);
            if (this.unit != null) {
                this.add(this.unit);
            }
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        public Node getAmount4Sequence(int nr) {
            Iterator it = this.model.getNode().getParent().getChilds();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                Node seqNr = n.getChildNamed(new String[]{"sequenceNumber"});
                if ((Integer)seqNr.getValue() != nr) continue;
                Node d = n.getChildNamed(new String[]{"upperLimit"});
                d.getChildNamed(new String[]{"quantity"}).removeNodeListener((NodeListener)this);
                d.getChildNamed(new String[]{"unit"}).removeNodeListener((NodeListener)this);
                d.getChildNamed(new String[]{"quantity"}).addNodeListener((NodeListener)this);
                d.getChildNamed(new String[]{"unit"}).addNodeListener((NodeListener)this);
                this.IReadableNodekill = d;
                return d;
            }
            return null;
        }

        @Override
        public boolean isInnerComponent(Component c) {
            return false;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.step.setEnabled(isEnabled);
            this.from.setEnabled(isEnabled);
            this.arrow.setEnabled(isEnabled);
            this.toField.setEnabled(isEnabled);
            this.equals.setEnabled(isEnabled);
            this.resultingField.setEnabled(isEnabled);
            if (this.delete != null) {
                this.delete.setEnabled(isEnabled);
            }
            if (this.unit != null) {
                this.unit.setEnabled(isEnabled);
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            if (this.IReadableNodekill != null) {
                this.IReadableNodekill.getChildNamed(new String[]{"quantity"}).removeNodeListener((NodeListener)this);
                this.IReadableNodekill.getChildNamed(new String[]{"unit"}).removeNodeListener((NodeListener)this);
            }
            this.step.kill();
            this.from.kill();
            this.arrow.kill();
            this.toField.kill();
            this.equals.kill();
            this.resultingField.kill();
            if (this.delete != null) {
                this.delete.kill();
            }
            if (this.unit != null) {
                this.unit.kill();
            }
            this.step = null;
            this.from = null;
            this.arrow = null;
            this.toField = null;
            this.equals = null;
            this.resultingField = null;
            this.delete = null;
            this.unit = null;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.toField.requestFocusInWindowNow();
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.toField);
            CheckedListAdder.addToList(a, this.resultingField);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
            }
        }

        public void valueChanged(Node<?> node) {
            Node quant = this.getAmount4Sequence(0);
            if (quant != null) {
                this.model.getNode().getChildNamed(new String[]{"upperLimit-unit"}).setValue(quant.getChildNamed(new String[]{"unit"}).getValue(), System.currentTimeMillis());
            }
            this.from.updateString();
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public boolean isSwingOnly() {
            return true;
        }

        private class TableRowImplLayout
        extends DefaultLayout {
            private TableRowImplLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.step.setLocation((int)((double)w - TableRowImpl.this.step.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - TableRowImpl.this.step.getPreferredSize().getHeight()) / 2);
                TableRowImpl.this.step.setSize(TableRowImpl.this.step.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                int aW = 0;
                TableRowImpl.this.from.setLocation(currentX + StepPricePopupInsert.this.table.getCellPadding(), (int)((parent.getPreferredSize().getHeight() - TableRowImpl.this.from.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.from.setSize(w - 2 * StepPricePopupInsert.this.table.getCellPadding(), (int)TableRowImpl.this.from.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.arrow.setLocation(currentX + (int)(((double)w - TableRowImpl.this.arrow.getPreferredSize().getWidth()) / 2.0), (int)((double)parent.getHeight() - TableRowImpl.this.arrow.getPreferredSize().getHeight()) / 2);
                TableRowImpl.this.arrow.setSize(TableRowImpl.this.arrow.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                aW = w - 4 * StepPricePopupInsert.this.table.getCellPadding();
                TableRowImpl.this.toField.setLocation(currentX + StepPricePopupInsert.this.table.getCellPadding(), (int)((double)parent.getHeight() - TableRowImpl.this.toField.getPreferredSize().getHeight()) / 2);
                TableRowImpl.this.toField.setSize(aW, (int)TableRowImpl.this.toField.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.equals.setLocation(currentX + (int)((double)w - TableRowImpl.this.equals.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - TableRowImpl.this.equals.getPreferredSize().getHeight()) / 2);
                TableRowImpl.this.equals.setSize(TableRowImpl.this.equals.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                TableRowImpl.this.resultingField.setLocation(currentX + StepPricePopupInsert.this.table.getCellPadding(), (int)((double)parent.getHeight() - TableRowImpl.this.resultingField.getPreferredSize().getHeight()) / 2);
                if (TableRowImpl.this.unit != null) {
                    TableRowImpl.this.resultingField.setSize((int)((double)w - ((double)(2 * StepPricePopupInsert.this.table.getCellPadding() + 2) + TableRowImpl.this.unit.getPreferredSize().getWidth())), (int)TableRowImpl.this.resultingField.getPreferredSize().getHeight());
                    TableRowImpl.this.unit.setLocation(TableRowImpl.this.resultingField.getX() + TableRowImpl.this.resultingField.getWidth() + 2, (int)(((double)parent.getHeight() - TableRowImpl.this.unit.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.unit.setSize(TableRowImpl.this.unit.getPreferredSize());
                } else {
                    TableRowImpl.this.resultingField.setSize(w - 2 * StepPricePopupInsert.this.table.getCellPadding(), (int)TableRowImpl.this.resultingField.getPreferredSize().getHeight());
                }
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(6);
                if (TableRowImpl.this.delete != null) {
                    TableRowImpl.this.delete.setLocation(currentX + (int)((double)w - TableRowImpl.this.delete.getPreferredSize().getWidth()) / 2, (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            StepPricePopupInsert.this.table.setLocation(0, 0);
            StepPricePopupInsert.this.table.setSize(parent.getWidth(), parent.getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(500, 250);
        }
    }
}

