/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts.spotcheck;

import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.tables.MailTable;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.TimerServiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SpotCheckServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.DataTransferProtocolE;
import ch.icit.pegasus.server.core.dtos.dataexchange.EMailDataExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.EMailDataExchangeSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.EMailReceiptComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.spotcheck.allergen.AllergenSpotCheckSettingsComplete;
import ch.icit.pegasus.server.core.dtos.spotcheck.allergen.AllergenSpotCheckSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.util.DailyTimeComplete;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class PurchaseAllergenSpotCheckExchangeInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<CheckBox> useSpotCheck;
    private TitledItem<CheckBox> autoGenerate;
    private TitledItem<TextField> headerTemplate;
    private TitledItem<TextField> defaultMailSender;
    private BorderedInletPanel sendPanel;
    private BorderedInletPanel configPanel;
    private TablePanelAddSaveButton sendButton;
    private TablePanelAddSaveButton saveButton;
    private MailTable usersToInform;
    private final DataExchangeModule module;
    protected Node<AllergenSpotCheckSettingsComplete> settings;
    protected AllergenSpotCheckSettingsComplete rimtesc;

    public PurchaseAllergenSpotCheckExchangeInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
    }

    @Override
    public void insertElements() {
        this.configPanel = new BorderedInletPanel(true);
        this.configPanel.setTitleText(Words.CONFIG);
        this.configPanel.setHasBackground(true);
        this.useSpotCheck = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(AllergenSpotCheckSettingsComplete_.useSpotCheck)), "Enable Spot Check", TitledItem.TitledItemOrientation.EAST);
        this.useSpotCheck.getElement().addButtonListener(this);
        this.autoGenerate = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(AllergenSpotCheckSettingsComplete_.autoGenerate)), "Auto Generate Spot Checks", TitledItem.TitledItemOrientation.EAST);
        this.headerTemplate = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(new DtoField[]{AllergenSpotCheckSettingsComplete_.mailDataExchangeSettings, EMailDataExchangeSettingsComplete_.mailHeaderTemplate})), Words.HEADER_TEMPLATE, TitledItem.TitledItemOrientation.NORTH);
        this.defaultMailSender = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(new DtoField[]{AllergenSpotCheckSettingsComplete_.mailDataExchangeSettings, EMailDataExchangeSettingsComplete_.defaultMailSender})), Words.MAIL_SENDER, TitledItem.TitledItemOrientation.NORTH);
        this.usersToInform = new MailTable(){

            @Override
            public Node createNewNode() {
                EMailReceiptComplete receipt = new EMailReceiptComplete();
                receipt.setClientOId(Long.valueOf(ADTO.getNextId()));
                receipt.setMailAddress("");
                return INodeCreator.getDefaultImpl().getNode4DTO((Object)receipt, true, false);
            }
        };
        this.usersToInform.getModel().setNode(this.settings.getChildNamed(new DtoField[]{AllergenSpotCheckSettingsComplete_.mailDataExchangeSettings, EMailDataExchangeSettingsComplete_.mailReceipts}));
        this.sendPanel = new BorderedInletPanel(true);
        this.sendPanel.setTitleText(Words.EXCHANGE_HISTORY);
        this.sendPanel.setHasBackground(true);
        this.sendButton = new TablePanelAddSaveButton();
        this.sendButton.setText(Words.SEND);
        this.sendButton.addButtonListener(this);
        this.saveButton = new TablePanelAddSaveButton();
        this.saveButton.setText(Words.SAVE);
        this.saveButton.addButtonListener(this);
        this.setLayout(new Layout());
        this.sendPanel.setLayout(new SendLayout());
        this.configPanel.setLayout(new ConfigLayout());
        this.configPanel.add(this.useSpotCheck);
        this.configPanel.add(this.autoGenerate);
        this.configPanel.add(this.headerTemplate);
        this.configPanel.add(this.defaultMailSender);
        this.configPanel.add(this.saveButton);
        this.configPanel.add(this.usersToInform);
        this.sendPanel.add(this.sendButton);
        this.add(this.configPanel);
        this.add(this.sendPanel);
    }

    private void ensureAnimation(String text) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(text);
            this.add((Component)this.animation, 0);
        }
        this.animation.start();
        this.animation.fadeIn();
        this.revalidate();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                try {
                    PurchaseAllergenSpotCheckExchangeInsert.this.rimtesc = (AllergenSpotCheckSettingsComplete)((SpotCheckServiceManager)ServiceManagerRegistry.getService(SpotCheckServiceManager.class)).getAllergenSettings().getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (PurchaseAllergenSpotCheckExchangeInsert.this.rimtesc == null) {
                    AllergenSpotCheckSettingsComplete s = new AllergenSpotCheckSettingsComplete();
                    s.setClientOId(Long.valueOf(ADTO.getNextId()));
                    PurchaseAllergenSpotCheckExchangeInsert.this.rimtesc = s;
                }
                PurchaseAllergenSpotCheckExchangeInsert.this.rimtesc.setTimerServiceSettings(PurchaseAllergenSpotCheckExchangeInsert.this.createDailyTimerService());
                if (PurchaseAllergenSpotCheckExchangeInsert.this.rimtesc.getMailDataExchangeSettings() == null) {
                    EMailDataExchangeSettingsComplete mailSetting = new EMailDataExchangeSettingsComplete();
                    mailSetting.setClientOId(Long.valueOf(ADTO.getNextId()));
                    PurchaseAllergenSpotCheckExchangeInsert.this.rimtesc.setMailDataExchangeSettings(mailSetting);
                }
                PurchaseAllergenSpotCheckExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)PurchaseAllergenSpotCheckExchangeInsert.this.rimtesc, false, false);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PurchaseAllergenSpotCheckExchangeInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private TimerServiceSettingsComplete createDailyTimerService() {
        TimerServiceSettingsComplete s = new TimerServiceSettingsComplete();
        s.setTimerServiceConfig((TimerServiceConfigComplete)new DailyTimeComplete(Integer.valueOf(0), Integer.valueOf(10)));
        s.getTimerServiceConfig().setClientOId(Long.valueOf(ADTO.getNextId()));
        return s;
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.useSpotCheck.setEnabled(isEnabled);
            boolean b = isEnabled && this.useSpotCheck.getElement().isChecked();
            this.sendButton.setEnabled(b);
            this.autoGenerate.setEnabled(b);
            this.headerTemplate.setEnabled(b);
            this.defaultMailSender.setEnabled(isEnabled);
            this.saveButton.setEnabled(isEnabled);
            this.usersToInform.setEnabled(b);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.sendPanel.kill();
            this.configPanel.kill();
            this.autoGenerate.kill();
            this.headerTemplate.kill();
            this.defaultMailSender.kill();
            this.saveButton.kill();
            this.useSpotCheck.kill();
            this.usersToInform.kill();
            this.usersToInform = null;
        }
        this.sendPanel = null;
        this.configPanel = null;
        this.sendButton = null;
        this.autoGenerate = null;
        this.defaultMailSender = null;
        this.headerTemplate = null;
        this.saveButton = null;
        this.useSpotCheck = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return Words.RETAIL_INMOTION;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.sendButton || source == this.saveButton) {
            this.setEnabled(false);
            if (source == this.sendButton) {
                this.ensureAnimation("Generate Spot Check");
                this.processFiles();
            } else if (source == this.saveButton) {
                this.ensureAnimation(Words.SAVE_DATA);
                this.saveConfig();
            }
            this.module.started();
        } else {
            this.setEnabled(this.isEnabled());
        }
    }

    private void saveConfig() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                PurchaseAllergenSpotCheckExchangeInsert.this.settings.commit(AllergenSpotCheckSettingsComplete.class);
                AllergenSpotCheckSettingsComplete rimtesc = (AllergenSpotCheckSettingsComplete)PurchaseAllergenSpotCheckExchangeInsert.this.settings.getValue();
                rimtesc.getMailDataExchangeSettings().setDataExchangeProtocol(DataTransferProtocolE.EMAIL);
                List<Table2RowPanel> uTIFList = PurchaseAllergenSpotCheckExchangeInsert.this.usersToInform.getRows();
                rimtesc.getMailDataExchangeSettings().setMailReceipts(new ArrayList());
                for (Table2RowPanel utif : uTIFList) {
                    EMailReceiptComplete l = (EMailReceiptComplete)utif.getModel().getNode().getValue();
                    if (rimtesc.getMailDataExchangeSettings().getMailReceipts().contains(l)) continue;
                    rimtesc.getMailDataExchangeSettings().getMailReceipts().add(l);
                }
                if (Boolean.TRUE.equals(rimtesc.getUseSpotCheck())) {
                    rimtesc.setTimerServiceSettings(PurchaseAllergenSpotCheckExchangeInsert.this.createDailyTimerService());
                    TimerServiceSettingsComplete ts = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(rimtesc.getTimerServiceSettings()).getValue();
                    rimtesc.setTimerServiceSettings(ts);
                    rimtesc = (AllergenSpotCheckSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)rimtesc).getValue();
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.ALLERGEN_SPOT_CHECK, rimtesc.getAutoGenerate().booleanValue(), ts, -1L);
                } else {
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.ALLERGEN_SPOT_CHECK);
                    rimtesc = (AllergenSpotCheckSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)rimtesc).getValue();
                    PurchaseAllergenSpotCheckExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)rimtesc, false, false);
                    ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        PurchaseAllergenSpotCheckExchangeInsert.this.hideAnimation();
                        PurchaseAllergenSpotCheckExchangeInsert.this.module.ended();
                        PurchaseAllergenSpotCheckExchangeInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)PurchaseAllergenSpotCheckExchangeInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void processFiles() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node n = new Node();
                ((SpotCheckServiceManager)ServiceManagerRegistry.getService(SpotCheckServiceManager.class)).generateAllergenSpotCheck();
                n.setValue((Object)true, 0L);
                PurchaseAllergenSpotCheckExchangeInsert.this.rimtesc = (AllergenSpotCheckSettingsComplete)((SpotCheckServiceManager)ServiceManagerRegistry.getService(SpotCheckServiceManager.class)).getAllergenSettings().getValue();
                PurchaseAllergenSpotCheckExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)PurchaseAllergenSpotCheckExchangeInsert.this.rimtesc, false, false);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        boolean read = (Boolean)node.getValue();
                        PurchaseAllergenSpotCheckExchangeInsert.this.hideAnimation();
                        PurchaseAllergenSpotCheckExchangeInsert.this.module.ended();
                        PurchaseAllergenSpotCheckExchangeInsert.this.setEnabled(true);
                        if (read) {
                            InnerPopupFactory.showMessageDialog(Words.SUCCESSFULLY_IMPORTED, PurchaseAllergenSpotCheckExchangeInsert.this.sendButton);
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, "Unable to generate Spot Check", (Component)PurchaseAllergenSpotCheckExchangeInsert.this.sendButton);
                        PurchaseAllergenSpotCheckExchangeInsert.this.hideAnimation();
                        PurchaseAllergenSpotCheckExchangeInsert.this.setEnabled(true);
                        PurchaseAllergenSpotCheckExchangeInsert.this.module.ended();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class ConfigLayout
    extends DefaultLayout {
        private ConfigLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            PurchaseAllergenSpotCheckExchangeInsert.this.configPanel.layoutTitle(parent);
            int border = 10;
            PurchaseAllergenSpotCheckExchangeInsert.this.useSpotCheck.setLocation(border, border + PurchaseAllergenSpotCheckExchangeInsert.this.configPanel.getTitleHeight());
            PurchaseAllergenSpotCheckExchangeInsert.this.useSpotCheck.setSize(PurchaseAllergenSpotCheckExchangeInsert.this.useSpotCheck.getPreferredSize());
            PurchaseAllergenSpotCheckExchangeInsert.this.autoGenerate.setLocation(border, PurchaseAllergenSpotCheckExchangeInsert.this.useSpotCheck.getY() + PurchaseAllergenSpotCheckExchangeInsert.this.useSpotCheck.getHeight());
            PurchaseAllergenSpotCheckExchangeInsert.this.autoGenerate.setSize(PurchaseAllergenSpotCheckExchangeInsert.this.autoGenerate.getPreferredSize());
            PurchaseAllergenSpotCheckExchangeInsert.this.headerTemplate.setLocation(border, PurchaseAllergenSpotCheckExchangeInsert.this.autoGenerate.getY() + PurchaseAllergenSpotCheckExchangeInsert.this.autoGenerate.getHeight() + border);
            PurchaseAllergenSpotCheckExchangeInsert.this.headerTemplate.setSize(220, (int)PurchaseAllergenSpotCheckExchangeInsert.this.headerTemplate.getPreferredSize().getHeight());
            PurchaseAllergenSpotCheckExchangeInsert.this.defaultMailSender.setLocation(PurchaseAllergenSpotCheckExchangeInsert.this.headerTemplate.getX() + PurchaseAllergenSpotCheckExchangeInsert.this.headerTemplate.getWidth() + border, PurchaseAllergenSpotCheckExchangeInsert.this.headerTemplate.getY());
            PurchaseAllergenSpotCheckExchangeInsert.this.defaultMailSender.setSize(220, (int)PurchaseAllergenSpotCheckExchangeInsert.this.defaultMailSender.getPreferredSize().getHeight());
            PurchaseAllergenSpotCheckExchangeInsert.this.saveButton.setLocation((int)((double)parent.getWidth() - PurchaseAllergenSpotCheckExchangeInsert.this.saveButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - ((double)border + PurchaseAllergenSpotCheckExchangeInsert.this.saveButton.getPreferredSize().getHeight())));
            PurchaseAllergenSpotCheckExchangeInsert.this.saveButton.setSize(PurchaseAllergenSpotCheckExchangeInsert.this.saveButton.getPreferredSize());
            PurchaseAllergenSpotCheckExchangeInsert.this.usersToInform.setLocation(border, PurchaseAllergenSpotCheckExchangeInsert.this.defaultMailSender.getY() + PurchaseAllergenSpotCheckExchangeInsert.this.defaultMailSender.getHeight() + border);
            PurchaseAllergenSpotCheckExchangeInsert.this.usersToInform.setSize(parent.getWidth() - 2 * PurchaseAllergenSpotCheckExchangeInsert.this.usersToInform.getX(), 150);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }
    }

    private class SendLayout
    extends DefaultLayout {
        private SendLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            PurchaseAllergenSpotCheckExchangeInsert.this.sendPanel.layoutTitle(parent);
            int border = 10;
            PurchaseAllergenSpotCheckExchangeInsert.this.sendButton.setLocation((int)((double)parent.getWidth() - PurchaseAllergenSpotCheckExchangeInsert.this.sendButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - (PurchaseAllergenSpotCheckExchangeInsert.this.sendButton.getPreferredSize().getHeight() + (double)border)));
            PurchaseAllergenSpotCheckExchangeInsert.this.sendButton.setSize(PurchaseAllergenSpotCheckExchangeInsert.this.sendButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (PurchaseAllergenSpotCheckExchangeInsert.this.animation != null) {
                PurchaseAllergenSpotCheckExchangeInsert.this.animation.setLocation((int)((double)parent.getWidth() - PurchaseAllergenSpotCheckExchangeInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - PurchaseAllergenSpotCheckExchangeInsert.this.animation.getPreferredSize().getHeight()) / 2);
                PurchaseAllergenSpotCheckExchangeInsert.this.animation.setSize(PurchaseAllergenSpotCheckExchangeInsert.this.animation.getPreferredSize());
            }
            if (PurchaseAllergenSpotCheckExchangeInsert.this.isInserted) {
                PurchaseAllergenSpotCheckExchangeInsert.this.configPanel.setLocation(border, border);
                PurchaseAllergenSpotCheckExchangeInsert.this.configPanel.setSize((parent.getWidth() - 3 * border) / 2, parent.getHeight() - 2 * border);
                PurchaseAllergenSpotCheckExchangeInsert.this.sendPanel.setLocation(PurchaseAllergenSpotCheckExchangeInsert.this.configPanel.getX() + PurchaseAllergenSpotCheckExchangeInsert.this.configPanel.getWidth() + border, border);
                PurchaseAllergenSpotCheckExchangeInsert.this.sendPanel.setSize(PurchaseAllergenSpotCheckExchangeInsert.this.configPanel.getWidth(), parent.getHeight() - 2 * border);
            }
        }
    }
}

