/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts;

import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.ScrollPane;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelKillable;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.TimerServiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.quality.QualityServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.QualitySettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.QualitySettingsComplete_;
import ch.icit.pegasus.server.core.dtos.util.DailyTimeComplete;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class QualityExchangeInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private BorderedInletPanel sendPanel;
    private BorderedInletPanel configPanel;
    private ScrollPane scrollPane;
    private JPanelKillable contentPane;
    private TitledItem<CheckBox> useCCP02Generators;
    private TablePanelAddSaveButton saveButton;
    private TablePanelAddSaveButton generateCCP02;
    private final DataExchangeModule module;
    protected Node<QualitySettingsComplete> settings;
    protected QualitySettingsComplete edsc;

    public QualityExchangeInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
    }

    @Override
    public void insertElements() {
        this.configPanel = new BorderedInletPanel(true);
        this.configPanel.setTitleText(Words.CONFIG);
        this.configPanel.setHasBackground(true);
        this.contentPane = new JPanelKillable();
        this.contentPane.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
        this.scrollPane = new ScrollPane();
        this.scrollPane.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
        this.scrollPane.getHorizontalScrollBar().setBackground(this.scrollPane.getBackground());
        this.scrollPane.getVerticalScrollBar().setBackground(this.scrollPane.getBackground());
        this.scrollPane.setViewportView(this.contentPane);
        this.useCCP02Generators = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(QualitySettingsComplete_.useCCP02Generator)), "Use CCP02 Generator", TitledItem.TitledItemOrientation.EAST);
        this.useCCP02Generators.getElement().addButtonListener(this);
        this.sendPanel = new BorderedInletPanel(true);
        this.sendPanel.setTitleText("Save");
        this.sendPanel.setHasBackground(true);
        this.saveButton = new TablePanelAddSaveButton();
        this.saveButton.setText(Words.SAVE);
        this.saveButton.addButtonListener(this);
        this.generateCCP02 = new TablePanelAddSaveButton();
        this.generateCCP02.setText("Generate CCP02");
        this.generateCCP02.addButtonListener(this);
        this.setLayout(new Layout());
        this.sendPanel.setLayout(new SendLayout());
        this.contentPane.setLayout(new ConfigLayout());
        this.configPanel.setLayout(new ScrollPaneLayout());
        this.contentPane.add(this.useCCP02Generators);
        this.configPanel.add(this.scrollPane);
        this.sendPanel.add(this.saveButton);
        this.sendPanel.add(this.generateCCP02);
        this.add(this.configPanel);
        this.add(this.sendPanel);
    }

    private void ensureAnimation(String text) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(text);
            this.add((Component)this.animation, 0);
        }
        this.animation.start();
        this.animation.fadeIn();
        this.revalidate();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                try {
                    QualityExchangeInsert.this.edsc = (QualitySettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getQualitySettings().getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                QualityExchangeInsert.this.edsc.setTimerServiceCCPGenerator(QualityExchangeInsert.this.createTimerServiceCCP02());
                QualityExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)QualityExchangeInsert.this.edsc, false, false);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return QualityExchangeInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.useCCP02Generators.setEnabled(isEnabled);
            this.saveButton.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.sendPanel.kill();
            this.configPanel.kill();
            this.scrollPane.kill();
            this.saveButton.kill();
            this.generateCCP02.kill();
            this.useCCP02Generators.kill();
            this.scrollPane = null;
            this.saveButton = null;
            this.generateCCP02 = null;
        }
        this.sendPanel = null;
        this.configPanel = null;
        this.useCCP02Generators = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return "Quality Generators";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.saveButton) {
            List<ScreenValidationObject> a = this.validateLevelCheck();
            if (a.isEmpty()) {
                this.ensureAnimation(Words.SAVE_DATA);
                this.saveConfig();
                return;
            }
            InnerPopupFactory.showErrorDialog(a, Words.UNABLE_TO_SAVE, (Component)this);
            this.setEnabled(true);
            return;
        }
        if (source == this.generateCCP02) {
            this.startAnimation("Generate CCP02");
            this.setEnabled(false);
            ThreadSafeExecutable run = new ThreadSafeExecutable(){

                @Override
                public Node<?> loadData() throws Exception {
                    ((QualityServiceManager)ServiceManagerRegistry.getService(QualityServiceManager.class)).generateCCP0102();
                    ViewNode n = new ViewNode("ret");
                    return n;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            QualityExchangeInsert.this.stopAnimation();
                            QualityExchangeInsert.this.setEnabled(true);
                            InnerPopupFactory.showMessage("CCP02 Generator", "CCP02 Data Updated", null, QualityExchangeInsert.this);
                        }

                        public void errorOccurred(ClientException exception) {
                            QualityExchangeInsert.this.stopAnimation();
                            QualityExchangeInsert.this.setEnabled(true);
                            InnerPopupFactory.showErrorDialog((Exception)exception, (Component)QualityExchangeInsert.this);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
            return;
        }
        this.setEnabled(this.isEnabled());
    }

    private List<ScreenValidationObject> validateLevelCheck() {
        return new ArrayList<ScreenValidationObject>();
    }

    private void saveConfig() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                QualityExchangeInsert.this.settings.commit(QualitySettingsComplete.class);
                QualitySettingsComplete rimsc = (QualitySettingsComplete)QualityExchangeInsert.this.settings.getValue();
                rimsc.setTimerServiceCCPGenerator(QualityExchangeInsert.this.createTimerServiceCCP02());
                if (Boolean.TRUE.equals(rimsc.getUseCCP02Generator())) {
                    rimsc = (QualitySettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)rimsc).getValue();
                    TimerServiceSettingsComplete ts = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(rimsc.getTimerServiceCCPGenerator()).getValue();
                    rimsc.setTimerServiceCCPGenerator(ts);
                    rimsc = (QualitySettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)rimsc).getValue();
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.CCP02_DATA_GENERATOR, rimsc.getUseCCP02Generator().booleanValue(), ts, -1L);
                } else {
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.CCP02_DATA_GENERATOR);
                    rimsc = (QualitySettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)rimsc).getValue();
                }
                Node s = ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
                Node settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)rimsc, false, false);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        QualityExchangeInsert.this.hideAnimation();
                        QualityExchangeInsert.this.module.ended();
                        QualityExchangeInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)QualityExchangeInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private TimerServiceSettingsComplete createTimerServiceCCP02() {
        TimerServiceSettingsComplete ts = new TimerServiceSettingsComplete();
        ts.setClientOId(Long.valueOf(ADTO.getNextId()));
        ts.setTimerServiceConfig((TimerServiceConfigComplete)new DailyTimeComplete(Integer.valueOf(3), Integer.valueOf(5)));
        ts.getTimerServiceConfig().setClientOId(Long.valueOf(ADTO.getNextId()));
        return ts;
    }

    private class ScrollPaneLayout
    extends DefaultLayout {
        private ScrollPaneLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            QualityExchangeInsert.this.configPanel.layoutTitle(parent);
            QualityExchangeInsert.this.scrollPane.setLocation(1, QualityExchangeInsert.this.configPanel.getTitleHeight());
            QualityExchangeInsert.this.scrollPane.setSize(parent.getWidth() - 2, parent.getHeight() - (QualityExchangeInsert.this.configPanel.getTitleHeight() + 1));
        }
    }

    private class ConfigLayout
    extends DefaultLayout {
        private ConfigLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            QualityExchangeInsert.this.useCCP02Generators.setLocation(border, border);
            QualityExchangeInsert.this.useCCP02Generators.setSize(QualityExchangeInsert.this.useCCP02Generators.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int border;
            int h = border = 10;
            h = (int)((double)h + QualityExchangeInsert.this.useCCP02Generators.getPreferredSize().getHeight());
            return new Dimension(0, h += border);
        }
    }

    private class SendLayout
    extends DefaultLayout {
        private SendLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            QualityExchangeInsert.this.sendPanel.layoutTitle(parent);
            int border = 10;
            QualityExchangeInsert.this.saveButton.setLocation(border, (int)((double)parent.getHeight() - (QualityExchangeInsert.this.saveButton.getPreferredSize().getHeight() + (double)border)));
            QualityExchangeInsert.this.saveButton.setSize(QualityExchangeInsert.this.saveButton.getPreferredSize());
            QualityExchangeInsert.this.generateCCP02.setLocation(border, (int)((double)QualityExchangeInsert.this.saveButton.getY() - (QualityExchangeInsert.this.generateCCP02.getPreferredSize().getHeight() + (double)border)));
            QualityExchangeInsert.this.generateCCP02.setSize(QualityExchangeInsert.this.generateCCP02.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (QualityExchangeInsert.this.animation != null) {
                QualityExchangeInsert.this.animation.setLocation((int)((double)parent.getWidth() - QualityExchangeInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - QualityExchangeInsert.this.animation.getPreferredSize().getHeight()) / 2);
                QualityExchangeInsert.this.animation.setSize(QualityExchangeInsert.this.animation.getPreferredSize());
            }
            if (QualityExchangeInsert.this.isInserted) {
                QualityExchangeInsert.this.configPanel.setLocation(border, border);
                QualityExchangeInsert.this.configPanel.setSize((parent.getWidth() - 3 * border) / 2, parent.getHeight() - 2 * border);
                QualityExchangeInsert.this.sendPanel.setLocation(QualityExchangeInsert.this.configPanel.getX() + QualityExchangeInsert.this.configPanel.getWidth() + border, border);
                QualityExchangeInsert.this.sendPanel.setSize(QualityExchangeInsert.this.configPanel.getWidth(), parent.getHeight() - 2 * border);
            }
        }
    }
}

