/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.chargetracking2.details;

import ch.icit.pegasus.client.converter.ChargeTransactionConverter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.QuantityConverter2Decimal;
import ch.icit.pegasus.client.converter.UserConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.PagedTableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2HeaderPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.util.toolkits.OrderToolkit;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderTransactionComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockInventoryComplete_;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockTransactionComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class TransactionDetailsPanel
extends PagedTableDetailsPanel<ArticleChargeLight> {
    public TransactionDetailsPanel(RowEditor<ArticleChargeLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.TRANSACTIONS);
    }

    @Override
    public void setNode(Node<?> node) {
        this.table.getModel().setNode((Node)new ViewNode("results"));
        this.table.updateTable();
        this.table.invokeDefaultSearch();
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.DATE, null, null, null, "", TableColumnInfo.dateTimeColumnWidth));
        columns.add(new TableColumnInfo(Words.USER, null, null, null, "", TableColumnInfo.dateTimeColumnWidth));
        columns.add(new TableColumnInfo(Words.TYPE, null, null, null, "", TableColumnInfo.dateTimeColumnWidth));
        columns.add(new TableColumnInfo(Words.REMARK, null, null, null, "", TableColumnInfo.dateTimeColumnWidth));
        columns.add(new TableColumnInfo(Words.QUANTITY, null, null, null, "", TableColumnInfo.dateTimeColumnWidth));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.2);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.2);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.2);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.2);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.2);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setTitleText(Words.TRANSACTIONS);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void childRemoved() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        if (isHeader) {
            return new Table2HeaderPanel(model, 7);
        }
        return new TransactionTableRowImpl(model);
    }

    private class TransactionTableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel date;
        private TextLabel user;
        private TextLabel type;
        private TextLabel quantity;
        private TextLabel remark;
        private InfoButton articleInfo;

        public TransactionTableRowImpl(Table2RowModel m) {
            super(m);
            this.setLayout(new InnerLayout());
            this.date = new TextLabel(m.getNode().getChildNamed(StockTransactionComplete_.date), ConverterRegistry.getConverter(DateTimeConverter.class));
            this.user = new TextLabel(m.getNode().getChildNamed(StockTransactionComplete_.user), ConverterRegistry.getConverter(UserConverter.class));
            this.type = new TextLabel(m.getNode(), ConverterRegistry.getConverter(ChargeTransactionConverter.class));
            this.remark = new TextLabel(m.getNode().getChildNamed(StockInventoryComplete_.remark));
            this.quantity = new TextLabel(m.getNode().getChildNamed(StockTransactionComplete_.amount), ConverterRegistry.getConverter(QuantityConverter2Decimal.class));
            if (m.getNode().getValue() instanceof PurchaseOrderTransactionComplete) {
                this.articleInfo = new InfoButton();
                PurchaseOrderTransactionComplete data = (PurchaseOrderTransactionComplete)m.getNode().getValue();
                if (data.getOrderPosition() == null) {
                    this.articleInfo.installStringViewer(OrderToolkit.createInfoInsert(data));
                } else {
                    this.articleInfo.installStringViewer(OrderToolkit.createInfoInsert(data.getOrderPosition().getOrder()));
                }
                this.add(this.articleInfo);
            }
            this.add(this.date);
            this.add(this.user);
            this.add(this.type);
            this.add(this.quantity);
            this.add(this.remark);
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(StockTransactionComplete_.date).getValue();
                }
                case 1: {
                    return this.user.getText();
                }
            }
            return this.model.getNode().getChildNamed(StockTransactionComplete_.date).getValue();
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.date.setEnabled(isEnabled);
            this.user.setEnabled(isEnabled);
            this.type.setEnabled(isEnabled);
            this.quantity.setEnabled(isEnabled);
            this.remark.setEnabled(isEnabled);
            if (this.articleInfo != null) {
                this.articleInfo.setEnabled(true);
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.date.kill();
            this.date = null;
            this.user.kill();
            this.user = null;
            this.type.kill();
            this.type = null;
            this.quantity.kill();
            this.quantity = null;
            this.remark.kill();
            this.remark = null;
            if (this.articleInfo != null) {
                this.articleInfo.kill();
                this.articleInfo = null;
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            return new ArrayList<Component>();
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TransactionTableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TransactionTableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                TransactionTableRowImpl.this.date.setLocation(TransactionTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TransactionTableRowImpl.this.date.getPreferredSize().getHeight()) / 2.0));
                TransactionTableRowImpl.this.date.setSize(w, (int)TransactionTableRowImpl.this.date.getPreferredSize().getHeight());
                currentX += w;
                w = TransactionTableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TransactionTableRowImpl.this.user.setLocation(currentX + TransactionTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TransactionTableRowImpl.this.user.getPreferredSize().getHeight()) / 2.0));
                TransactionTableRowImpl.this.user.setSize(w - 1 * TransactionTableRowImpl.this.getCellPadding(), (int)TransactionTableRowImpl.this.user.getPreferredSize().getHeight());
                currentX += w;
                w = TransactionTableRowImpl.this.model.getParentModel().getColumnWidth(2);
                if (TransactionTableRowImpl.this.articleInfo != null) {
                    TransactionTableRowImpl.this.type.setLocation(currentX + TransactionTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TransactionTableRowImpl.this.type.getPreferredSize().getHeight()) / 2.0));
                    TransactionTableRowImpl.this.type.setSize(w - 1 * TransactionTableRowImpl.this.getCellPadding() - ((TransactionTableRowImpl)TransactionTableRowImpl.this).articleInfo.getPreferredSize().width - 4, (int)TransactionTableRowImpl.this.type.getPreferredSize().getHeight());
                    TransactionTableRowImpl.this.articleInfo.setLocation(((TransactionTableRowImpl)TransactionTableRowImpl.this).type.getLocation().x + TransactionTableRowImpl.this.type.getWidth() + 2, (int)(((double)parent.getHeight() - TransactionTableRowImpl.this.articleInfo.getPreferredSize().getHeight()) / 2.0));
                    TransactionTableRowImpl.this.articleInfo.setSize(TransactionTableRowImpl.this.articleInfo.getPreferredSize());
                } else {
                    TransactionTableRowImpl.this.type.setLocation(currentX + TransactionTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TransactionTableRowImpl.this.type.getPreferredSize().getHeight()) / 2.0));
                    TransactionTableRowImpl.this.type.setSize(w - 1 * TransactionTableRowImpl.this.getCellPadding(), (int)TransactionTableRowImpl.this.type.getPreferredSize().getHeight());
                }
                currentX += w;
                w = TransactionTableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TransactionTableRowImpl.this.remark.setLocation(currentX + TransactionTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TransactionTableRowImpl.this.remark.getPreferredSize().getHeight()) / 2.0));
                TransactionTableRowImpl.this.remark.setSize(w - 1 * TransactionTableRowImpl.this.getCellPadding(), (int)TransactionTableRowImpl.this.remark.getPreferredSize().getHeight());
                currentX += w;
                w = TransactionTableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TransactionTableRowImpl.this.quantity.setLocation(currentX + TransactionTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TransactionTableRowImpl.this.quantity.getPreferredSize().getHeight()) / 2.0));
                TransactionTableRowImpl.this.quantity.setSize(w - 1 * TransactionTableRowImpl.this.getCellPadding(), (int)TransactionTableRowImpl.this.quantity.getPreferredSize().getHeight());
            }
        }
    }
}

