/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.chargetracking.details;

import ch.icit.pegasus.client.converter.ArticleOriginConverter;
import ch.icit.pegasus.client.converter.ChargeTransactionConverter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.QuantityConverter2Decimal;
import ch.icit.pegasus.client.converter.StorePositionShortNameConverter;
import ch.icit.pegasus.client.converter.UserConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.chargetracking.details.utils.CustomDocumentsReadOnlyPopUp;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TableRowLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.buttons.HACCPButton;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.buttons.ViewButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.popup.inserts.HACCPCheckPopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.inserts.OPRPCheckPopUpInsert;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDDateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.changelog.ChangeLogServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.StoreServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.toolkits.ArticleToolkit;
import ch.icit.pegasus.client.util.toolkits.OrderToolkit;
import ch.icit.pegasus.server.core.dtos.document.DocumentScanComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleOriginComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.ordering.CustomsDocumentComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.haccp.PurchaseOrderPositionHACCPLogComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderTransactionComplete;
import ch.icit.pegasus.server.core.dtos.search.StockTransactionSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeBatchComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeBatchComplete_;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete_;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight_;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeReference;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockInventoryComplete_;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockTransactionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockTransactionComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.general.IUniversal;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class ChargeDetailsPanel
extends DefaultDetailsPanel<BasicArticleLight>
implements RemoteLoader,
InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    private TitledItem<TextLabel> number;
    private TitledItem<TextLabel> quantity;
    private TitledItem<TextLabel> creationDate;
    private TitledItem<TextLabel> expiryDate;
    private InfoButton expiryDateHistory;
    private TitledItem<RDDateChooser> currencyDate;
    private TitledItem<RDComboBox> originCountry;
    private TextButton customDocumentsButton;
    private TextButton updateCharge;
    private TitledItem<InputComboBox> priceAndUnit;
    private TitledItem<EditButton> editPackaging;
    private TitledItem<HACCPButton> oprp;
    private TitledItem<ViewButton> downloadPoPDF;
    private boolean canEditPackaging = false;
    private Table2 batchTable;
    private Table2 transactionTable;
    private Node<ArticleChargeComplete> chargeNode;
    private Node<List<CustomsDocumentComplete>> customDocuments;
    private Node<List<PackagingQuantityComplete>> packingTableNode;
    private boolean chargeSelected;

    public ChargeDetailsPanel(RowEditor<BasicArticleLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.CHARGES_DETAILS);
        this.canEditPackaging = provider.isWritable(ArticleChargeComplete_.packingQuantities);
        this.number = new TitledItem<TextLabel>(new TextLabel(), Words.getAllFirstCapitalLetters((String)Words.NO_NUMBER), TitledItem.TitledItemOrientation.NORTH);
        this.creationDate = new TitledItem<TextLabel>(new TextLabel(), Words.getAllFirstCapitalLetters((String)Words.CREATION_DATE), TitledItem.TitledItemOrientation.NORTH);
        this.creationDate.getElement().setViewConverter(ConverterRegistry.getConverter(DateConverter.class));
        this.expiryDate = new TitledItem<TextLabel>(new TextLabel(), Words.getAllFirstCapitalLetters((String)Words.EXPIRY_DATE), TitledItem.TitledItemOrientation.NORTH);
        this.expiryDate.getElement().setViewConverter(ConverterRegistry.getConverter(DateConverter.class));
        this.originCountry = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(ArticleOriginConverter.class), true), Words.ORIGIN, TitledItem.TitledItemOrientation.NORTH);
        this.expiryDateHistory = new InfoButton();
        this.currencyDate = new TitledItem<RDDateChooser>(new RDDateChooser(provider), Words.CURRENCY_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.quantity = new TitledItem<TextLabel>(new TextLabel(), Words.getAllFirstCapitalLetters((String)Words.QUANTITY), TitledItem.TitledItemOrientation.NORTH);
        this.quantity.getElement().setViewConverter(ConverterRegistry.getConverter(QuantityConverter2Decimal.class));
        this.priceAndUnit = new TitledItem<InputComboBox>(new InputComboBox(null, null, InputComboBox.InputComboBoxType.NONE), Words.getAllFirstCapitalLetters((String)Words.PRICE), TitledItem.TitledItemOrientation.NORTH);
        this.updateCharge = new TextButton(Words.UPDATE_CHARGE);
        this.updateCharge.addButtonListener(this);
        this.customDocumentsButton = new TextButton(Words.SHOW_CUSTOMS);
        this.customDocumentsButton.addButtonListener(this);
        this.customDocumentsButton.setEnabled(false);
        this.editPackaging = new TitledItem<EditButton>(new EditButton(), Words.EDIT_CONVERSION, TitledItem.TitledItemOrientation.EAST);
        this.editPackaging.getElement().addButtonListener(this);
        this.oprp = new TitledItem<HACCPButton>(new HACCPButton(), "OPRP Log", TitledItem.TitledItemOrientation.EAST);
        this.oprp.getElement().addButtonListener((source, x, y) -> this.showOPRP(source, x, y));
        this.downloadPoPDF = new TitledItem<ViewButton>(new ViewButton(), "Download Purchase PDF", TitledItem.TitledItemOrientation.EAST);
        this.downloadPoPDF.getElement().addButtonListener((source, x, y) -> this.downloadPDF());
        this.addToView(this.number);
        this.addToView(this.creationDate);
        this.addToView(this.expiryDate);
        this.addToView(this.expiryDateHistory);
        this.addToView(this.quantity);
        this.addToView(this.customDocumentsButton);
        this.addToView(this.priceAndUnit);
        this.addToView(this.currencyDate);
        this.addToView(this.originCountry);
        this.addToView(this.editPackaging);
        this.addToView(this.updateCharge);
        this.addToView(this.oprp);
        this.addToView(this.downloadPoPDF);
        this.addToView(this.createBatchTable());
        this.addToView(this.createTransactionTable());
        this.setCustomLayouter(new Layout());
        this.setEnabled(false);
    }

    private void downloadPDF() {
        if (this.chargeNode == null) {
            InnerPopupFactory.showErrorDialog("Select a Charge first", (Component)this);
            return;
        }
        this.setEnabled(false);
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                ArticleChargeComplete charge = (ArticleChargeComplete)ChargeDetailsPanel.this.chargeNode.getValue(ArticleChargeComplete.class);
                DocumentScanComplete documentScan = (DocumentScanComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).findScanDocument(new ArticleChargeReference(charge.getId())).getValue();
                PegasusFileComplete file = documentScan.getFileData();
                File downloaded = null;
                if (file != null) {
                    downloaded = FileTransferUtil.download((PegasusFileComplete)file, (FileTransferListener[])new FileTransferListener[0]);
                }
                ViewNode fileNode = new ViewNode("");
                fileNode.setValue((Object)downloaded, 0L);
                return fileNode;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        File file = (File)node.getValue();
                        if (file != null) {
                            try {
                                Desktop.getDesktop().open(file);
                            }
                            catch (IOException e) {
                                InnerPopupFactory.showErrorDialog(e, (Component)ChargeDetailsPanel.this);
                            }
                        } else {
                            InnerPopupFactory.showErrorDialog("Purchase PDF scan for charge not found", (Component)ChargeDetailsPanel.this);
                        }
                        ChargeDetailsPanel.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog("Unable to load Purchase PDF for charge", (Component)ChargeDetailsPanel.this);
                        ChargeDetailsPanel.this.setEnabled(true);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void showOPRP(Button source, int x, int y) {
        if (this.chargeNode != null) {
            ArticleChargeComplete charge = (ArticleChargeComplete)this.chargeNode.getValue(ArticleChargeComplete.class);
            PurchaseOrderPositionHACCPLogComplete haccpLog = charge.getHaccpLog();
            if (haccpLog == null) {
                haccpLog = new PurchaseOrderPositionHACCPLogComplete();
                haccpLog.setTruckType("");
                haccpLog.setTruckOk(Boolean.valueOf(false));
                haccpLog.setTemperature(Double.valueOf(-1.0));
                haccpLog.setQualityCondition(Boolean.valueOf(false));
                haccpLog.setOkState(Boolean.valueOf(false));
                haccpLog.setHalalState(charge.getBasicArticle().getHalal());
                haccpLog.setFrozenState(Boolean.valueOf(ArticleToolkit.isFrozenArticle(charge.getBasicArticle())));
                haccpLog.setExpiryDate(charge.getExpiryDate());
                haccpLog.setComment("");
                haccpLog.setChilledState(Boolean.valueOf(ArticleToolkit.isChilledArticle(charge.getBasicArticle())));
                haccpLog.setChargeNo("");
                haccpLog.setPurchaseCharge(Boolean.valueOf(Boolean.TRUE.equals(charge.getBasicArticle().getPurchaseCharge())));
                haccpLog.setNoPurchaseChargeText("NC");
                haccpLog.setCheckDate(new Date(System.currentTimeMillis()));
                haccpLog.setUser((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
                haccpLog.setNoExpiryDate(charge.getBasicArticle().getNoExpiryDate());
                haccpLog.setPurchaseCharge(charge.getBasicArticle().getPurchaseCharge());
            }
            InnerPopupFactory.showHACCPLog(false, null, source, charge.getBasicArticle(), null, null, x, y, new HACCPCheckPopUpInsert.ParameterObject(haccpLog, (ArticleChargeLight)charge), new OPRPCheckPopUpInsert.ParameterObject(haccpLog, (ArticleChargeLight)charge), false, null, false, false);
        }
    }

    private Table2 createBatchTable() {
        this.batchTable = new Table2(false, "", true, true);
        this.batchTable.setTitleText(Words.BATCHES);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.STORE_POSITION, null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo(Words.QUANTITY, null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo(Words.LAST_INVENTORY, null, null, null, "", TableColumnInfo.dateTimeColumnWidth));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.3);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.3);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.3);
        this.batchTable.setModel(new Table2Model(columns, model -> new BatchTableRowImpl(model)));
        return this.batchTable;
    }

    private Table2 createTransactionTable() {
        this.transactionTable = new Table2(false, "", true, true);
        this.transactionTable.setTitleText(Words.TRANSACTIONS);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.DATE, null, null, null, "", TableColumnInfo.dateTimeColumnWidth));
        columns.add(new TableColumnInfo(Words.USER, null, null, null, "", TableColumnInfo.dateTimeColumnWidth));
        columns.add(new TableColumnInfo(Words.TYPE, null, null, null, "", TableColumnInfo.dateTimeColumnWidth));
        columns.add(new TableColumnInfo(Words.REMARK, null, null, null, "", TableColumnInfo.dateTimeColumnWidth));
        columns.add(new TableColumnInfo(Words.QUANTITY, null, null, null, "", TableColumnInfo.dateTimeColumnWidth));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.2);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.2);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.2);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.2);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.2);
        this.transactionTable.setModel(new Table2Model(columns, model -> new TransactionTableRowImpl(model)));
        return this.transactionTable;
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public void setNode(Node<?> node) {
        if (node.getValue() instanceof ArticleChargeReference) {
            this.editor.setEnabled(false);
            this.editor.showCommittingAnimation(Words.LOAD_DATA);
            this.loadCompleteCharge(node);
        }
    }

    private void loadCompleteCharge(final Node<ArticleChargeReference> node) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ArticleChargeComplete chargeComplete = (ArticleChargeComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getCharge(new ArticleChargeReference(((ArticleChargeReference)node.getValue()).getId())).getValue();
                Node chargeCompleteNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)chargeComplete, false, false);
                ListWrapper expiryChangesForCharge = ((ChangeLogServiceManager)ServiceManagerRegistry.getService(ChangeLogServiceManager.class)).findExpiryChangesForCharge(new ArticleChargeReference(chargeComplete.getId()));
                Node expiryHistory = chargeCompleteNode.getChildNamed(new String[]{"expiryHistory"});
                if (expiryHistory == null) {
                    expiryHistory = INodeCreator.getDefaultImpl().createNodes(expiryChangesForCharge.getList(), false, false);
                    expiryHistory.setName("expiryHistory");
                    chargeCompleteNode.addChild(expiryHistory, 0L);
                }
                expiryHistory.setValue((Object)expiryChangesForCharge.getList(), 0L);
                StockTransactionSearchConfiguration transConf = new StockTransactionSearchConfiguration();
                transConf.setCharge((ArticleChargeReference)chargeComplete);
                SearchResultIterator sri = new SearchResultIterator((ASearchConfiguration)transConf);
                ArrayList<IUniversal> stlist = new ArrayList<IUniversal>();
                while (sri.hasNext()) {
                    stlist.add(sri.next());
                }
                if (chargeCompleteNode.getChildNamed(DtoFieldConstants.TRANSACTIONS) == null) {
                    Node transactionsNode = INodeCreator.getDefaultImpl().createNodes(stlist, false);
                    transactionsNode.setName(DtoFieldConstants.TRANSACTIONS);
                    chargeCompleteNode.addChild(transactionsNode, 0L);
                } else {
                    for (StockTransactionComplete stockTransactionComplete : stlist) {
                        chargeCompleteNode.getChildNamed(DtoFieldConstants.TRANSACTIONS).addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)stockTransactionComplete, false, false), 0L);
                    }
                }
                return chargeCompleteNode;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ChargeDetailsPanel.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.number.getElement().setNode(node.getChildNamed(ArticleChargeComplete_.number));
        this.creationDate.getElement().setNode(node.getChildNamed(ArticleChargeComplete_.creationDate));
        this.expiryDate.getElement().setNode(node.getChildNamed(ArticleChargeComplete_.expiryDate));
        this.quantity.getElement().setNode(node.getChildNamed(ArticleChargeComplete_.quantity));
        this.priceAndUnit.getElement().setNode(node.getChildNamed(new DtoField[]{ArticleChargeComplete_.price, PriceComplete_.price}), node.getChildNamed(new DtoField[]{ArticleChargeComplete_.price, PriceComplete_.currency}));
        this.priceAndUnit.getElement().setSecondUnitNode((Node<UnitComplete>)node.getChildNamed(ArticleChargeComplete_.priceUnit));
        Node expiryHistory = node.getChildNamed(new String[]{"expiryHistory"});
        if (expiryHistory != null) {
            this.expiryDateHistory.installStringViewer(ArticleToolkit.createExpiryChangeLog((List)expiryHistory.getValue()));
        }
        this.originCountry.getElement().refreshPossibleValues(NodeToolkit.getAffixList(ArticleOriginComplete.class));
        this.originCountry.getElement().setNode(node.getChildNamed(ArticleChargeLight_.origin));
        this.customDocuments = node.getChildNamed(ArticleChargeComplete_.documents);
        this.packingTableNode = node.getChildNamed(ArticleChargeComplete_.packingQuantities);
        this.currencyDate.getElement().setNode(node.getChildNamed(ArticleChargeComplete_.currencyDate));
        this.batchTable.getModel().setNode(node.getChildNamed(ArticleChargeComplete_.batches));
        this.batchTable.updateTable();
        this.transactionTable.getModel().setNode(node.getChildNamed(DtoFieldConstants.TRANSACTIONS));
        this.transactionTable.updateTable();
        this.chargeNode = node;
        this.chargeSelected = true;
        this.editor.setEnabled(true);
        this.editor.hideCommittingAnimation();
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.number.kill();
        this.quantity.kill();
        this.creationDate.kill();
        this.expiryDate.kill();
        this.expiryDateHistory.kill();
        this.currencyDate.kill();
        this.customDocumentsButton.kill();
        this.priceAndUnit.kill();
        this.batchTable.kill();
        this.transactionTable.kill();
        this.originCountry.kill();
        this.updateCharge.kill();
        this.oprp.kill();
        this.downloadPoPDF.kill();
        this.number = null;
        this.quantity = null;
        this.creationDate = null;
        this.expiryDate = null;
        this.expiryDateHistory = null;
        this.currencyDate = null;
        this.customDocumentsButton = null;
        this.priceAndUnit = null;
        this.batchTable = null;
        this.transactionTable = null;
        this.originCountry = null;
        this.updateCharge = null;
        this.oprp = null;
        this.downloadPoPDF = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.quantity.setEnabled(isEnabled);
        this.creationDate.setEnabled(isEnabled);
        this.expiryDate.setEnabled(isEnabled);
        this.expiryDateHistory.setEnabled(isEnabled);
        this.priceAndUnit.setEnabled(isEnabled);
        this.batchTable.setEnabled(isEnabled);
        this.transactionTable.setEnabled(isEnabled);
        this.number.setEnabled(isEnabled);
        this.customDocumentsButton.setEnabled(isEnabled);
        this.currencyDate.setEnabled(isEnabled);
        this.originCountry.setEnabled(isEnabled);
        if (!isEnabled || !this.canEditPackaging || this.chargeSelected) {
            // empty if block
        }
        this.editPackaging.setEnabled(false);
        if (isEnabled) {
            // empty if block
        }
        this.updateCharge.setEnabled(false);
        this.oprp.setEnabled(isEnabled);
        this.downloadPoPDF.setEnabled(isEnabled);
    }

    @Override
    public void errorOccurred(ClientException exception) {
        this.editor.setEnabled(true);
        this.editor.hideCommittingAnimation();
        this.setEnabled(false);
        super.errorOccurred(exception);
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source == this.customDocumentsButton && this.customDocuments != null) {
            InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
            popUp.setAttributes(source, true, true, Words.CUSTOMS_DOCUMENTS);
            popUp.hideCancelButton();
            popUp.setView(new CustomDocumentsReadOnlyPopUp(this.customDocuments, this.provider, this.editor.getModel().isAddRow()));
            popUp.showPopUp(x, y, 450, 300, this, source, PopupType.FRAMELESS);
        } else if (source == this.editPackaging.getElement()) {
            InnerPopupFactory.showPackingTable(x, y, this, this.packingTableNode, ArticleChargeComplete_.packingQuantities, this.provider);
        } else if (source == this.updateCharge) {
            List<ScreenValidationObject> validationObjects = this.validatePackingTable(this.chargeNode, this.packingTableNode);
            if (validationObjects.isEmpty()) {
                InnerPopupFactory.showDesicionPopup("Save Charge", "Update Changes on Server for selected Charge?", this, (source1, xargs) -> this.saveCharge(source1, xargs), x, y);
            } else {
                InnerPopupFactory.showErrorDialog(validationObjects, "Save Article Charge", "Unable to update Article Charge", (Component)this);
            }
        }
    }

    private List<ScreenValidationObject> validatePackingTable(Node<ArticleChargeComplete> chargeNode, Node<List<PackagingQuantityComplete>> packingTableNode) {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        chargeNode.commitThis(ArticleChargeComplete.class);
        ArticleChargeComplete chargeComplete = (ArticleChargeComplete)chargeNode.getValue(ArticleChargeComplete.class);
        boolean foundBaseUnit = false;
        for (PackagingQuantityComplete quantityComplete : chargeComplete.getPackingQuantities()) {
            int unitContaining = UnitConversionToolkit.isUnitContaining((UnitComplete)quantityComplete.getUnit(), (UnitComplete)settings.getDefaultCustomsPenaltyUnit(), null, (Timestamp)new Timestamp(System.currentTimeMillis()));
            if (unitContaining != 3) continue;
            foundBaseUnit = true;
        }
        if (!foundBaseUnit) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure [" + settings.getDefaultCustomsPenaltyUnit().getShortName() + "] is in Article Charge's Conversion table"));
        }
        return validationObjects;
    }

    private void saveCharge(InnerPopUp2 source, Object[] args) {
        if (args == null) {
            return;
        }
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                ChargeDetailsPanel.this.chargeNode.commitThis(ArticleChargeComplete.class);
                ArticleChargeComplete chargeComplete = (ArticleChargeComplete)ChargeDetailsPanel.this.chargeNode.getValue(ArticleChargeComplete.class);
                ArticleChargeComplete oldCharge = (ArticleChargeComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getArticleCharge(new ArticleChargeReference(chargeComplete.getId())).getValue();
                double amountInBaseUnit = UnitConversionToolkit.convertUnit((UnitComplete)oldCharge.getQuantity().getUnit(), (UnitComplete)chargeComplete.getBasicArticle().getBaseUnit(), (double)oldCharge.getQuantity().getAmount().longValue(), (BasicArticleLight)oldCharge.getBasicArticle(), (List)oldCharge.getPackingQuantities());
                StoreQuantityComplete qtyInBaseUnit = UnitConversionToolkit.convertToStoreQuantity((QuantityComplete)new QuantityComplete(Double.valueOf(amountInBaseUnit), chargeComplete.getBasicArticle().getBaseUnit()), (BasicArticleLight)oldCharge.getBasicArticle(), (Timestamp)new Timestamp(System.currentTimeMillis()));
                chargeComplete.setQuantity(qtyInBaseUnit);
                for (ArticleChargeBatchComplete batchComplete : chargeComplete.getBatches()) {
                    amountInBaseUnit = UnitConversionToolkit.convertUnit((UnitComplete)batchComplete.getQuantity().getUnit(), (UnitComplete)ChargeDetailsPanel.this.settings.getDefaultCustomsPenaltyUnit(), (double)batchComplete.getQuantity().getAmount().longValue(), (BasicArticleLight)oldCharge.getBasicArticle(), (List)oldCharge.getPackingQuantities());
                    qtyInBaseUnit = UnitConversionToolkit.convertToStoreQuantity((QuantityComplete)new QuantityComplete(Double.valueOf(amountInBaseUnit), ChargeDetailsPanel.this.settings.getDefaultCustomsPenaltyUnit()), (BasicArticleLight)oldCharge.getBasicArticle(), (Timestamp)new Timestamp(System.currentTimeMillis()));
                    batchComplete.setQuantity(qtyInBaseUnit);
                }
                chargeComplete = (ArticleChargeComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).updateArticleCharge(chargeComplete).getValue();
                ChargeDetailsPanel.this.chargeNode.setValue((Object)chargeComplete, 0L);
                ChargeDetailsPanel.this.chargeNode.updateNode();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        ChargeDetailsPanel.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)ChargeDetailsPanel.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    public void reset() {
        this.number.getElement().setText("");
        this.creationDate.getElement().setText("");
        this.expiryDate.getElement().setText("");
        this.quantity.getElement().setText("");
        this.priceAndUnit.getElement().getValueNode().setValue(null, 0L);
        this.customDocuments = null;
        this.batchTable.getModel().resetModel();
        this.transactionTable.getModel().resetModel();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(parent.getWidth(), 550);
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            ChargeDetailsPanel.this.number.setLocation(border, border);
            ChargeDetailsPanel.this.number.setSize((int)ChargeDetailsPanel.this.number.getPreferredSize().getWidth(), (int)ChargeDetailsPanel.this.number.getPreferredSize().getHeight());
            ChargeDetailsPanel.this.creationDate.setLocation(100, border);
            ChargeDetailsPanel.this.creationDate.setSize(TableColumnInfo.dateColumnWidth, (int)ChargeDetailsPanel.this.creationDate.getPreferredSize().getHeight());
            ChargeDetailsPanel.this.originCountry.setLocation(ChargeDetailsPanel.this.creationDate.getX() + ChargeDetailsPanel.this.creationDate.getWidth() + border, border);
            ChargeDetailsPanel.this.originCountry.setSize(200, (int)ChargeDetailsPanel.this.originCountry.getPreferredSize().getHeight());
            ChargeDetailsPanel.this.currencyDate.setLocation(ChargeDetailsPanel.this.originCountry.getX() + ChargeDetailsPanel.this.originCountry.getWidth() + border, border);
            ChargeDetailsPanel.this.currencyDate.setSize(ChargeDetailsPanel.this.currencyDate.getPreferredSize());
            ChargeDetailsPanel.this.expiryDate.setLocation(ChargeDetailsPanel.this.currencyDate.getX() + ChargeDetailsPanel.this.currencyDate.getWidth() + border, border);
            ChargeDetailsPanel.this.expiryDate.setSize(TableColumnInfo.dateColumnWidth, (int)ChargeDetailsPanel.this.expiryDate.getPreferredSize().getHeight());
            ChargeDetailsPanel.this.expiryDateHistory.setLocation(ChargeDetailsPanel.this.expiryDate.getX() + ChargeDetailsPanel.this.expiryDate.getWidth() + border / 2, (int)((double)(ChargeDetailsPanel.this.expiryDate.getY() + ChargeDetailsPanel.this.expiryDate.getHeight()) - ChargeDetailsPanel.this.expiryDateHistory.getPreferredSize().getHeight()) - 2);
            ChargeDetailsPanel.this.expiryDateHistory.setSize(ChargeDetailsPanel.this.expiryDateHistory.getPreferredSize());
            ChargeDetailsPanel.this.quantity.setLocation(ChargeDetailsPanel.this.expiryDateHistory.getX() + ChargeDetailsPanel.this.expiryDateHistory.getWidth() + border, border);
            ChargeDetailsPanel.this.quantity.setSize(100, (int)ChargeDetailsPanel.this.quantity.getPreferredSize().getHeight());
            ChargeDetailsPanel.this.oprp.setLocation(ChargeDetailsPanel.this.expiryDateHistory.getX() + ChargeDetailsPanel.this.expiryDateHistory.getWidth() + border, ChargeDetailsPanel.this.quantity.getY() + ChargeDetailsPanel.this.quantity.getHeight() + border);
            ChargeDetailsPanel.this.oprp.setSize(ChargeDetailsPanel.this.oprp.getPreferredSize());
            ChargeDetailsPanel.this.downloadPoPDF.setLocation(ChargeDetailsPanel.this.oprp.getX() + ChargeDetailsPanel.this.oprp.getWidth() + border, ChargeDetailsPanel.this.oprp.getY());
            ChargeDetailsPanel.this.downloadPoPDF.setSize(ChargeDetailsPanel.this.downloadPoPDF.getPreferredSize());
            ChargeDetailsPanel.this.priceAndUnit.setLocation(ChargeDetailsPanel.this.oprp.getX() + ChargeDetailsPanel.this.oprp.getWidth() + border, border);
            ChargeDetailsPanel.this.priceAndUnit.setSize(110, (int)ChargeDetailsPanel.this.priceAndUnit.getPreferredSize().getHeight());
            ChargeDetailsPanel.this.customDocumentsButton.setLocation(ChargeDetailsPanel.this.priceAndUnit.getX() + ChargeDetailsPanel.this.priceAndUnit.getWidth() + border, (int)((double)(ChargeDetailsPanel.this.priceAndUnit.getY() + ChargeDetailsPanel.this.priceAndUnit.getHeight()) - ChargeDetailsPanel.this.customDocumentsButton.getPreferredSize().getHeight()));
            ChargeDetailsPanel.this.customDocumentsButton.setSize(100, (int)ChargeDetailsPanel.this.customDocumentsButton.getPreferredSize().getHeight());
            ChargeDetailsPanel.this.editPackaging.setLocation(ChargeDetailsPanel.this.customDocumentsButton.getX() + ChargeDetailsPanel.this.customDocumentsButton.getWidth() + border, ChargeDetailsPanel.this.customDocumentsButton.getY());
            ChargeDetailsPanel.this.editPackaging.setSize(100, (int)ChargeDetailsPanel.this.editPackaging.getPreferredSize().getHeight());
            ChargeDetailsPanel.this.updateCharge.setLocation(ChargeDetailsPanel.this.editPackaging.getX() + ChargeDetailsPanel.this.editPackaging.getWidth() + border / 2, ChargeDetailsPanel.this.customDocumentsButton.getY());
            ChargeDetailsPanel.this.updateCharge.setSize(ChargeDetailsPanel.this.updateCharge.getPreferredSize());
            ChargeDetailsPanel.this.batchTable.setLocation(border, ChargeDetailsPanel.this.downloadPoPDF.getY() + ChargeDetailsPanel.this.downloadPoPDF.getHeight() + border);
            ChargeDetailsPanel.this.batchTable.setSize(parent.getWidth() - 2 * border, 210);
            ChargeDetailsPanel.this.transactionTable.setLocation(border, (int)(ChargeDetailsPanel.this.batchTable.getLocation().getY() + ChargeDetailsPanel.this.batchTable.getSize().getHeight() + 10.0));
            ChargeDetailsPanel.this.transactionTable.setSize(parent.getWidth() - 2 * border, 210);
        }
    }

    private class TransactionTableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel date;
        private TextLabel user;
        private TextLabel type;
        private TextLabel quantity;
        private TextLabel remark;
        private InfoButton articleInfo;

        public TransactionTableRowImpl(Table2RowModel m) {
            super(m);
            this.setLayout(new InnerLayout());
            this.date = new TextLabel(m.getNode().getChildNamed(StockTransactionComplete_.date), ConverterRegistry.getConverter(DateTimeConverter.class));
            this.user = new TextLabel(m.getNode().getChildNamed(StockTransactionComplete_.user), ConverterRegistry.getConverter(UserConverter.class));
            this.type = new TextLabel(m.getNode(), ConverterRegistry.getConverter(ChargeTransactionConverter.class));
            this.remark = new TextLabel(m.getNode().getChildNamed(StockInventoryComplete_.remark));
            this.quantity = new TextLabel(m.getNode().getChildNamed(StockTransactionComplete_.amount), ConverterRegistry.getConverter(QuantityConverter2Decimal.class));
            if (m.getNode().getValue() instanceof PurchaseOrderTransactionComplete) {
                this.articleInfo = new InfoButton();
                PurchaseOrderComplete order = ((PurchaseOrderTransactionComplete)m.getNode().getValue()).getOrderPosition().getOrder();
                this.articleInfo.installStringViewer(OrderToolkit.createInfoInsert(order));
                this.add(this.articleInfo);
            }
            this.add(this.date);
            this.add(this.user);
            this.add(this.type);
            this.add(this.quantity);
            this.add(this.remark);
        }

        @Override
        public Object getObject4Column(int column) {
            return this.user.getText();
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.date.setEnabled(isEnabled);
            this.user.setEnabled(isEnabled);
            this.type.setEnabled(isEnabled);
            this.quantity.setEnabled(isEnabled);
            this.remark.setEnabled(isEnabled);
            if (this.articleInfo != null) {
                this.articleInfo.setEnabled(true);
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.date.kill();
            this.date = null;
            this.user.kill();
            this.user = null;
            this.type.kill();
            this.type = null;
            this.quantity.kill();
            this.quantity = null;
            this.remark.kill();
            this.remark = null;
            if (this.articleInfo != null) {
                this.articleInfo.kill();
                this.articleInfo = null;
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            return new ArrayList<Component>();
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TransactionTableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TransactionTableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                TransactionTableRowImpl.this.date.setLocation(TransactionTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TransactionTableRowImpl.this.date.getPreferredSize().getHeight()) / 2.0));
                TransactionTableRowImpl.this.date.setSize(w, (int)TransactionTableRowImpl.this.date.getPreferredSize().getHeight());
                currentX += w;
                w = TransactionTableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TransactionTableRowImpl.this.user.setLocation(currentX + TransactionTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TransactionTableRowImpl.this.user.getPreferredSize().getHeight()) / 2.0));
                TransactionTableRowImpl.this.user.setSize(w - 1 * TransactionTableRowImpl.this.getCellPadding(), (int)TransactionTableRowImpl.this.user.getPreferredSize().getHeight());
                currentX += w;
                w = TransactionTableRowImpl.this.model.getParentModel().getColumnWidth(2);
                if (TransactionTableRowImpl.this.articleInfo != null) {
                    TransactionTableRowImpl.this.type.setLocation(currentX + TransactionTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TransactionTableRowImpl.this.type.getPreferredSize().getHeight()) / 2.0));
                    TransactionTableRowImpl.this.type.setSize(w - 1 * TransactionTableRowImpl.this.getCellPadding() - ((TransactionTableRowImpl)TransactionTableRowImpl.this).articleInfo.getPreferredSize().width - 4, (int)TransactionTableRowImpl.this.type.getPreferredSize().getHeight());
                    TransactionTableRowImpl.this.articleInfo.setLocation(((TransactionTableRowImpl)TransactionTableRowImpl.this).type.getLocation().x + TransactionTableRowImpl.this.type.getWidth() + 2, (int)(((double)parent.getHeight() - TransactionTableRowImpl.this.articleInfo.getPreferredSize().getHeight()) / 2.0));
                    TransactionTableRowImpl.this.articleInfo.setSize(TransactionTableRowImpl.this.articleInfo.getPreferredSize());
                } else {
                    TransactionTableRowImpl.this.type.setLocation(currentX + TransactionTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TransactionTableRowImpl.this.type.getPreferredSize().getHeight()) / 2.0));
                    TransactionTableRowImpl.this.type.setSize(w - 1 * TransactionTableRowImpl.this.getCellPadding(), (int)TransactionTableRowImpl.this.type.getPreferredSize().getHeight());
                }
                currentX += w;
                w = TransactionTableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TransactionTableRowImpl.this.remark.setLocation(currentX + TransactionTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TransactionTableRowImpl.this.remark.getPreferredSize().getHeight()) / 2.0));
                TransactionTableRowImpl.this.remark.setSize(w - 1 * TransactionTableRowImpl.this.getCellPadding(), (int)TransactionTableRowImpl.this.remark.getPreferredSize().getHeight());
                currentX += w;
                w = TransactionTableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TransactionTableRowImpl.this.quantity.setLocation(currentX + TransactionTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TransactionTableRowImpl.this.quantity.getPreferredSize().getHeight()) / 2.0));
                TransactionTableRowImpl.this.quantity.setSize(w - 1 * TransactionTableRowImpl.this.getCellPadding(), (int)TransactionTableRowImpl.this.quantity.getPreferredSize().getHeight());
            }
        }
    }

    private class BatchTableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel position;
        private TextLabel quantity;
        private TextLabel lastInventory;

        public BatchTableRowImpl(Table2RowModel m) {
            super(m);
            this.setLayout(new InnerLayout());
            this.position = new TextLabel(m.getNode().getChildNamed(ArticleChargeBatchComplete_.position), ConverterRegistry.getConverter(StorePositionShortNameConverter.class));
            this.quantity = new TextLabel(m.getNode().getChildNamed(ArticleChargeBatchComplete_.quantity), ConverterRegistry.getConverter(QuantityConverter2Decimal.class));
            this.lastInventory = new TextLabel(m.getNode().getChildNamed(ArticleChargeBatchComplete_.lastInventory), ConverterRegistry.getConverter(DateTimeConverter.class));
            this.add(this.position);
            this.add(this.quantity);
            this.add(this.lastInventory);
        }

        @Override
        public void updateRow(Node<?> node) {
            this.lastInventory.updateString();
            this.quantity.updateString();
            this.position.updateString();
        }

        @Override
        public Object getObject4Column(int column) {
            return this.position.getText();
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.position.setEnabled(isEnabled);
            this.quantity.setEnabled(isEnabled);
            this.lastInventory.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.position.kill();
            this.position = null;
            this.quantity.kill();
            this.quantity = null;
            this.lastInventory.kill();
            this.lastInventory = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            return new ArrayList<Component>();
        }

        private class InnerLayout
        extends TableRowLayout {
            private InnerLayout() {
            }

            @Override
            public List<JComponent> getComponentsOrder() {
                ArrayList<JComponent> list = new ArrayList<JComponent>();
                list.add(BatchTableRowImpl.this.position);
                list.add(BatchTableRowImpl.this.quantity);
                list.add(BatchTableRowImpl.this.lastInventory);
                return list;
            }

            @Override
            public Table2RowPanel getTableRowPanel() {
                return BatchTableRowImpl.this;
            }
        }
    }
}

