/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.admin.util;

import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.MultiLineTextLabel;
import ch.icit.pegasus.client.gui.utils.popup.LoadablePopupInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.system.SequenceIdentifierE;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class SequenceLocalizerPopup
extends LoadablePopupInsert {
    private static final long serialVersionUID = 1L;
    private MultiLineTextLabel msg = new MultiLineTextLabel();
    private boolean switched = false;
    private SequenceIdentifierE id;
    private boolean isLocalize;

    public SequenceLocalizerPopup(boolean localize, SequenceIdentifierE id) {
        this.id = id;
        this.isLocalize = localize;
        if (localize) {
            this.msg.setText(Words.ARE_YOU_SURE_TO_LOCALIZE_CURRENT_SEQUENCE);
        } else {
            this.msg.setText(Words.ARE_YOU_SURE_TO_DELOCALIZE_CURRENT_SEQUENCE);
        }
        this.setLayout(new Layout());
        this.add(this.msg);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.msg.kill();
        this.msg = null;
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        if (!this.switched && isOK == PopupAction.OK_FOREGROUND) {
            this.showAnimation(Words.SWITCH);
            this.msg.setVisible(false);
            this.switched = true;
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    if (SequenceLocalizerPopup.this.isLocalize) {
                        ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).localizeCustomSequence(SequenceLocalizerPopup.this.id);
                    } else {
                        ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).delocalizeCustomSequence(SequenceLocalizerPopup.this.id);
                    }
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            SequenceLocalizerPopup.this.msg.setText(Words.SUCCESSFUL);
                            SequenceLocalizerPopup.this.hideAnimation();
                            SequenceLocalizerPopup.this.msg.setVisible(true);
                        }

                        public void errorOccurred(ClientException exception) {
                            SequenceLocalizerPopup.this.msg.setText(Words.ERROR_OCCURED + ": " + exception.getMessage());
                            SequenceLocalizerPopup.this.hideAnimation();
                            SequenceLocalizerPopup.this.msg.setVisible(true);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else {
            super.enterPressed(isOK);
        }
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            SequenceLocalizerPopup.this.msg.setLocation(0, 0);
            SequenceLocalizerPopup.this.msg.setSize(parent.getSize());
            SequenceLocalizerPopup.this.layoutAnimation(parent);
        }
    }
}

