/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.accountdistribution.details;

import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.acountdistribution.AccountDistributionComplete_;
import ch.icit.pegasus.server.core.dtos.acountdistribution.AccountDistributionLight;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ProductsDetailsPanel
extends TableDetailsPanel<AccountDistributionLight> {
    private static final long serialVersionUID = 1L;
    private boolean isProductsDeletable;
    private boolean isProductsWritable;

    public ProductsDetailsPanel(RowEditor<AccountDistributionLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.PRODUCTS);
        this.isProductsDeletable = provider.isDeletable(AccountDistributionComplete_.products);
        this.isProductsWritable = provider.isWritable(AccountDistributionComplete_.products);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.PRODUCT, null, null, null, "", 30, 30, 30));
        int dw2 = this.table.getCellPadding() * 2 + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", dw2, dw2, dw2));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setComparator((d1, d2) -> {
            ProductTableRowImpl o1 = (ProductTableRowImpl)d1;
            ProductTableRowImpl o2 = (ProductTableRowImpl)d2;
            if (o1 == null || o1.getProduct() == null) {
                return 1;
            }
            if (o2 == null || o2.getProduct() == null) {
                return -1;
            }
            return o1.getProduct().getNumber().compareTo(o2.getProduct().getNumber());
        });
        table.setOverrideName(AccountDistributionComplete_.products);
        table.setProvider(this.provider);
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        this.table.getModel().getNode().addChild((Node)new DTOProxyNode(), System.currentTimeMillis());
        this.table.enableAddButton(true);
        this.editor.revalidate();
    }

    @Override
    public void childRemoved() {
        this.editor.revalidate();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        ProductTableRowImpl p = new ProductTableRowImpl(model);
        p.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return p;
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        super.addFocusCycleChangeListener(listener);
        this.table.getModel().addFocusCycleChangeListener(listener);
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.table.getModel().setNode(node.getChildNamed(AccountDistributionComplete_.products));
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        HashSet<ProductComplete> products = new HashSet<ProductComplete>();
        for (Table2RowPanel tr : this.table.getRows()) {
            ProductComplete p = (ProductComplete)tr.getModel().getNode().getValue();
            if (p == null) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_PRODUCT_IS_SET));
                continue;
            }
            if (products.contains(p)) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.PRODUCT_IS_INSERTED_TWICE, (Object[])new Object[]{p.getNumber()})));
                continue;
            }
            products.add(p);
        }
        return validationObjects;
    }

    private class ProductTableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    NodeListener {
        private static final long serialVersionUID = 1L;
        private SearchTextField2<ProductComplete> product;
        private DeleteButton deleteButton;

        ProductTableRowImpl(Table2RowModel m) {
            super(m);
            this.setLayout(new InnerLayout());
            this.product = SearchTextField2Factory.getProductSearchField(true, m.getNode());
            if (ProductsDetailsPanel.this.isProductsDeletable) {
                this.deleteButton = new DeleteButton();
                this.deleteButton.addButtonListener(this);
                this.deleteButton.setProgress(1.0f);
                this.add(this.deleteButton);
            }
            this.add(this.product);
            this.product.setProgress(1.0f);
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.product.getName();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.product.setEnabled(isEnabled && ProductsDetailsPanel.this.isProductsWritable);
            if (this.deleteButton != null) {
                this.deleteButton.setEnabled(isEnabled);
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            a.addAll(this.product.getFocusComponents());
            CheckedListAdder.addToList(a, this.deleteButton);
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.product.requestFocusInWindowNow();
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.model.getNode().removeNodeListener((NodeListener)this);
            this.product.kill();
            this.product = null;
            if (this.deleteButton != null) {
                this.deleteButton.kill();
            }
            this.deleteButton = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.deleteButton) {
                ProductsDetailsPanel.this.table.getModel().getNode().removeChild(this.model.getNode(), 0L);
            }
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public void valueChanged(Node<?> node) {
        }

        public boolean isSwingOnly() {
            return true;
        }

        public ProductComplete getProduct() {
            return (ProductComplete)this.product.getNode().getValue();
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = ProductTableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                ProductTableRowImpl.this.product.setLocation(currentX + ProductTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - ProductTableRowImpl.this.product.getPreferredSize().getHeight()) / 2.0));
                ProductTableRowImpl.this.product.setSize(w - 2 * ProductTableRowImpl.this.getCellPadding(), (int)ProductTableRowImpl.this.product.getPreferredSize().getHeight());
                currentX += w;
                if (ProductTableRowImpl.this.deleteButton != null) {
                    ProductTableRowImpl.this.deleteButton.setLocation(currentX + ProductTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - ProductTableRowImpl.this.deleteButton.getPreferredSize().getHeight()) / 2.0));
                    ProductTableRowImpl.this.deleteButton.setSize(ProductTableRowImpl.this.deleteButton.getPreferredSize());
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, ProductTableRowImpl.this.getDefaultRowHeight());
            }
        }
    }
}

