/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.hud.view;

import ch.icit.pegasus.client.gui.hud.HUDPanel;
import ch.icit.pegasus.client.gui.hud.model.HUDModelModule;
import ch.icit.pegasus.client.gui.hud.view.HUDButton;
import ch.icit.pegasus.client.gui.modules.AppModulesUtils;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.util.HUDToolkit;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;

public class HUDActionButton
extends HUDButton {
    private static final long serialVersionUID = 1L;
    private String screenClass;
    private HUDModelModule module;

    public HUDActionButton(String text, HUDPanel parent, HUDModelModule module) {
        super(new AppModulesUtils().getModuleDisplayName(module.getAccessright().getModule().getAccessDefinition()), parent, HUDToolkit.getScreenType4Invoker(module.getModuleID()));
        this.screenClass = module.getScreenClass();
        this.module = module;
    }

    public String getScreenClass() {
        return this.screenClass;
    }

    public HUDModelModule getModule() {
        return this.module;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.screenClass = null;
        this.module.kill();
        this.module = null;
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.state = Button.ButtonState.OVER;
        this.parentHUD.setFocusButton(this);
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.state = Button.ButtonState.UP;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.hasFocus()) {
            super.mouseExited(e);
        }
    }
}

