/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.breadcrumb;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbGroupTable;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbNavigator;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbTable;
import ch.icit.pegasus.client.gui.breadcrumb.utils.BreadCrumbTableSorter;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.submodules.tool.product.spec.utils.GroupLoader;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowSelectionListener;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.ClipingProvider;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.ScrollPane;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.animators.Scroller;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainer;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.priceanimation.LoadingGroup;
import ch.icit.pegasus.client.gui.utils.priceanimation.ReloadablePriceView;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.Skin9Field;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.impls.BackgroundFadeSkin;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager2;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BreadCrumbPanel
extends JPanelFadable
implements RemoteLoader,
Table2RowSelectionListener,
ButtonListener,
InnerPopUpListener2,
ClipingProvider,
Focusable,
MutableFocusContainer {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(BreadCrumbPanel.class);
    protected Node node;
    protected Skin9Field borderSkin;
    private BackgroundFadeSkin buttonSkin;
    private MutableFocusContainerListener listener;
    private Comparator<BreadCrumbTable> sorter;
    protected Scroller<BreadCrumbPanel, JScrollBar> scroller;
    protected BreadCrumbNavigator navigator;
    protected int firstTableWidth = 350;
    protected int buttonHeight;
    protected int arcH;
    protected int arcW;
    protected TextButton button;
    protected TextButton button2;
    protected InfoButton button2Info;
    protected TextButton button3;
    protected GroupLoader loader;
    protected ScrollPane viewPortScroller;
    protected BreadCrumbTable tempGroup;
    protected boolean hasSkin;
    protected boolean useClipping = true;
    protected boolean paintButtonSkin = true;
    protected boolean hasTitleArea = true;
    protected ReloadablePriceView totalCost;
    protected JPanel viewPort;
    protected Node newSelectedGroup;
    private int maxDepth;
    private int titleHeight;
    private TextLabel titleText;
    protected List<BreadCrumbTable> tableStack = new ArrayList<BreadCrumbTable>();
    protected RDProvider provider;
    protected IDataHandler dataHandler;

    public abstract Converter getTotalConverter();

    public abstract GroupLoader getGroupLoader();

    public IDataHandler getDataHandler() {
        return this.dataHandler;
    }

    public BreadCrumbPanel(IDataHandler dataHandler, int maxDepth, RDProvider provider) {
        this.provider = provider;
        this.maxDepth = maxDepth;
        this.loader = this.getGroupLoader();
        this.dataHandler = dataHandler;
        this.getFader().setProgress(1.0f);
        this.buttonSkin = SkinRegistry.getSkin(BackgroundFadeSkin.class);
        this.buttonHeight = this.buttonSkin.getImage(11).getHeight();
        this.arcW = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("details_panel_arcWidth"));
        this.arcH = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("details_panel_arcHeight"));
        this.setOpaque(false);
        if (this.loader != null) {
            this.totalCost = new ReloadablePriceView((LoadingGroup)this.loader, this.getTotalConverter());
        }
        if (this.totalCost != null) {
            this.totalCost.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("productoverview_pricetext_font_type")));
        }
        if (this.loader != null) {
            this.loader.setFirstTotal(this.totalCost);
        }
        if (this.totalCost != null) {
            this.setTotalCostAlgorithm();
            this.totalCost.setProgress(1.0f);
        }
        this.navigator = this.getNavigatorComponent();
        this.borderSkin = (Skin9Field)DefaultSkins.PanelBorder.createDynamicSkin();
        this.setLayout(this.getDefaultLayout());
        this.viewPort = new JPanel(){

            @Override
            public void paint(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor(this.getBackground());
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                this.paintChildren(g2);
            }
        };
        this.viewPort.setOpaque(false);
        this.viewPort.setLayout(this.getViewPortLayout());
        this.viewPortScroller = new ScrollPane();
        this.viewPortScroller.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
        this.viewPortScroller.getHorizontalScrollBar().setBackground(this.viewPortScroller.getBackground());
        this.viewPortScroller.getVerticalScrollBar().setBackground(this.viewPortScroller.getBackground());
        this.viewPort.setBackground(this.viewPortScroller.getBackground());
        this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("breadcrumb_outlinecolor")));
        this.viewPortScroller.setBorder(BorderFactory.createEmptyBorder());
        this.viewPortScroller.setViewportView(this.viewPort);
        this.scroller = new Scroller<BreadCrumbPanel, JScrollBar>(this, this.viewPortScroller.getHorizontalScrollBar());
        this.add(this.viewPortScroller);
        if (this.navigator != null) {
            this.add(this.navigator);
        }
        if (this.totalCost != null) {
            this.add(this.totalCost);
        }
    }

    public boolean isAddable(String t) {
        return this.provider.isAddable(t);
    }

    public boolean isWritable(String string) {
        if (this.node == null) {
            return true;
        }
        return this.provider.isWritable(string);
    }

    public JComponent getViewPort() {
        return this.viewPort;
    }

    public RDProvider getProvider() {
        return this.provider;
    }

    public int getFirstTableWidth() {
        return this.firstTableWidth;
    }

    public void setFirstTableWidth(int firstTableWidth) {
        this.firstTableWidth = firstTableWidth;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        if (this.navigator != null) {
            this.navigator.setEnabled(isEnabled);
        }
        if (this.viewPortScroller != null && this.viewPortScroller.getVerticalScrollBar() != null) {
            this.viewPortScroller.getVerticalScrollBar().setEnabled(isEnabled);
        }
        if (this.viewPortScroller != null && this.viewPortScroller.getHorizontalScrollBar() != null) {
            this.viewPortScroller.getHorizontalScrollBar().setEnabled(isEnabled);
        }
        if (this.totalCost != null) {
            this.totalCost.setEnabled(isEnabled);
        }
        if (this.titleText != null) {
            this.titleText.setEnabled(isEnabled);
        }
        for (BreadCrumbTable t : this.tableStack) {
            t.setEnabled(isEnabled);
        }
        if (this.button != null) {
            this.button.setEnabled(isEnabled);
        }
        if (this.button2 != null) {
            this.button2.setEnabled(isEnabled);
        }
        if (this.button2Info != null) {
            this.button2Info.setEnabled(isEnabled);
        }
        if (this.button3 != null) {
            this.button3.setEnabled(isEnabled);
        }
    }

    @Override
    public void requestFocusInWindowNow() {
        if (this.tableStack.size() > 0) {
            this.tableStack.get(0).requestFocusInWindowNow();
        }
    }

    public void setBorderSkin(DefaultSkins skin) {
        this.borderSkin = (Skin9Field)skin.createDynamicSkin();
    }

    public void setTitleHeight(int h) {
        this.titleHeight = h;
    }

    public void setButtonHeight(int h) {
        this.buttonHeight = h;
    }

    public void setTitleText(String t) {
        if (this.titleText == null) {
            this.titleText = new TextLabel(t);
            this.titleText.setProgress(1.0f);
            this.add(this.titleText);
        }
        this.validate();
    }

    public boolean hasViewPortScroller() {
        return true;
    }

    public abstract BreadCrumbNavigator getNavigatorComponent();

    public abstract BreadCrumbTable getGroupTable(Node var1);

    public abstract BreadCrumbTable getComponentTable(Node var1, int var2);

    public abstract void setNode(Node var1);

    public abstract Node getNode();

    public abstract InnerPopUp2 getAddGroupPopup(Button var1, int var2, int var3, BreadCrumbTable var4);

    public abstract void setTotalCostAlgorithm();

    public abstract void processPopUpClose(Object ... var1);

    public abstract DtoField<?> getSelectionChildName();

    public Iterator<BreadCrumbTable> getTables() {
        return this.tableStack.iterator();
    }

    public void setUseClipping(boolean useClipping) {
        this.useClipping = useClipping;
    }

    public void setListSorter(Comparator<BreadCrumbTable> t) {
        this.sorter = t;
    }

    public void disableNavigator() {
        if (this.navigator != null) {
            this.navigator.kill();
            this.navigator = null;
        }
    }

    protected void clearTable() {
        this.moveBack(this.tableStack.size());
    }

    protected void moveBack(int offset) {
        BreadCrumbTable t;
        for (int o = offset; o > 0; --o) {
            t = this.tableStack.remove(this.tableStack.size() - 1);
            t.getTable().getModel().removeTableSelectionListener(this);
            t.kill();
        }
        if (this.tableStack.size() >= 2) {
            t = this.tableStack.get(this.tableStack.size() - 2);
            if (!t.isAdded()) {
                this.viewPort.add(t);
                t.setAdded(true);
            }
            if (!(t = this.tableStack.get(this.tableStack.size() - 1)).isAdded()) {
                this.viewPort.add(t);
                t.setAdded(true);
            }
        } else if (this.tableStack.size() >= 1 && !(t = this.tableStack.get(this.tableStack.size() - 1)).isAdded()) {
            this.viewPort.add(t);
            t.setAdded(true);
        }
        if (this.viewPort != null) {
            this.viewPort.validate();
            this.viewPort.repaint(32L);
        }
        if (this.navigator != null) {
            this.navigator.rebuildNavigation();
        }
    }

    protected BreadCrumbTable addComponentTable(Node node, boolean replace, Table2RowPanel panel) {
        if (!replace && this.tableStack.size() >= this.maxDepth) {
            return null;
        }
        BreadCrumbTable table = this.getComponentTable(node, this.tableStack.size());
        table.setParentBreadCrumb(panel);
        table.getTable().setProvider(this.provider);
        table.getTable().getModel().addTableSelectionListener(this);
        table.addFocusCycleChangeListener(this.listener);
        if (replace) {
            BreadCrumbTable t = this.tableStack.get(this.tableStack.size() - 1);
            this.tableStack.remove(t);
            t.setAdded(false);
            t.kill();
        }
        this.tableStack.add(table);
        this.sortList();
        if (this.tableStack.size() % 2 == 0) {
            table.getTable().setColorInversion(true);
        }
        this.viewPort.add(table);
        table.setAdded(true);
        this.viewPort.validate();
        if (this.navigator != null) {
            this.navigator.rebuildNavigation();
        }
        return table;
    }

    @Override
    public Shape getClipingArea() {
        RoundRectangle2D.Double r = new RoundRectangle2D.Double(1.0, 1.0, this.getWidth() - 2, this.getHeight() - 2, this.arcW, this.arcH);
        return r;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        if (this.hasSkin) {
            this.borderSkin.paint(g2, 0, 0, this.getWidth(), this.getHeight(), Button.ButtonState.UP);
        }
        if (this.hasSkin) {
            if (this.getClipingArea() != null && this.useClipping) {
                g2.clip(this.getClipingArea());
            }
            g2.setColor(this.getBackground());
            g2.fillRect(0, this.titleHeight, this.getWidth(), this.getHeight() - this.titleHeight);
        } else {
            g2.setColor(this.getBackground());
            g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 5, 5);
            if (this.getClipingArea() != null && this.useClipping) {
                g2.clip(this.getClipingArea());
            }
        }
        if (this.paintButtonSkin) {
            this.buttonSkin.paint(g2, 0, this.getHeight() - this.buttonHeight, this.getWidth(), 11);
        }
        this.paintChildren(g2);
    }

    public void setHasSkin(boolean hasSkin) {
        this.hasSkin = hasSkin;
    }

    public void enableSorting() {
        this.setListSorter(ComparatorRegistry.getComparator(BreadCrumbTableSorter.class));
    }

    protected BreadCrumbTable addGroupTable(Node node) {
        BreadCrumbTable table = this.getGroupTable(node);
        table.getTable().getModel().addTableSelectionListener(this);
        table.addFocusCycleChangeListener(this.listener);
        this.tableStack.add(table);
        this.sortList();
        if (this.tableStack.size() % 2 == 0) {
            table.getTable().setColorInversion(true);
        }
        if (this.viewPort != null) {
            this.viewPort.add(table);
        }
        table.setAdded(true);
        if (this.viewPort != null) {
            this.viewPort.validate();
        }
        return table;
    }

    private void sortList() {
        if (this.sorter != null) {
            Collections.sort(this.tableStack, this.sorter);
            this.viewPort.validate();
        }
    }

    protected boolean isLast(BreadCrumbTable table) {
        int index = this.tableStack.indexOf(table);
        return index == this.tableStack.size() - 1;
    }

    public void commitNode(Class<?> clazz) {
        this.node.commit(clazz);
    }

    public void commitNode() {
        this.commitNode(this.dataHandler.getCommittingClass());
    }

    public Node getCommitingNode() {
        return this.node;
    }

    public void recalucalteTotalPrice(boolean b) {
        if (this.totalCost != null) {
            this.totalCost.load(b);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.loader != null) {
            this.loader.setFirstTotal(null);
        }
        if (this.navigator != null) {
            this.navigator.kill();
        }
        this.viewPortScroller.kill();
        if (this.totalCost != null) {
            this.totalCost.kill();
        }
        this.viewPort = null;
        while (!this.tableStack.isEmpty()) {
            BreadCrumbTable t = this.tableStack.get(0);
            t.kill();
            this.tableStack.remove(0);
        }
    }

    public LayoutManager2 getDefaultLayout() {
        return new Layout();
    }

    public LayoutManager2 getViewPortLayout() {
        return new ViewPortLayout();
    }

    public void layoutRest(Container parent) {
    }

    @Override
    public void tableRowSelected(Table2 sourceTable, Table2RowPanel panel) {
        if (panel != null) {
            int index = 0;
            int count = 0;
            BreadCrumbTable table = null;
            for (BreadCrumbTable t : this.tableStack) {
                if (t.isContainingRow(panel)) {
                    index = count;
                }
                ++count;
            }
            if (index == this.tableStack.size() - 1) {
                table = this.addComponentTable(panel.getModel().getNode().getChildNamed(this.getSelectionChildName()), false, panel);
            } else if (index == this.tableStack.size() - 2) {
                table = this.addComponentTable(panel.getModel().getNode().getChildNamed(this.getSelectionChildName()), true, panel);
            } else {
                this.moveBack(this.tableStack.size() - 1 - index);
                table = this.addComponentTable(panel.getModel().getNode().getChildNamed(this.getSelectionChildName()), false, panel);
            }
            if (this.navigator != null) {
                this.navigator.rebuildNavigation();
            }
            this.revalidate();
            if (table != null) {
                int currentValue = this.viewPortScroller.getHorizontalScrollBar().getValue();
                this.scroller.scrollTo(currentValue, table.getX());
            }
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        for (BreadCrumbTable t : this.tableStack) {
            if (!t.isButtonOwner(source)) continue;
            if (t instanceof BreadCrumbGroupTable) {
                InnerPopUp2 popUp = this.getAddGroupPopup(source, x, y, t);
                if (popUp != null) continue;
                t.getTable().getButtonHandler().addButtonPressed(0, 0, null);
                continue;
            }
            t.getTable().getButtonHandler().addButtonPressed(0, 0, null);
        }
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        if (xargs == null) {
            this.tempGroup = null;
            this.newSelectedGroup = null;
            return;
        }
        this.processPopUpClose(xargs);
        this.tempGroup = null;
        this.newSelectedGroup = null;
    }

    public ScrollPane getScrollPane() {
        return this.viewPortScroller;
    }

    public void groupRemoved(Table2RowPanel p) {
        try {
            int d;
            if (this.tableStack.get(0).getTable().getModel().getSelectedNode().equals(p.getModel().getNode()) && (d = this.tableStack.size() - 1) > 0) {
                this.moveBack(d);
            }
        }
        catch (Exception e) {
            logger.error("Exception in Bread Crumb while try to move back.");
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        for (BreadCrumbTable t : this.tableStack) {
            CheckedListAdder.addToList(a, t);
        }
        return a;
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        for (BreadCrumbTable t : this.tableStack) {
            t.setVisibleContainer(pane);
        }
    }

    public void sortNow() {
        this.sortList();
    }

    @Override
    public void removeFocusCycleChangeListener(MutableFocusContainerListener listener) {
        this.listener = null;
        for (BreadCrumbTable t : this.tableStack) {
            t.removeFocusCycleChangeListener(listener);
        }
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        this.listener = listener;
        for (BreadCrumbTable t : this.tableStack) {
            t.addFocusCycleChangeListener(listener);
        }
    }

    public void remoteObjectLoaded(Node<?> node) {
    }

    public void errorOccurred(ClientException exception) {
        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)this);
    }

    private class ViewPortLayout
    extends DefaultLayout {
        private ViewPortLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            boolean isFirst = true;
            int currentX = 0;
            for (BreadCrumbTable t : BreadCrumbPanel.this.tableStack) {
                t.setLocation(currentX, 0);
                if (isFirst) {
                    t.setSize(BreadCrumbPanel.this.firstTableWidth, parent.getHeight());
                } else {
                    t.setSize(BreadCrumbPanel.this.getWidth() - 2 - BreadCrumbPanel.this.firstTableWidth, parent.getHeight());
                }
                currentX += t.getWidth();
                isFirst = false;
            }
            BreadCrumbPanel.this.layoutRest(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int currentX = 0;
            boolean isFirst = true;
            int a = BreadCrumbPanel.this.getWidth() - 2 - BreadCrumbPanel.this.firstTableWidth;
            for (BreadCrumbTable t : BreadCrumbPanel.this.tableStack) {
                currentX = isFirst ? (currentX += BreadCrumbPanel.this.firstTableWidth) : (currentX += a);
                isFirst = false;
            }
            return new Dimension(currentX, 0);
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int titleHeight = 0;
            if (BreadCrumbPanel.this.navigator != null) {
                titleHeight = (int)BreadCrumbPanel.this.navigator.getPreferredSize().getHeight();
                BreadCrumbPanel.this.navigator.setLocation(0, 0);
                BreadCrumbPanel.this.navigator.setSize(parent.getWidth(), titleHeight);
            }
            if (BreadCrumbPanel.this.titleText != null) {
                BreadCrumbPanel.this.titleText.setLocation(10, (int)(((double)BreadCrumbPanel.this.titleHeight - BreadCrumbPanel.this.titleText.getPreferredSize().getHeight()) / 2.0));
                BreadCrumbPanel.this.titleText.setSize(parent.getWidth() - 20, (int)BreadCrumbPanel.this.titleText.getPreferredSize().getHeight());
                titleHeight = BreadCrumbPanel.this.titleHeight;
            }
            BreadCrumbPanel.this.viewPortScroller.setLocation(1, titleHeight + 1);
            BreadCrumbPanel.this.viewPortScroller.setSize(parent.getWidth() - 2, parent.getHeight() - (titleHeight + BreadCrumbPanel.this.buttonHeight));
            if (BreadCrumbPanel.this.totalCost != null) {
                BreadCrumbPanel.this.totalCost.setLocation(10, (int)((double)(parent.getHeight() - BreadCrumbPanel.this.buttonHeight) + ((double)BreadCrumbPanel.this.buttonHeight - BreadCrumbPanel.this.totalCost.getPreferredSize().getHeight()) / 2.0));
                BreadCrumbPanel.this.totalCost.setSize(parent.getWidth() - 2 * BreadCrumbPanel.this.totalCost.getX(), (int)BreadCrumbPanel.this.totalCost.getPreferredSize().getHeight());
            } else if (BreadCrumbPanel.this.button != null) {
                BreadCrumbPanel.this.button.setLocation(10, (int)((double)(parent.getHeight() - BreadCrumbPanel.this.buttonHeight) + ((double)BreadCrumbPanel.this.buttonHeight - BreadCrumbPanel.this.button.getPreferredSize().getHeight()) / 2.0) + 1);
                BreadCrumbPanel.this.button.setSize(BreadCrumbPanel.this.button.getPreferredSize());
                int currentX = BreadCrumbPanel.this.button.getX() + BreadCrumbPanel.this.button.getWidth() + 5;
                if (BreadCrumbPanel.this.button2 != null) {
                    BreadCrumbPanel.this.button2.setLocation(BreadCrumbPanel.this.button.getX() + BreadCrumbPanel.this.button.getWidth() + 10, BreadCrumbPanel.this.button.getY());
                    BreadCrumbPanel.this.button2.setSize(BreadCrumbPanel.this.button2.getPreferredSize());
                    if (BreadCrumbPanel.this.button2Info != null) {
                        BreadCrumbPanel.this.button2Info.setLocation(BreadCrumbPanel.this.button2.getX() + BreadCrumbPanel.this.button2.getWidth() + 2, BreadCrumbPanel.this.button.getY() + 5);
                        BreadCrumbPanel.this.button2Info.setSize(BreadCrumbPanel.this.button2Info.getPreferredSize());
                        currentX = BreadCrumbPanel.this.button2Info.getX() + BreadCrumbPanel.this.button2Info.getWidth() + 10;
                    } else {
                        currentX = BreadCrumbPanel.this.button2.getX() + BreadCrumbPanel.this.button2.getWidth() + 10;
                    }
                }
                if (BreadCrumbPanel.this.button3 != null) {
                    BreadCrumbPanel.this.button3.setLocation(currentX, BreadCrumbPanel.this.button.getY());
                    BreadCrumbPanel.this.button3.setSize(BreadCrumbPanel.this.button3.getPreferredSize());
                }
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }
    }
}

