/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.batch;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.batch.BatchJobListener;
import ch.icit.pegasus.client.gui.utils.popup.inserts.StringPopUpInsert;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;

public class BatchJobProcessInfoInsert
extends StringPopUpInsert
implements BatchJobListener {
    private static final long serialVersionUID = 1L;
    private BatchJob<?> job;

    public BatchJobProcessInfoInsert(BatchJob<?> job) {
        super("");
        this.job = job;
        this.job.addBatchJobListener(this);
        this.switchState();
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.job.removeBatchJobListener(this);
    }

    private void switchState() {
        switch (this.job.getJobState()) {
            case DONE: {
                this.setText(this.job.getSuccessText());
                this.hideAnimation();
                break;
            }
            case ERROR: {
                String t = "<b>" + this.job.getErrorText() + "</b>";
                if (this.job.getErrors() != null && !this.job.getErrors().isEmpty()) {
                    t = t + ScreenValidationObject.createMessageList(this.job.getErrors());
                }
                this.setText(t);
                this.hideAnimation();
                break;
            }
            case LOADING: {
                this.ensureAnimation(this.job.getLoadingText(), this.job.getLoadingText());
                break;
            }
            case WAITING: {
                this.ensureAnimation(this.job.getWaitingText(), this.job.getWaitingText());
                break;
            }
        }
    }

    public void batchStateChanged(BatchJob job, Node node) {
        this.switchState();
    }
}

