/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.io;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.io.FileDownloader;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferState;
import ch.icit.pegasus.client.io.FileUploader;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import ch.icit.pegasus.server.core.services.file.FileService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.MessageDigest;

public class FileTransferUtil {
    public static <T extends PegasusFileComplete> T upload(T file, FileTransferListener ... listeners) throws Exception {
        return FileTransferUtil.upload0(file, false, listeners);
    }

    public static void replace(PegasusFileComplete fileReference, File file, FileTransferListener ... listeners) throws Exception {
        fileReference.setLocalFile(file);
        FileTransferUtil.upload0(fileReference, true, listeners);
    }

    private static <T extends PegasusFileComplete> T upload0(T file, boolean overwrite, FileTransferListener ... listeners) throws Exception {
        try {
            FileUploader<T> uploader = new FileUploader<T>(file, overwrite, listeners);
            uploader.run();
            if (listeners.length == 0 && uploader.getException() != null) {
                throw uploader.getException();
            }
            return uploader.getFileReference();
        }
        catch (IOException e) {
            FileTransferUtil.throwException((Exception)new ClientServerCallException("", (Exception)e), listeners);
            return null;
        }
    }

    public static File download(PegasusFileComplete fileReference, FileTransferListener ... listeners) throws Exception {
        if (fileReference.getLocalFile() != null) {
            if (listeners != null) {
                FileTransferState s = new FileTransferState(FileTransferState.State.FINISHED, 0L, 0L, 0L);
                for (FileTransferListener l : listeners) {
                    l.statusChanged(fileReference.getLocalFile(), s);
                }
            }
            return fileReference.getLocalFile();
        }
        File file = FileTransferUtil.download(fileReference.getUri(), listeners);
        fileReference.setLocalFile(file);
        return file;
    }

    public static File download(URI fileURI, FileTransferListener ... listeners) throws Exception {
        try {
            FileDownloader downloader = new FileDownloader(fileURI, listeners);
            downloader.run();
            if (listeners.length == 0 && downloader.getException() != null) {
                throw downloader.getException();
            }
            return downloader.getLocalFile();
        }
        catch (IOException e) {
            FileTransferUtil.throwException(e, listeners);
            return null;
        }
    }

    public static PegasusFileComplete clone(PegasusFileComplete fileReference) throws Exception {
        try {
            return ((FileService)EjbContextFactory.getInstance().getService(FileService.class)).clone(fileReference);
        }
        catch (ServiceException e) {
            throw new IOException(e);
        }
    }

    public static void delete(PegasusFileComplete fileReference) throws Exception {
        try {
            ((FileService)EjbContextFactory.getInstance().getService(FileService.class)).remove(fileReference);
        }
        catch (ServiceException e) {
            throw new IOException(e);
        }
    }

    public static boolean exists(URI uri) throws IOException {
        try {
            return ((FileService)EjbContextFactory.getInstance().getService(FileService.class)).exists(uri);
        }
        catch (ServiceException e) {
            throw new IOException(e);
        }
    }

    private static void throwException(Exception exception, FileTransferListener ... listeners) throws Exception {
        if (listeners == null || listeners.length == 0) {
            throw exception;
        }
        for (FileTransferListener l : listeners) {
            l.exceptionOccurred(exception);
        }
    }

    public static String MD5HashFile(String filename) throws Exception {
        byte[] buf = FileTransferUtil.ChecksumFile(filename);
        String res = "";
        for (int i = 0; i < buf.length; ++i) {
            res = res + Integer.toString((buf[i] & 0xFF) + 256, 16).substring(1);
        }
        return res;
    }

    public static byte[] ChecksumFile(String filename) throws Exception {
        MessageDigest complete;
        try (FileInputStream fis = new FileInputStream(filename);){
            int n;
            byte[] buf = new byte[1024];
            complete = MessageDigest.getInstance("MD5");
            do {
                if ((n = ((InputStream)fis).read(buf)) <= 0) continue;
                complete.update(buf, 0, n);
            } while (n != -1);
        }
        return complete.digest();
    }
}

