/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.io;

import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferState;
import java.io.File;
import java.io.IOException;

public abstract class FileTransfer {
    static final int BUFFER_SIZE = 524288;
    protected final File localFile;
    private FileTransferListener[] listeners;
    private long expectedSize;
    private long transferred = 0L;
    private IOException exception = null;

    public FileTransfer(File file, FileTransferListener[] listeners) {
        if (file == null) {
            throw new IllegalArgumentException("file is null!");
        }
        this.localFile = file;
        this.listeners = listeners;
        this.statusChanged(this.getState(FileTransferState.State.NEW));
    }

    protected static String getFileSuffix(String fileName) {
        int idx = fileName.lastIndexOf(".");
        if (idx > 0) {
            return fileName.substring(idx + 1);
        }
        return null;
    }

    void statusChanged(FileTransferState state) {
        for (FileTransferListener listener : this.listeners) {
            listener.statusChanged(this.localFile, state);
        }
    }

    void exceptionOccured(IOException e) {
        if (this.listeners.length == 0) {
            this.exception = e;
        }
        for (FileTransferListener listener : this.listeners) {
            listener.exceptionOccurred(e);
        }
    }

    void exceptionOccured(Exception e) {
        IOException ex = new IOException(e.getMessage());
        if (this.listeners.length == 0) {
            this.exception = ex;
        }
        this.exceptionOccured(ex);
    }

    void transferred(int size) {
        this.transferred += (long)size;
        this.statusChanged(this.getState(FileTransferState.State.IN_PROGRESS));
    }

    void finished() {
        this.statusChanged(this.getState(FileTransferState.State.FINISHED));
    }

    private FileTransferState getState(FileTransferState.State state) {
        return new FileTransferState(state, this.expectedSize, this.transferred, this.expectedSize - this.transferred);
    }

    protected void setExpectedSize(long expectedSize) {
        this.expectedSize = expectedSize;
    }

    public IOException getException() {
        return this.exception;
    }

    public File getLocalFile() {
        return this.localFile;
    }
}

