/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util;

import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationList;
import ch.icit.pegasus.server.core.i18n.Words;
import java.util.ArrayList;
import java.util.List;

public class ScreenValidationObject {
    private final String message;
    private final ValidationStateE state;

    public ScreenValidationObject(ValidationStateE state, String message) {
        this.message = message;
        this.state = state;
    }

    public static ScreenValidationList convertToScreenValidationList(List<String> strings) {
        ScreenValidationList validations = new ScreenValidationList();
        for (String string : strings) {
            validations.add(new ScreenValidationObject(ValidationStateE.FATAL, string));
        }
        return validations;
    }

    public static boolean isErrorList(Node n) {
        List l;
        return n != null && n.getValue() instanceof List && !(l = (List)n.getValue()).isEmpty() && l.get(0) instanceof ScreenValidationObject;
    }

    public static boolean isErrorList(List<ScreenValidationObject> n) {
        List<ScreenValidationObject> l = n;
        return !l.isEmpty() && l.get(0) instanceof ScreenValidationObject;
    }

    public ValidationStateE getState() {
        return this.state;
    }

    public String getMessage() {
        return this.message;
    }

    public static List<ScreenValidationObject> createList(ScreenValidationObject ... objects) {
        ArrayList<ScreenValidationObject> l = new ArrayList<ScreenValidationObject>();
        for (ScreenValidationObject o : objects) {
            l.add(o);
        }
        return l;
    }

    public static ScreenValidationList convertListFromString(List<String> list) {
        ScreenValidationList l = new ScreenValidationList();
        for (String s : list) {
            l.add(new ScreenValidationObject(ValidationStateE.FATAL, s));
        }
        return l;
    }

    public static ScreenValidationList convertListFromString(List<String> list, ValidationStateE state) {
        ScreenValidationList l = new ScreenValidationList();
        for (String s : list) {
            l.add(new ScreenValidationObject(state, s));
        }
        return l;
    }

    public static ValidationStateE getMessageState(List<ScreenValidationObject> o) {
        boolean hasFatals = false;
        boolean hasWarnings = false;
        boolean hasMessages = false;
        for (ScreenValidationObject e : o) {
            switch (e.getState()) {
                case FATAL: {
                    hasFatals = true;
                    break;
                }
                case MESSAGE: {
                    hasMessages = true;
                    break;
                }
                case WARNING: {
                    hasWarnings = true;
                }
            }
        }
        if (hasFatals) {
            return ValidationStateE.FATAL;
        }
        if (hasWarnings) {
            return ValidationStateE.WARNING;
        }
        return ValidationStateE.MESSAGE;
    }

    public static boolean isFatal(List<ScreenValidationObject> o) {
        for (ScreenValidationObject e : o) {
            switch (e.getState()) {
                case FATAL: {
                    return true;
                }
                case MESSAGE: {
                    break;
                }
            }
        }
        return false;
    }

    public static boolean isError(List<ScreenValidationObject> o) {
        for (ScreenValidationObject e : o) {
            switch (e.getState()) {
                case FATAL: {
                    return true;
                }
                case MESSAGE: {
                    break;
                }
                case WARNING: {
                    return true;
                }
            }
        }
        return false;
    }

    public static String createMessageString(List<ScreenValidationObject> o, String errorPrefix) {
        boolean hasFatals = false;
        boolean hasWarnings = false;
        boolean hasMessages = false;
        for (ScreenValidationObject e : o) {
            switch (e.getState()) {
                case FATAL: {
                    hasFatals = true;
                    break;
                }
                case MESSAGE: {
                    hasMessages = true;
                    break;
                }
                case WARNING: {
                    hasWarnings = true;
                }
            }
        }
        StringBuilder builder = new StringBuilder();
        if (hasFatals) {
            if (errorPrefix != null) {
                builder.append("<b>");
                builder.append(errorPrefix);
                builder.append("</b><br/><br/>");
            }
            builder.append("<b>" + Words.FOLLOWING_ERRORS_OCCURED + "</b><br/><ul>");
            for (ScreenValidationObject e : o) {
                if (e.getState() != ValidationStateE.FATAL) continue;
                builder.append("<li>");
                builder.append(e.getMessage());
                builder.append("</li>");
            }
            builder.append("</ul><br/><br/>");
        }
        if (hasWarnings) {
            builder.append("<b>" + Words.FOLLOWING_WARNINGS_OCCURRED + "</b><br/><ul>");
            for (ScreenValidationObject e : o) {
                if (e.getState() != ValidationStateE.WARNING) continue;
                builder.append("<li>");
                builder.append(e.getMessage());
                builder.append("</li>");
            }
            builder.append("</ul><br/><br/>");
        }
        if (hasMessages) {
            if (errorPrefix != null) {
                builder.append("<b>");
                builder.append(errorPrefix);
                builder.append(":</b><br/><ul>");
            } else {
                builder.append("<b>" + Words.FOLLOWING_MESSAGE_OCCURRED + "</b><br/><ul>");
            }
            for (ScreenValidationObject e : o) {
                if (e.getState() != ValidationStateE.MESSAGE) continue;
                builder.append("<li>");
                builder.append(e.getMessage());
                builder.append("</li>");
            }
            builder.append("</ul>");
        }
        return builder.toString();
    }

    public static String createMessageList(List<ScreenValidationObject> o) {
        StringBuilder builder = new StringBuilder();
        builder.append("<ul>");
        for (ScreenValidationObject e : o) {
            builder.append("<li>");
            builder.append(e.getMessage());
            builder.append("</li>");
        }
        builder.append("</ul>");
        return builder.toString();
    }

    public static String createMessageString(List<ScreenValidationObject> o) {
        return ScreenValidationObject.createMessageString(o, Words.UNABLE_TO_SAVE);
    }

    public static List<ScreenValidationObject> createList(List<String> errors) {
        return ScreenValidationObject.createList(errors, ValidationStateE.FATAL);
    }

    public static List<ScreenValidationObject> createList(List<String> errors, ValidationStateE state) {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        for (String t : errors) {
            a.add(new ScreenValidationObject(state, t));
        }
        return a;
    }

    public static List<ScreenValidationObject> convertList(List<Exception> list) {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        for (Exception t : list) {
            a.add(new ScreenValidationObject(ValidationStateE.FATAL, t.getMessage()));
        }
        return a;
    }

    public static List<ScreenValidationObject> filter(List<ScreenValidationObject> t, ValidationStateE type) {
        if (type == null) {
            return t;
        }
        ArrayList<ScreenValidationObject> ret = new ArrayList<ScreenValidationObject>();
        for (ScreenValidationObject v : t) {
            if (!v.getState().equals((Object)type)) continue;
            ret.add(v);
        }
        return ret;
    }

    public static enum ValidationStateE {
        FATAL,
        WARNING,
        MESSAGE;

    }
}

