/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.weeklyplan;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.services.interfaces.weeklyplan.WeeklyPlanServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductReference;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanComplete;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanLight;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanReference;
import ch.icit.pegasus.server.core.dtos.production_new.charges.ProductChargeBatchComplete;
import ch.icit.pegasus.server.core.dtos.production_new.charges.ProductChargeComplete;
import ch.icit.pegasus.server.core.dtos.production_new.charges.RecipeChargeBatchComplete;
import ch.icit.pegasus.server.core.dtos.production_new.charges.RecipeChargeComplete;
import ch.icit.pegasus.server.core.dtos.production_new.consumption.ArticleChargePart2Complete;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.ArticlePreparationJobComplete;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.JobComplete;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.JobReference;
import ch.icit.pegasus.server.core.dtos.production_new.store.product.ProductStockCheckinGroupComplete;
import ch.icit.pegasus.server.core.dtos.production_new.store.product.ProductStockCheckinGroupReference;
import ch.icit.pegasus.server.core.dtos.production_new.store.product.ProductStockCheckoutGroupComplete;
import ch.icit.pegasus.server.core.dtos.production_new.store.product.ProductStockCheckoutGroupReference;
import ch.icit.pegasus.server.core.dtos.production_new.store.product.ProductStockMovementGroupComplete;
import ch.icit.pegasus.server.core.dtos.production_new.store.product.ProductStockMovementGroupReference;
import ch.icit.pegasus.server.core.dtos.production_new.store.recipe.RecipeStockCheckinGroupComplete;
import ch.icit.pegasus.server.core.dtos.production_new.store.recipe.RecipeStockCheckinGroupReference;
import ch.icit.pegasus.server.core.dtos.production_new.store.recipe.RecipeStockCheckoutGroupComplete;
import ch.icit.pegasus.server.core.dtos.production_new.store.recipe.RecipeStockCheckoutGroupReference;
import ch.icit.pegasus.server.core.dtos.production_new.store.recipe.RecipeStockMovementGroupComplete;
import ch.icit.pegasus.server.core.dtos.production_new.store.recipe.RecipeStockMovementGroupReference;
import ch.icit.pegasus.server.core.dtos.production_new.transactions.ProductCountTransactionComplete;
import ch.icit.pegasus.server.core.dtos.production_new.transactions.ProductMoveTransactionComplete;
import ch.icit.pegasus.server.core.dtos.production_new.transactions.RecipeCountTransactionComplete;
import ch.icit.pegasus.server.core.dtos.production_new.transactions.RecipeMoveTransactionComplete;
import ch.icit.pegasus.server.core.dtos.production_new.transactions.corrections.ProductCountTransactionCorrectionComplete;
import ch.icit.pegasus.server.core.dtos.production_new.transactions.corrections.ProductMoveTransactionCorrectionComplete;
import ch.icit.pegasus.server.core.dtos.production_new.transactions.corrections.RecipeCountTransactionCorrectionComplete;
import ch.icit.pegasus.server.core.dtos.production_new.transactions.corrections.RecipeMoveTransactionCorrectionComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeReference;
import ch.icit.pegasus.server.core.dtos.report.ProductGroupCheckinReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ProductGroupCheckoutReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ProductGroupMovementReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.RecipeGroupCheckinReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.RecipeGroupCheckoutReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.RecipeGroupMovementReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.MapWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import ch.icit.pegasus.server.core.services.weeklyplan.WeeklyPlanService;

public class WeeklyPlanServiceManagerImpl
implements WeeklyPlanServiceManager {
    @Override
    public OptionalWrapper<PegasusFileComplete> printProductStockPerStorePosition(ListWrapper<ProductReference> products) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).printProductStockPerStorePosition(products);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> printRecipeStockPerStorePosition(ListWrapper<RecipeReference> recipes) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).printRecipeStockPerStorePosition(recipes);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public MapWrapper<StorePositionLight, StoreQuantityComplete> getProductStockPerStorePosition(ProductReference productReference) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).getProductStockPerStorePosition(productReference);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public MapWrapper<StorePositionLight, StoreQuantityComplete> getRecipeStockPerStorePosition(RecipeReference recipeReference) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).getRecipeStockPerStorePosition(recipeReference);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    public ListWrapper<ProductChargeComplete> getProductChargesForPosition(ProductReference product, StorePositionLight position) throws ServiceException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).getProductChargesForPosition(product, position);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    public ListWrapper<RecipeChargeComplete> getRecipeChargesForPosition(RecipeReference recipe, StorePositionLight position) throws ServiceException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).getRecipeChargesForPosition(recipe, position);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<StorePositionLight> getStockForProductAndStore(ProductReference product, StoreReference store) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).getStockForProductAndStore(product, store);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<StoreLight> getStockForProduct(ProductReference product) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).getStockForProduct(product);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public QuantityComplete getRecipeStockForPosition(RecipeReference recipe, StorePositionLight position) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).getRecipeStockForPosition(recipe, position);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<ProductChargeBatchComplete> getProductBatchesForPosition(ProductReference product, StorePositionLight position) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).getProductBatchesForPosition(product, position);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    public ListWrapper<StoreLight> getStockForRecipe(RecipeReference product) throws ServiceException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).getStockForRecipe(product);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    public ListWrapper<StorePositionLight> getStockForRecipeAndStore(RecipeReference product, StoreReference store) throws ServiceException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).getStockForRecipeAndStore(product, store);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<RecipeChargeBatchComplete> getRecipeBatchesForPosition(RecipeReference recipe, StorePositionLight position) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).getRecipeBatchesForPosition(recipe, position);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public QuantityComplete getProductStockForPosition(ProductReference product, StorePositionLight position) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).getProductStockForPosition(product, position);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createProductGroupCheckoutReport(ProductGroupCheckoutReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).createProductGroupCheckoutReport(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createProductGroupCheckinReport(ProductGroupCheckinReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).createProductGroupCheckinReport(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createProductGroupMovementReport(ProductGroupMovementReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).createProductGroupMovementReport(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createRecipeGroupCheckinReport(RecipeGroupCheckinReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).createRecipeGroupCheckinReport(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createRecipeGroupMovementReport(RecipeGroupMovementReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).createRecipeGroupMovementReport(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createRecipeGroupCheckoutReport(RecipeGroupCheckoutReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).createRecipeGroupCheckoutReport(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RecipeStockMovementGroupComplete> createRecipeMovementGroup(RecipeStockMovementGroupComplete group, boolean positionBased) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).createRecipeMovementGroup(group, positionBased);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ProductStockCheckinGroupComplete> getProductCheckinGroup(ProductStockCheckinGroupReference group) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).getProductCheckinGroup(group);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ProductStockCheckoutGroupComplete> getProductCheckoutGroup(ProductStockCheckoutGroupReference group) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).getProductCheckoutGroup(group);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ProductStockMovementGroupComplete> getProductMovementGroup(ProductStockMovementGroupReference group) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).getProductMovementGroup(group);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RecipeStockCheckinGroupComplete> getRecipeCheckinGroup(RecipeStockCheckinGroupReference group) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).getRecipeCheckinGroup(group);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RecipeStockCheckoutGroupComplete> getRecipeCheckoutGroup(RecipeStockCheckoutGroupReference group) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).getRecipeCheckoutGroup(group);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RecipeStockMovementGroupComplete> getRecipeMovementGroup(RecipeStockMovementGroupReference group) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).getRecipeMovementGroup(group);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ProductStockCheckinGroupComplete> updateProductCheckinGroup(ProductStockCheckinGroupComplete group) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).updateProductCheckinGroup(group);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ProductStockCheckoutGroupComplete> updateProductCheckoutGroup(ProductStockCheckoutGroupComplete group) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).updateProductCheckoutGroup(group);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ProductStockMovementGroupComplete> updateProductMovementGroup(ProductStockMovementGroupComplete group) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).updateProductMovementGroup(group);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RecipeStockCheckinGroupComplete> updateRecipeCheckinGroup(RecipeStockCheckinGroupComplete group) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).updateRecipeCheckinGroup(group);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RecipeStockCheckoutGroupComplete> updateRecipeCheckoutGroup(RecipeStockCheckoutGroupComplete group) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).updateRecipeCheckoutGroup(group);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RecipeStockMovementGroupComplete> updateRecipeMovementGroup(RecipeStockMovementGroupComplete group) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).updateRecipeMovementGroup(group);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ProductStockCheckinGroupComplete> createProductCheckinGroup(ProductStockCheckinGroupComplete group) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).createProductCheckinGroup(group);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ProductStockCheckoutGroupComplete> createProductCheckoutGroup(ProductStockCheckoutGroupComplete group, boolean positionBased) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).createProductCheckoutGroup(group, positionBased);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ProductStockMovementGroupComplete> createProductMovementGroup(ProductStockMovementGroupComplete group, boolean positionBased) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).createProductMovementGroup(group, positionBased);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RecipeStockCheckinGroupComplete> createRecipeCheckinGroup(RecipeStockCheckinGroupComplete group) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).createRecipeCheckinGroup(group);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RecipeStockCheckoutGroupComplete> createRecipeCheckoutGroup(RecipeStockCheckoutGroupComplete group, boolean positionBased) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).createRecipeCheckoutGroup(group, positionBased);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<JobComplete> getJob(JobReference jobReference) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).getJob(jobReference);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<JobComplete> updateJob(ArticlePreparationJobComplete job) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).updateJob(job);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public boolean prepareArticle(JobReference job, ArticleChargePart2Complete part, boolean chargeBased) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).prepareArticle(job, part, chargeBased);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public void deleteWeeklyPlan(WeeklyPlanLight goods) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(WeeklyPlanService.class).deleteWeeklyPlan(goods);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public void jobProduced(JobReference job) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(WeeklyPlanService.class).jobProduced(job);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public void startJob(JobReference job) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(WeeklyPlanService.class).startJob(job);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public void processJob(JobReference job) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(WeeklyPlanService.class).processJob(job);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> printProductionSheets(ListWrapper<JobReference> jobsComplete) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).printProductionSheets(jobsComplete);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public QuantityComplete getRecipeStock(RecipeReference reference, TimestampWrapper dueDate) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).getRecipeStock(reference, dueDate);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public QuantityComplete getProductStock(ProductReference reference, TimestampWrapper dueDate) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).getProductStock(reference, dueDate);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<WeeklyPlanComplete> createWeeklyPlan(WeeklyPlanComplete goods) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).createWeeklyPlan(goods);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public MapWrapper<RecipeReference, QuantityComplete> getRecipeUsageForProduct(ProductReference reference, Integer amount, TimestampWrapper validity) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).getRecipeUsageForProduct(reference, amount, validity);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public MapWrapper<ProductReference, Integer> getProductUsageForFlight(FlightReference reference) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).getProductUsageForFlight(reference);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<WeeklyPlanComplete> updateWeeklyPlan(WeeklyPlanComplete goods) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).updateWeeklyPlan(goods);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<WeeklyPlanComplete> getComplete(WeeklyPlanReference goods) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).getComplete(goods);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<WeeklyPlanComplete> calculateWeeklyPlanProductionTargets(WeeklyPlanReference weeklyPlan) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).calculateWeeklyPlanProductionTargets(weeklyPlan);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<WeeklyPlanComplete> updateFlightsOnWeeklyPlan(WeeklyPlanReference weeklyPlan) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).updateFlightsOnWeeklyPlan(weeklyPlan);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public MapWrapper<ProductReference, QuantityComplete> moveProduct(ProductMoveTransactionComplete transactionComplete) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).moveProduct(transactionComplete);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public MapWrapper<RecipeReference, QuantityComplete> moveRecipe(RecipeMoveTransactionComplete transactionComplete) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).moveRecipe(transactionComplete);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public MapWrapper<ProductReference, QuantityComplete> correctCountProductChargeBased(ProductCountTransactionCorrectionComplete correctionComplete) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).correctCountProductChargeBased(correctionComplete);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public MapWrapper<ProductReference, QuantityComplete> correctMoveProduct(ProductMoveTransactionCorrectionComplete correctionComplete) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).correctMoveProduct(correctionComplete);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public MapWrapper<ProductReference, QuantityComplete> countProductPositionBased(ProductCountTransactionComplete transactionComplete) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).countProductPositionBased(transactionComplete);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public MapWrapper<RecipeReference, QuantityComplete> correctCountRecipeChargeBased(RecipeCountTransactionCorrectionComplete correctionComplete) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).correctCountRecipeChargeBased(correctionComplete);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public MapWrapper<RecipeReference, QuantityComplete> correctMoveRecipe(RecipeMoveTransactionCorrectionComplete correctionComplete) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).correctMoveRecipe(correctionComplete);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public MapWrapper<RecipeReference, QuantityComplete> countRecipePositionBased(RecipeCountTransactionComplete transactionComplete) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).countRecipePositionBased(transactionComplete);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createLabelProductionSheet(WeeklyPlanReference weeklyPlanReference, ReportFileComplete selectedReport, ReportingOutputFormatE formatE) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).createLabelProductionSheet(weeklyPlanReference, selectedReport, formatE);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createWeeklyPlanSheet(WeeklyPlanReference weeklyPlan, ReportFileComplete selectedReport, ReportingOutputFormatE outputFormat) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(WeeklyPlanService.class).createWeeklyPlanSheet(weeklyPlan, selectedReport, outputFormat);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }
}

