/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.quality;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.quality.QualityServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.quality.ccp0102.CCP0102ConfigComplete;
import ch.icit.pegasus.server.core.dtos.quality.ccp0102.CCP0102MeasurementComplete;
import ch.icit.pegasus.server.core.dtos.quality.ccp0102.CCP0102MeasurementReference;
import ch.icit.pegasus.server.core.dtos.quality.oprp05.OPRP05ConfigComplete;
import ch.icit.pegasus.server.core.dtos.spotcheck.ccp0102.CCP0102SpotCheckReviewReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.services.quality.QualityService;

public class QualityServiceManagerImpl
implements QualityServiceManager {
    @Override
    public void deleteCCP0102Config(CCP0102ConfigComplete config) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(QualityService.class).deleteCCP0102Config(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createDetailsReport(ListWrapper<CCP0102MeasurementReference> ccpMeasurementReferenceListWrapper) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(QualityService.class).createDetailsReport(ccpMeasurementReferenceListWrapper);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createCCP0102Sheet(ReportFileComplete report, CCP0102MeasurementReference data) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(QualityService.class).createCCP0102Sheet(report, data);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createRecipeSheets(ReportFileComplete selectedReport, CCP0102MeasurementReference ccp0102MeasurementReference) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(QualityService.class).createRecipeSheets(selectedReport, ccp0102MeasurementReference);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<CCP0102MeasurementComplete> updateMeasurement(CCP0102MeasurementComplete complete) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(QualityService.class).updateMeasurement(complete);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<CCP0102ConfigComplete> updateCCP0102Config(CCP0102ConfigComplete config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(QualityService.class).updateCCP0102Config(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<CCP0102MeasurementComplete> getComplete(CCP0102MeasurementReference ref) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(QualityService.class).getComplete(ref);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void generateOPRP05() throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(QualityService.class).generateOPRP05();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<OPRP05ConfigComplete> updateOPRP05Config(OPRP05ConfigComplete config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(QualityService.class).updateOPRP05Config(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void deleteOPRP05Config(OPRP05ConfigComplete config) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(QualityService.class).deleteOPRP05Config(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void generateCCP0102() throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(QualityService.class).generateCCP0102();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createCCP0102SheetSpotCheck(ReportFileComplete report, CCP0102SpotCheckReviewReference data) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(QualityService.class).createCCP0102SheetSpotCheck(report, data);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }
}

