/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.converter;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.QuantityConverter2DecimalUnnormalized;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.OrderPositionTransactionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderAcceptationComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderPositionMutationComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderRecipientTransactionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderRejectionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderTransactionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderTransactionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.AFlightStockTransactionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.FlightStockCheckinComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.FlightStockCheckinCorrectionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.FlightStockCheckoutComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.FlightStockCheckoutCorrectionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.FlightStockIrregularityCorrectionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.FlightStockIrregularityMovementComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.FlightStockOutCorrectionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.FlightStockOutMovementComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.FlightStockReturnCorrectionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.FlightStockReturnMovementComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.FlightStockWasteCorrectionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.FlightStockWasteMovementComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockMovementComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockCheckinComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockCheckoutComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockInventoryComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockTransactionComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;

public class StockTransactionAmountConverter
implements Converter<StockTransactionComplete, String> {
    @Override
    public String convert(StockTransactionComplete o, Node<StockTransactionComplete> currentNode, Object ... param) {
        if (o == null) {
            return NULL_RETURN;
        }
        String retString = "";
        QuantityConverter2DecimalUnnormalized con = ConverterRegistry.getConverter(QuantityConverter2DecimalUnnormalized.class);
        if (o instanceof StockCheckinComplete) {
            retString = "+ " + (String)con.convert((Object)o.getAmount(), (Node)null, new Object[0]);
        } else if (o instanceof StockCheckoutComplete) {
            retString = "- " + (String)con.convert((Object)o.getAmount(), (Node)null, new Object[0]);
        } else if (o instanceof StockInventoryComplete) {
            StockInventoryComplete c = (StockInventoryComplete)o;
            String sign = "";
            if (c.getDelta() != null && c.getDelta().getAmount() != null) {
                sign = c.getDelta().getAmount() >= 0L ? "+" : "-";
                retString = (String)con.convert((Object)c.getDelta(), (Node)null, new Object[0]) + " (to " + (String)con.convert((Object)o.getAmount(), (Node)null, new Object[0]) + ")";
                if (c.getDelta().getAmount() < 0L) {
                    retString = retString.substring(1);
                }
                retString = sign + " " + retString;
            } else {
                retString = WordsToolkit.toLowerCase((String)Words.NA);
            }
        } else if (o instanceof ManualStockMovementComplete) {
            retString = "= " + (String)con.convert((Object)o.getAmount(), (Node)null, new Object[0]);
        } else if (o instanceof AFlightStockTransactionComplete) {
            if (o instanceof FlightStockCheckoutComplete) {
                retString = "= " + (String)con.convert((Object)o.getAmount(), (Node)null, new Object[0]);
            } else if (o instanceof FlightStockOutCorrectionComplete) {
                retString = "+ " + (String)con.convert((Object)o.getAmount(), (Node)null, new Object[0]);
            } else if (o instanceof FlightStockIrregularityMovementComplete) {
                String sign = "+";
                if (o.getAmount().getAmount() < 0L) {
                    sign = "-";
                }
                retString = sign + " " + (String)con.convert((Object)o.getAmount(), (Node)null, new Object[0]);
            } else if (o instanceof FlightStockOutMovementComplete) {
                retString = "- " + (String)con.convert((Object)o.getAmount(), (Node)null, new Object[0]);
            } else if (o instanceof FlightStockReturnMovementComplete) {
                retString = "+ " + (String)con.convert((Object)o.getAmount(), (Node)null, new Object[0]);
            } else if (o instanceof FlightStockWasteMovementComplete) {
                retString = "+ " + (String)con.convert((Object)o.getAmount(), (Node)null, new Object[0]);
            } else if (o instanceof FlightStockCheckoutCorrectionComplete) {
                retString = "= " + (String)con.convert((Object)o.getAmount(), (Node)null, new Object[0]);
            } else if (o instanceof FlightStockIrregularityCorrectionComplete) {
                retString = "- " + (String)con.convert((Object)o.getAmount(), (Node)null, new Object[0]);
            } else if (o instanceof FlightStockReturnCorrectionComplete) {
                retString = "- " + (String)con.convert((Object)o.getAmount(), (Node)null, new Object[0]);
            } else if (o instanceof FlightStockWasteCorrectionComplete) {
                retString = "- " + (String)con.convert((Object)o.getAmount(), (Node)null, new Object[0]);
            } else if (o instanceof FlightStockCheckinComplete) {
                retString = "+ " + (String)con.convert((Object)o.getAmount(), (Node)null, new Object[0]);
            } else if (o instanceof FlightStockCheckinCorrectionComplete) {
                retString = "- " + (String)con.convert((Object)o.getAmount(), (Node)null, new Object[0]);
            }
        } else if (o instanceof OrderPositionTransactionComplete) {
            if (o instanceof PurchaseOrderTransactionComplete) {
                if (o instanceof PurchaseOrderPositionMutationComplete) {
                    retString = "= " + (String)con.convert((Object)o.getAmount(), (Node)null, new Object[0]);
                } else if (o instanceof PurchaseOrderRecipientTransactionComplete) {
                    if (o instanceof PurchaseOrderAcceptationComplete) {
                        retString = "+ " + (String)con.convert((Object)o.getAmount(), (Node)null, new Object[0]);
                    } else if (o instanceof PurchaseOrderRejectionComplete) {
                        retString = "= " + (String)con.convert((Object)o.getAmount(), (Node)null, new Object[0]);
                    }
                }
            } else if (o instanceof RequisitionOrderTransactionComplete) {
                retString = "= " + (String)con.convert((Object)o.getAmount(), (Node)null, new Object[0]);
            }
        }
        return retString;
    }

    @Override
    public Class<? extends StockTransactionComplete> getParameterClass() {
        return StockTransactionComplete.class;
    }
}

