/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.converter;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.PriceConverter2;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import java.sql.Timestamp;

public class RecipeVariantPriceInKgConverter
implements Converter<RecipeVariantLight, String> {
    @Override
    public String convert(RecipeVariantLight o, Node<RecipeVariantLight> currentNode, Object ... param) {
        if (o == null) {
            return NULL_RETURN;
        }
        SystemSettingsComplete settings = NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        PriceComplete priceInKg = o.getPrice() != null ? new PriceComplete(o.getPrice()) : new PriceComplete();
        QuantityComplete yieldInKg = new QuantityComplete();
        if (priceInKg.getPrice() == null) {
            priceInKg.setPrice(Double.valueOf(0.0));
        }
        if (priceInKg.getCurrency() == null) {
            priceInKg.setCurrency(settings.getCurrency());
        }
        Timestamp validity = new Timestamp(o.getValidityPeriod().getStartDate().getTime());
        int unitContaining = UnitConversionToolkit.isUnitContaining((UnitComplete)o.getYield().getUnit(), (UnitComplete)settings.getDefaultRecipeUnit(), null, (Timestamp)validity);
        if (unitContaining == 3) {
            double amount = UnitConversionToolkit.convertUnit((UnitComplete)o.getYield().getUnit(), (UnitComplete)settings.getDefaultRecipeUnit(), (double)o.getYield().getQuantity(), null, (Timestamp)validity);
            yieldInKg.setQuantity(Double.valueOf(amount));
            yieldInKg.setUnit(settings.getDefaultRecipeUnit());
            double factor = UnitConversionToolkit.getConversionFactor((UnitComplete)o.getYield().getUnit(), (UnitComplete)settings.getDefaultRecipeUnit());
            priceInKg.setPrice(Double.valueOf(priceInKg.getPrice() * factor));
        } else {
            Double conversionToDefaultUnit = o.getConversionToDefaultUnit();
            if (conversionToDefaultUnit == null) {
                conversionToDefaultUnit = 1.0;
            }
            yieldInKg.setQuantity(conversionToDefaultUnit);
            yieldInKg.setUnit(settings.getDefaultRecipeUnit());
            priceInKg.setPrice(Double.valueOf(priceInKg.getPrice() / conversionToDefaultUnit));
        }
        PriceConverter2 p = ConverterRegistry.getConverter(PriceConverter2.class);
        String t = p.convert(priceInKg, (Node<PriceComplete>)null, new Object[0]);
        if (t.isEmpty()) {
            t = "0 " + settings.getCurrency().getCode();
        }
        t = t + "/";
        t = yieldInKg.getUnit() != null ? t + yieldInKg.getUnit().getShortName() : "-";
        return t;
    }

    @Override
    public Class<? extends RecipeVariantLight> getParameterClass() {
        return RecipeVariantLight.class;
    }
}

