/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.converter;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.DayTimeConverter;
import ch.icit.pegasus.client.converter.InternationalizedConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightTypeE;
import ch.icit.pegasus.server.core.i18n.Words;

public class FlightScheduleConverter
implements Converter<FlightScheduleLight, String> {
    @Override
    public String convert(FlightScheduleLight o, Node<FlightScheduleLight> currentNode, Object ... param) {
        if (o == null) {
            return NULL_RETURN;
        }
        InternationalizedConverter cc = ConverterRegistry.getConverter(DateConverter.class);
        DayTimeConverter timeConverter = ConverterRegistry.getConverter(DayTimeConverter.class);
        String t = "";
        if (o.getFlightType() == FlightTypeE.RETURN) {
            t = t + o.getOutboundCode();
            t = t + " " + timeConverter.convert(o.getStd(), (Node)null, new Object[0]);
            t = t + " / " + o.getInboundCode();
            t = t + " " + timeConverter.convert(o.getSta(), (Node)null, new Object[0]);
        } else {
            t = t + o.getInboundCode();
            t = t + " " + timeConverter.convert(o.getSta(), (Node)null, new Object[0]);
            t = t + " / " + o.getOutboundCode();
            t = t + " " + timeConverter.convert(o.getStd(), (Node)null, new Object[0]);
        }
        t = t + " " + Words.OPS_DAYS + ": ";
        int count = 0;
        for (Boolean opsDay : o.getDaysOfWeek()) {
            if (!Boolean.TRUE.equals(opsDay)) continue;
            ++count;
        }
        if (count == 7) {
            t = t + "#";
        } else {
            count = 0;
            for (Boolean opsDay : o.getDaysOfWeek()) {
                ++count;
                if (!Boolean.TRUE.equals(opsDay)) continue;
                t = t + count + " ";
            }
        }
        t = t + " (" + (String)cc.convert(o.getPeriod().getStartDate(), null, new Object[0]) + "-" + (String)cc.convert(o.getPeriod().getEndDate(), null, new Object[0]) + ")";
        return t;
    }

    @Override
    public Class<? extends FlightScheduleLight> getParameterClass() {
        return FlightScheduleLight.class;
    }
}

