/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.converter;

import ch.icit.pegasus.client.converter.BreadCrumbPriceConverter;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.product.CompoundComponentComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.i18n.Words;

public class ColumnTotalConverter
implements Converter<PriceComplete, String> {
    private final String prefix = Words.COMPONENT_PRICE;

    @Override
    public String convert(PriceComplete o, Node<PriceComplete> currentNode, Object ... param) {
        PriceComplete p = o;
        PriceComplete pp = null;
        pp = p != null ? new PriceComplete(p) : new PriceComplete();
        if (pp.getPrice() == null) {
            pp.setPrice(Double.valueOf(0.0));
        }
        BreadCrumbPriceConverter c = ConverterRegistry.getConverter(BreadCrumbPriceConverter.class);
        if (param != null && param.length >= 1 && param[0] instanceof CompoundComponentComplete) {
            RecipeVariantLight recipeVariant = ((CompoundComponentComplete)param[0]).getUnderlyingRecipe().getCurrentVariant();
            QuantityComplete yield = recipeVariant.getYield();
            if (pp != null) {
                pp.setPrice(Double.valueOf(pp.getPrice() / yield.getQuantity()));
                return this.prefix + " " + c.convert(pp, (Node<PriceComplete>)null, new Object[0]) + "/" + yield.getUnit().getShortName();
            }
        }
        return this.prefix + " " + c.convert(pp, (Node<PriceComplete>)null, new Object[0]);
    }

    @Override
    public Class<? extends PriceComplete> getParameterClass() {
        return PriceComplete.class;
    }
}

