/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util.toolkits;

import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.services.interfaces.flight.StowingListServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.FlightToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.AdditionalOrderComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.AlaCarteMealOrderComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightParameterConfig;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.flightschedule.SeatConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.SpecialMealOrderComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountDeliverySpaceComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountEquipmentComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountFlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountParameterConfig;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountProductComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.DeliverySpaceComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.search.GalleyEquipmentSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.tracking.EquipmentSealsComplete;
import ch.icit.pegasus.server.core.dtos.tracking.FlightSealsComplete;
import ch.icit.pegasus.server.core.dtos.tracking.SealComplete;
import ch.icit.pegasus.server.core.dtos.tracking.SealTypeE;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StowingToolkit {
    public static final String EQ_SEAL_AFFIX_NAME = "SealedEQs";
    private static Logger log = LoggerFactory.getLogger(StowingToolkit.class);

    public static Node<?> switchStowingList(FlightComplete oldFlight, StowingListLight newStowing, List<String> warnings, boolean fromUpdater) throws ClientServerCallException {
        ReturnsCountFlightComplete returnsCountDataOld = (ReturnsCountFlightComplete)ServiceManagerRegistry.getService(FlightServiceManager.class).getCountItems(new FlightReference(oldFlight.getId()), new ReturnsCountParameterConfig(null, oldFlight.getUpliftCount())).getValue();
        FlightComplete gettFlight = (FlightComplete)ServiceManagerRegistry.getService(FlightServiceManager.class).getFlight((FlightReference)oldFlight).getValue();
        oldFlight.setActiveStowingList(gettFlight.getActiveStowingList());
        oldFlight.setLegs(gettFlight.getLegs());
        Boolean canCreateFlight = ServiceManagerRegistry.getService(FlightServiceManager.class).canCreateFlight(oldFlight.getOutboundCode(), new TimestampWrapper(oldFlight.getStd()), oldFlight.getInboundCode(), new TimestampWrapper(oldFlight.getSta()), new FlightReference(oldFlight.getId()));
        if (!Boolean.TRUE.equals(canCreateFlight)) {
            DateTimeConverter c = ConverterRegistry.getConverter(DateTimeConverter.class);
            throw new ClientGetFromServerException("A Flight with Outbound (" + oldFlight.getOutboundCode() + ") at " + c.convert(oldFlight.getStd(), (Node)null, new Object[0]) + " and Inbound (" + oldFlight.getInboundCode() + ") at " + c.convert(oldFlight.getSta(), (Node)null, new Object[0]) + " already exists.");
        }
        FlightComplete f = (FlightComplete)ServiceManagerRegistry.getService(FlightServiceManager.class).update(oldFlight, (ListWrapper<String>)new ListWrapper(warnings), fromUpdater, false, true, false).getObject();
        if (!f.getFlightState().equals((Object)FlightStateE.PLANNED)) {
            StowingListLight l = ServiceManagerRegistry.getService(FlightServiceManager.class).switchStowingList(newStowing, (FlightReference)f, warnings, fromUpdater);
            f = (FlightComplete)ServiceManagerRegistry.getService(FlightServiceManager.class).getFlight(l.getFlight()).getValue();
        }
        FlightToolkit.ensurePaxFigureTypesInserted((FlightLight)f);
        switch (f.getFlightState()) {
            case CANCELLED: 
            case CLOSED: 
            case DISPATCHED: 
            case EN_ROUTE: 
            case OPEN: {
                if (returnsCountDataOld.getEquipments() == null || returnsCountDataOld.getEquipments().isEmpty()) break;
                boolean reviseOnly = f.getFlightState() == FlightStateE.EN_ROUTE || f.getFlightState() == FlightStateE.OPEN;
                ReturnsCountFlightComplete returnsCountDataNEW = (ReturnsCountFlightComplete)ServiceManagerRegistry.getService(FlightServiceManager.class).getCountItems(new FlightReference(f.getId()), new ReturnsCountParameterConfig(null, f.getUpliftCount())).getValue();
                StowingToolkit.mergeReturnsCount(returnsCountDataOld, returnsCountDataNEW, warnings, reviseOnly, f, fromUpdater);
                break;
            }
            case PLANNED: {
                break;
            }
        }
        return INodeCreator.getDefaultImpl().getNode4DTO(f, false, false);
    }

    public static void revalidateReturnsCount(ReturnsCountFlightComplete flight) {
        for (ReturnsCountEquipmentComplete e : flight.getEquipments()) {
            for (ReturnsCountDeliverySpaceComplete d : e.getDeliverySpaces()) {
                for (ReturnsCountProductComplete p : d.getProducts()) {
                    int sold;
                    int delivered;
                    if (Boolean.TRUE.equals(p.getProduct().getSalesOnBoard())) {
                        delivered = p.getUseRevisedDeliveredAmount() != false ? p.getRevisedDeliveredAmount() : p.getCalculatedDeliveredAmount();
                        int waste = Math.max(p.getWasteAmount(), 0);
                        sold = Math.max(p.getSoldAmount(), 0);
                        int missing = Math.max(p.getMissingAmount(), 0);
                        int returned = delivered - (waste + sold + missing);
                        p.setWasteAmount(Integer.valueOf(waste));
                        p.setSoldAmount(Integer.valueOf(sold));
                        p.setMissingAmount(Integer.valueOf(missing));
                        p.setCountedAmount(Integer.valueOf(returned));
                        continue;
                    }
                    delivered = p.getUseRevisedDeliveredAmount() != false ? p.getRevisedDeliveredAmount() : p.getCalculatedDeliveredAmount();
                    int returend = Math.min(p.getCountedAmount(), delivered);
                    sold = delivered - returend;
                    p.setWasteAmount(Integer.valueOf(0));
                    p.setSoldAmount(Integer.valueOf(sold));
                    p.setMissingAmount(Integer.valueOf(0));
                    p.setCountedAmount(Integer.valueOf(returend));
                }
            }
        }
    }

    public static Node<FlightComplete> reloadStowingListFromFlightSchedule(FlightComplete oldFlight, StowingListLight l, List<String> warnings, boolean fromUpdater, boolean useDefaultStw) throws ClientServerCallException {
        Boolean canCreateFlight;
        ArrayList<ScreenValidationObject> ccWarnings = new ArrayList<ScreenValidationObject>();
        StowingListTemplateComplete fsStw = null;
        boolean foundConfig = false;
        FlightScheduleComplete schedule = null;
        if (Boolean.TRUE.equals(oldFlight.getAdHoc())) {
            warnings.add("Unable to reload Stowing List for Flight " + oldFlight.getOutboundCode() + " @ " + oldFlight.getStd() + ": Ad Hoc Flight can't reload their Stowing. Use Flight Stowing List Template bar.");
            return INodeCreator.getDefaultImpl().getNode4DTO(oldFlight, false, false);
        }
        schedule = (FlightScheduleComplete)ServiceManagerRegistry.getService(FlightServiceManager.class).getFlightSchedule(oldFlight.getFlightSchedule()).getValue();
        if (useDefaultStw) {
            fsStw = schedule.getDefaultStowingList().getStowingList();
            foundConfig = fsStw != null;
        } else {
            if (oldFlight.getActiveStowingList() != null) {
                for (StowingListConfigurationComplete c : schedule.getStowingLists()) {
                    if (c.getStowingList() == null || !c.getStowingList().equals((Object)oldFlight.getActiveStowingList().getTemplate())) continue;
                    foundConfig = true;
                    fsStw = c.getStowingList();
                }
            }
            if (!foundConfig) {
                fsStw = schedule != null && schedule.getDefaultStowingList() != null ? schedule.getDefaultStowingList().getStowingList() : null;
                boolean bl = foundConfig = fsStw != null;
            }
        }
        if (!foundConfig) {
            warnings.add("No Stowing List for reload found.");
            return INodeCreator.getDefaultImpl().getNode4DTO(oldFlight, false, false);
        }
        oldFlight = StowingToolkit.checkCabinClassConsistence(oldFlight, l, warnings, fromUpdater, ccWarnings, fsStw);
        ReturnsCountFlightComplete returnsCountDataOld = (ReturnsCountFlightComplete)ServiceManagerRegistry.getService(FlightServiceManager.class).getCountAndManualSalesItems(new FlightReference(oldFlight.getId()), new ReturnsCountParameterConfig(null, oldFlight.getUpliftCount())).getValue();
        FlightComplete gettFlight = (FlightComplete)ServiceManagerRegistry.getService(FlightServiceManager.class).getFlight((FlightReference)oldFlight).getValue();
        StowingListLight newStowinglist = oldFlight.getActiveStowingList();
        oldFlight.setActiveStowingList(gettFlight.getActiveStowingList());
        HashMap<SpecialMealOrderComplete, DeliverySpaceComplete> oldSPMLPositions = new HashMap<SpecialMealOrderComplete, DeliverySpaceComplete>();
        List spmlSpaces = null;
        for (SpecialMealOrderComplete spml : oldFlight.getSpmlOrders()) {
            if (spml.getCount() < 1) {
                spml.setCount(Integer.valueOf(1));
            }
            if (spml.getMenuType() == null || !Boolean.TRUE.equals(spml.getMenuType().getAdditional())) continue;
            if (spml.getStowingPosition() == null) {
                if (spmlSpaces == null) {
                    spmlSpaces = ServiceManagerRegistry.getService(FlightServiceManager.class).getAdditionalSPMLOrderSpaces((FlightReference)oldFlight).getList();
                }
                StowingToolkit.selectNewSpace(spml, spmlSpaces);
            }
            oldSPMLPositions.put(spml, spml.getStowingPosition());
        }
        for (AlaCarteMealOrderComplete alacarte : oldFlight.getAlaCarteOrders()) {
            if (alacarte.getCount() >= 1) continue;
            alacarte.setCount(Integer.valueOf(1));
        }
        HashMap<AdditionalOrderComplete, DeliverySpaceComplete> oldAdditionalPositions = new HashMap<AdditionalOrderComplete, DeliverySpaceComplete>();
        List additionalSpaces = null;
        for (AdditionalOrderComplete a : oldFlight.getAdditionalOrders()) {
            if (additionalSpaces == null) {
                additionalSpaces = ServiceManagerRegistry.getService(FlightServiceManager.class).getAdditionalOrderSpaces((FlightReference)oldFlight).getList();
            }
            if (a.getStowingPosition() == null) {
                StowingToolkit.selectNewSpace(a, additionalSpaces);
            }
            oldAdditionalPositions.put(a, a.getStowingPosition());
        }
        Node<?> seals = NodeToolkit.getAffixNamed(EQ_SEAL_AFFIX_NAME);
        FlightSealsComplete fsc = null;
        if (seals != null && (fsc = (FlightSealsComplete)seals.getValue()) != null) {
            StowingToolkit.ensureSealState((FlightLight)oldFlight, fsc);
            ServiceManagerRegistry.getService(FlightServiceManager.class).updateSeals(fsc);
        }
        if (!(canCreateFlight = ServiceManagerRegistry.getService(FlightServiceManager.class).canCreateFlight(oldFlight.getOutboundCode(), new TimestampWrapper(oldFlight.getStd()), oldFlight.getInboundCode(), new TimestampWrapper(oldFlight.getSta()), new FlightReference(oldFlight.getId()))).booleanValue()) {
            DateTimeConverter c = ConverterRegistry.getConverter(DateTimeConverter.class);
            throw new ClientGetFromServerException("A Flight with Outbound (" + oldFlight.getOutboundCode() + ") at " + c.convert(oldFlight.getStd(), (Node)null, new Object[0]) + " and Inbound (" + oldFlight.getInboundCode() + ") at " + c.convert(oldFlight.getSta(), (Node)null, new Object[0]) + " already exists.");
        }
        FlightComplete updateFlight = (FlightComplete)ServiceManagerRegistry.getService(FlightServiceManager.class).update(oldFlight, (ListWrapper<String>)new ListWrapper(warnings), false, false, false, false).getObject();
        updateFlight.setActiveStowingList(newStowinglist);
        l = (StowingListLight)ServiceManagerRegistry.getService(FlightServiceManager.class).switchStowingListFromPersistedFlight(new FlightParameterConfig(new StowingListTemplateReference(fsStw.getId()), null, new FlightReference(updateFlight.getId()), updateFlight.getActiveStowingList().getMatriculation(), warnings, fromUpdater)).getValue();
        FlightComplete f = (FlightComplete)ServiceManagerRegistry.getService(FlightServiceManager.class).getFlight(l.getFlight()).getValue();
        if (fsc != null) {
            GalleyEquipmentSearchConfiguration g = new GalleyEquipmentSearchConfiguration();
            g.setFlight(new FlightReference(updateFlight.getId()));
            FlightSealsComplete eqs = (FlightSealsComplete)ServiceManagerRegistry.getService(FlightServiceManager.class).getFlightSeals(g).getValue();
            StowingToolkit.mergeSeals(eqs, fsc);
            NodeToolkit.removeAffixNamed(EQ_SEAL_AFFIX_NAME);
            eqs = (FlightSealsComplete)ServiceManagerRegistry.getService(FlightServiceManager.class).updateSeals(eqs).getValue();
            Node<FlightSealsComplete> sealedEqs = INodeCreator.getDefaultImpl().getNode4DTO(eqs, false, false);
            sealedEqs.setName(EQ_SEAL_AFFIX_NAME);
            NodeToolkit.addAffix(sealedEqs);
        }
        FlightToolkit.ensurePaxFigureTypesInserted((FlightLight)f);
        switch (f.getFlightState()) {
            case CANCELLED: 
            case CLOSED: 
            case DISPATCHED: 
            case EN_ROUTE: 
            case OPEN: {
                if (returnsCountDataOld.getEquipments() == null || returnsCountDataOld.getEquipments().isEmpty()) break;
                boolean reviseOnly = f.getFlightState() == FlightStateE.EN_ROUTE || f.getFlightState() == FlightStateE.OPEN;
                ReturnsCountFlightComplete returnsCountDataNEW = (ReturnsCountFlightComplete)ServiceManagerRegistry.getService(FlightServiceManager.class).getCountAndManualSalesItems(new FlightReference(f.getId()), new ReturnsCountParameterConfig(null, f.getUpliftCount())).getValue();
                StowingToolkit.mergeReturnsCount(returnsCountDataOld, returnsCountDataNEW, warnings, reviseOnly, f, fromUpdater);
                break;
            }
            case PLANNED: {
                break;
            }
        }
        ViewNode<Boolean> b = new ViewNode<Boolean>("hasOrders");
        if (!oldFlight.getSpmlOrders().isEmpty() || !oldFlight.getAdditionalOrders().isEmpty()) {
            b.setValue(true, 0L);
        } else {
            b.setValue(false, 0L);
        }
        if (((Boolean)b.getValue()).booleanValue()) {
            spmlSpaces = null;
            for (SpecialMealOrderComplete order : oldFlight.getSpmlOrders()) {
                if (order.getId() != null) continue;
                order.setStowingPosition(null);
                f.getSpmlOrders().add(order);
            }
            for (SpecialMealOrderComplete order : f.getSpmlOrders()) {
                if (order.getId() == null || !order.getMenuType().getAdditional().booleanValue()) continue;
                if (spmlSpaces == null) {
                    spmlSpaces = ServiceManagerRegistry.getService(FlightServiceManager.class).getAdditionalSPMLOrderSpaces((FlightReference)f).getList();
                }
                order.setStowingPosition((DeliverySpaceComplete)oldSPMLPositions.get(order));
                StowingToolkit.selectNewSpace(order, (List<DeliverySpaceComplete>)spmlSpaces);
            }
            for (SpecialMealOrderComplete order : oldFlight.getAlaCarteOrders()) {
                if (order.getId() != null) continue;
                f.getAlaCarteOrders().add(order);
            }
            additionalSpaces = null;
            for (SpecialMealOrderComplete order : oldFlight.getAdditionalOrders()) {
                if (order.getId() != null) continue;
                order.setStowingPosition(null);
                f.getAdditionalOrders().add(order);
            }
            for (SpecialMealOrderComplete order : f.getAdditionalOrders()) {
                if (order.getId() == null) continue;
                if (additionalSpaces == null) {
                    additionalSpaces = ServiceManagerRegistry.getService(FlightServiceManager.class).getAdditionalOrderSpaces((FlightReference)f).getList();
                }
                order.setStowingPosition((DeliverySpaceComplete)oldAdditionalPositions.get(order));
                StowingToolkit.selectNewSpace((AdditionalOrderComplete)order, (List<DeliverySpaceComplete>)additionalSpaces);
            }
            f.setAlaCarteOrders(f.getAlaCarteOrders());
            f.setSpmlOrders(f.getSpmlOrders());
            f.setAdditionalOrders(f.getAdditionalOrders());
            if (fromUpdater) {
                ServiceManagerRegistry.getService(FlightServiceManager.class).update(f, (ListWrapper<String>)new ListWrapper(warnings), false, false, false, false);
            }
        }
        Node<FlightComplete> currentNode = INodeCreator.getDefaultImpl().getNode4DTO(f, false, false);
        currentNode.removeExistingValues();
        currentNode.setValue(f, 0L);
        try {
            currentNode.updateNode();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return currentNode;
    }

    public static void mergeSeals(FlightSealsComplete newSeals, FlightSealsComplete oldSeals) {
        newSeals.setSeals(oldSeals.getSeals());
        for (EquipmentSealsComplete equipmentSealsComplete : newSeals.getEquipments()) {
            EquipmentSealsComplete oldEquipment = StowingToolkit.getEquipment(equipmentSealsComplete, oldSeals);
            if (oldEquipment == null) continue;
            for (Map.Entry entry : oldEquipment.getSeals().entrySet()) {
                Iterator iterator = ((List)entry.getValue()).iterator();
                while (iterator.hasNext()) {
                    SealComplete sealComplete;
                    SealComplete oldSeal = sealComplete = (SealComplete)iterator.next();
                    SealComplete newSeal = new SealComplete();
                    newSeal.setClientOId(Long.valueOf(ADTO.getNextId()));
                    newSeal.setColor(oldSeal.getColor());
                    newSeal.setIdentifier(oldSeal.getIdentifier());
                    newSeal.setPredefinedNumber(oldSeal.getPredefinedNumber());
                    newSeal.setSealCheck(oldSeal.getSealCheck());
                    newSeal.setSealModificationTime(oldSeal.getSealModificationTime());
                    newSeal.setSealModificationUser(oldSeal.getSealModificationUser());
                    newSeal.setSealNumber(oldSeal.getSealNumber());
                    newSeal.setSequenceNumber(oldSeal.getSequenceNumber());
                    newSeal.setType(oldSeal.getType());
                    ArrayList<SealComplete> list = (ArrayList<SealComplete>)equipmentSealsComplete.getSeals().get(entry.getKey());
                    if (list == null) {
                        list = new ArrayList<SealComplete>();
                        equipmentSealsComplete.getSeals().put(entry.getKey(), list);
                    }
                    list.add(newSeal);
                }
            }
        }
    }

    private static SealComplete getSeal(SealComplete sealComplete, SealTypeE key, EquipmentSealsComplete oldEquipment) {
        for (Map.Entry entry : oldEquipment.getSeals().entrySet()) {
            if (!((SealTypeE)entry.getKey()).equals((Object)key)) continue;
            for (SealComplete sealComplete2 : (List)entry.getValue()) {
                if (!sealComplete2.getIdentifier().equals(sealComplete.getIdentifier()) || !sealComplete2.getSequenceNumber().equals(sealComplete.getSequenceNumber())) continue;
                return sealComplete2;
            }
        }
        return null;
    }

    private static EquipmentSealsComplete getEquipment(EquipmentSealsComplete equipmentSealsComplete, FlightSealsComplete oldSeals) {
        for (EquipmentSealsComplete eq : oldSeals.getEquipments()) {
            if (!eq.getEquipment().getPositionCode().equals(equipmentSealsComplete.getEquipment().getPositionCode()) || eq.getEquipment().getEquipmentSetType() != equipmentSealsComplete.getEquipment().getEquipmentSetType()) continue;
            return eq;
        }
        return null;
    }

    private static void selectNewSpace(SpecialMealOrderComplete spml, List<DeliverySpaceComplete> spmlSpaces) {
        String name;
        String positionName = spml.getStowingPosition() != null ? spml.getStowingPosition().getContainingEquipment().getPositionCode() : null;
        String string = name = spml.getStowingPosition() != null ? spml.getStowingPosition().getSpaceName() : "";
        if (positionName != null && name != null) {
            for (DeliverySpaceComplete deliverySpaceComplete : spmlSpaces) {
                if (deliverySpaceComplete.getContainingEquipment() == null || !positionName.equals(deliverySpaceComplete.getContainingEquipment().getPositionCode()) || !name.equals(deliverySpaceComplete.getSpaceName())) continue;
                spml.setStowingPosition(deliverySpaceComplete);
                return;
            }
        }
        if (!spmlSpaces.isEmpty()) {
            spml.setStowingPosition(spmlSpaces.get(0));
        }
    }

    private static void selectNewSpace(AdditionalOrderComplete spml, List<DeliverySpaceComplete> spmlSpaces) {
        String name;
        String positionName = spml.getStowingPosition() != null ? spml.getStowingPosition().getContainingEquipmentCode() : null;
        String string = name = spml.getStowingPosition() != null ? spml.getStowingPosition().getSpaceName() : "";
        if (name != null && positionName != null) {
            for (DeliverySpaceComplete deliverySpaceComplete : spmlSpaces) {
                if (deliverySpaceComplete.getContainingEquipment() == null || !positionName.equals(deliverySpaceComplete.getContainingEquipmentCode()) || !name.equals(deliverySpaceComplete.getSpaceName())) continue;
                spml.setStowingPosition(deliverySpaceComplete);
                return;
            }
        }
        if (!spmlSpaces.isEmpty()) {
            spml.setStowingPosition(spmlSpaces.get(0));
        }
    }

    private static FlightComplete checkCabinClassConsistence(FlightComplete oldFlight, StowingListLight l, List<String> warnings, boolean fromUpdater, List<ScreenValidationObject> ccWarnings, StowingListTemplateComplete fsStw) throws ClientServerCallException {
        StowingListTemplateVariantLight variantLight = (StowingListTemplateVariantLight)ServiceManagerRegistry.getService(StowingListServiceManager.class).resolveVariant((StowingListTemplateReference)fsStw, new TimestampWrapper(oldFlight.getStd())).getValue();
        if (variantLight == null) {
            return oldFlight;
        }
        ArrayList<CabinClassComplete> cabinClasses2Fix = new ArrayList<CabinClassComplete>();
        HashSet<CabinClassComplete> usedClasses = new HashSet<CabinClassComplete>();
        for (SeatConfigurationComplete scc : variantLight.getSeatConfigurations()) {
            usedClasses.add(scc.getCabinClass());
        }
        for (SeatConfigurationComplete scc : l.getSeatConfigurations()) {
            if (usedClasses.contains(scc.getCabinClass())) continue;
            cabinClasses2Fix.add(scc.getCabinClass());
        }
        if (!cabinClasses2Fix.isEmpty()) {
            CabinClassComplete s2c;
            for (SpecialMealOrderComplete smoc : oldFlight.getSpmlOrders()) {
                if (!cabinClasses2Fix.contains(smoc.getCabinClass())) continue;
                s2c = null;
                for (CabinClassComplete u : usedClasses) {
                    if (!u.getCrewClass().equals(smoc.getCabinClass().getCrewClass())) continue;
                    s2c = u;
                }
                if (s2c == null && !usedClasses.isEmpty()) {
                    s2c = (CabinClassComplete)usedClasses.iterator().next();
                }
                smoc.setCabinClass(s2c);
            }
            for (AdditionalOrderComplete aoc : oldFlight.getAdditionalOrders()) {
                if (!cabinClasses2Fix.contains(aoc.getCabinClass())) continue;
                s2c = null;
                for (CabinClassComplete u : usedClasses) {
                    if (!u.getCrewClass().equals(aoc.getCabinClass().getCrewClass())) continue;
                    s2c = u;
                }
                if (s2c == null && !usedClasses.isEmpty()) {
                    s2c = (CabinClassComplete)usedClasses.iterator().next();
                }
                aoc.setCabinClass(s2c);
            }
            for (AlaCarteMealOrderComplete alaco : oldFlight.getAlaCarteOrders()) {
                if (!cabinClasses2Fix.contains(alaco.getCabinClass())) continue;
                s2c = null;
                for (CabinClassComplete u : usedClasses) {
                    if (!u.getCrewClass().equals(alaco.getCabinClass().getCrewClass())) continue;
                    s2c = u;
                }
                if (s2c == null && !usedClasses.isEmpty()) {
                    s2c = (CabinClassComplete)usedClasses.iterator().next();
                }
                alaco.setCabinClass(s2c);
            }
            for (CabinClassComplete cc : cabinClasses2Fix) {
                s2c = null;
                for (CabinClassComplete u : usedClasses) {
                    if (!u.getCrewClass().equals(cc.getCrewClass())) continue;
                    s2c = u;
                }
                if (s2c == null && !usedClasses.isEmpty()) {
                    s2c = (CabinClassComplete)usedClasses.iterator().next();
                }
                if (s2c == null) continue;
                ccWarnings.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, "Cabin Class " + cc.getCode() + " was removed in orign Stowing List. Cabin Class " + cc.getCode() + " is replaced by " + s2c.getCode() + ". Please review affected Special Meal & Additional Orders."));
            }
            oldFlight = (FlightComplete)ServiceManagerRegistry.getService(FlightServiceManager.class).update(oldFlight, (ListWrapper<String>)new ListWrapper(warnings), fromUpdater, false, false, false).getObject();
        }
        return oldFlight;
    }

    private static void mergeReturnsCount(ReturnsCountFlightComplete returnsCountDataOld, ReturnsCountFlightComplete returnsCountDataNEW, List<String> warnings, boolean reviseOnly, FlightComplete flight, boolean fromUpdater) throws ClientServerCallException {
        HashMap productIndex = new HashMap();
        returnsCountDataNEW.setDepartments(returnsCountDataOld.getDepartments());
        for (ReturnsCountEquipmentComplete returnsCountEquipmentComplete : returnsCountDataOld.getEquipments()) {
            HashMap<ProductComplete, ReturnsCountProductComplete> products = (HashMap<ProductComplete, ReturnsCountProductComplete>)productIndex.get(!returnsCountEquipmentComplete.getDepartments().isEmpty() ? returnsCountEquipmentComplete.getDepartments().get(0) : null);
            if (products == null) {
                products = new HashMap<ProductComplete, ReturnsCountProductComplete>();
                productIndex.put(!returnsCountEquipmentComplete.getDepartments().isEmpty() ? (CostCenterComplete)returnsCountEquipmentComplete.getDepartments().get(0) : null, products);
            }
            for (ReturnsCountDeliverySpaceComplete t : returnsCountEquipmentComplete.getDeliverySpaces()) {
                for (ReturnsCountProductComplete p : t.getProducts()) {
                    ReturnsCountProductComplete rcp = (ReturnsCountProductComplete)products.get(p.getProduct());
                    if (rcp == null) {
                        rcp = new ReturnsCountProductComplete();
                        rcp.setProduct(p.getProduct());
                        rcp.setConversionFactor(p.getConversionFactor());
                        rcp.setRevisedDeliveredAmount(Integer.valueOf(0));
                        rcp.setMachineSoldAmount(Integer.valueOf(0));
                        rcp.setMachineSalesAmount(Integer.valueOf(0));
                        rcp.setComplementarySalesAmount(Integer.valueOf(0));
                        rcp.setDiscountAmount(Integer.valueOf(0));
                        rcp.setCrewSalesAmount(Integer.valueOf(0));
                        rcp.setCountedAmount(Integer.valueOf(0));
                        rcp.setMissingAmount(Integer.valueOf(0));
                        rcp.setSoldAmount(Integer.valueOf(0));
                        rcp.setWasteAmount(Integer.valueOf(0));
                        products.put(p.getProduct(), rcp);
                    }
                    if (p.getUseRevisedDeliveredAmount().booleanValue()) {
                        rcp.setUseRevisedDeliveredAmount(Boolean.valueOf(true));
                        rcp.setRevisedDeliveredAmount(Integer.valueOf(rcp.getRevisedDeliveredAmount() + (p.getRevisedDeliveredAmount() - p.getCalculatedDeliveredAmount())));
                    }
                    rcp.setMachineSoldAmount(Integer.valueOf(rcp.getMachineSoldAmount() + p.getMachineSoldAmount()));
                    rcp.setMachineSalesAmount(Integer.valueOf(rcp.getMachineSalesAmount() + p.getMachineSalesAmount()));
                    rcp.setComplementarySalesAmount(Integer.valueOf(rcp.getComplementarySalesAmount() + p.getComplementarySalesAmount()));
                    rcp.setDiscountAmount(Integer.valueOf(rcp.getDiscountAmount() + p.getDiscountAmount()));
                    rcp.setCrewSalesAmount(Integer.valueOf(rcp.getCrewSalesAmount() + p.getCrewSalesAmount()));
                    rcp.setCountedAmount(Integer.valueOf(rcp.getCountedAmount() + p.getCountedAmount()));
                    rcp.setMissingAmount(Integer.valueOf(rcp.getMissingAmount() + p.getMissingAmount()));
                    rcp.setSoldAmount(Integer.valueOf(rcp.getSoldAmount() + p.getSoldAmount()));
                    rcp.setWasteAmount(Integer.valueOf(rcp.getWasteAmount() + p.getWasteAmount()));
                }
            }
        }
        for (ReturnsCountEquipmentComplete returnsCountEquipmentComplete : returnsCountDataNEW.getEquipments()) {
            Map oldProducts = (Map)productIndex.get(!returnsCountEquipmentComplete.getDepartments().isEmpty() ? returnsCountEquipmentComplete.getDepartments().get(0) : null);
            if (oldProducts == null) continue;
            for (ReturnsCountDeliverySpaceComplete t : returnsCountEquipmentComplete.getDeliverySpaces()) {
                for (ReturnsCountProductComplete p : t.getProducts()) {
                    int oload;
                    ReturnsCountProductComplete orc = (ReturnsCountProductComplete)oldProducts.get(p.getProduct());
                    if (orc == null) continue;
                    int sold = orc.getSoldAmount();
                    int waste = orc.getWasteAmount();
                    int missing = orc.getMissingAmount();
                    int counted = orc.getCountedAmount();
                    int machineSold = orc.getMachineSoldAmount();
                    int machineSales = orc.getMachineSalesAmount();
                    int complementarySales = orc.getComplementarySalesAmount();
                    int crewSales = orc.getCrewSalesAmount();
                    int discountSales = orc.getDiscountAmount();
                    int load = oload = (p.getUseRevisedDeliveredAmount() != false ? p.getRevisedDeliveredAmount() : p.getCalculatedDeliveredAmount()).intValue();
                    int use = 0;
                    if (orc.getUseRevisedDeliveredAmount().booleanValue()) {
                        p.setUseRevisedDeliveredAmount(Boolean.valueOf(true));
                        if (load + orc.getRevisedDeliveredAmount() > 0) {
                            load += orc.getRevisedDeliveredAmount().intValue();
                        } else {
                            int dif = load + orc.getRevisedDeliveredAmount();
                            load = 0;
                            orc.setRevisedDeliveredAmount(Integer.valueOf(dif *= -1));
                        }
                        p.setRevisedDeliveredAmount(Integer.valueOf(load));
                        oload = load;
                    }
                    use = Math.min(load, sold);
                    p.setSoldAmount(Integer.valueOf(use));
                    load -= use;
                    sold -= use;
                    use = Math.min(load, waste);
                    p.setWasteAmount(Integer.valueOf(use));
                    load -= use;
                    waste -= use;
                    use = Math.min(load, missing);
                    p.setMissingAmount(Integer.valueOf(use));
                    load -= use;
                    missing -= use;
                    load = oload;
                    use = Math.min(machineSold, load *= p.getConversionFactor().intValue());
                    p.setMachineSoldAmount(Integer.valueOf(use));
                    machineSold -= use;
                    use = Math.min(machineSales, load);
                    p.setMachineSalesAmount(Integer.valueOf(use));
                    machineSales -= use;
                    load = use;
                    use = Math.min(load, complementarySales);
                    p.setComplementarySalesAmount(Integer.valueOf(use));
                    complementarySales -= use;
                    load -= use;
                    use = Math.min(load, discountSales);
                    p.setDiscountAmount(Integer.valueOf(use));
                    discountSales -= use;
                    load -= use;
                    use = Math.min(load, crewSales);
                    p.setCrewSalesAmount(Integer.valueOf(use));
                    crewSales -= use;
                    load -= use;
                    counted = oload - (p.getWasteAmount() + p.getSoldAmount() + p.getMissingAmount());
                    p.setCountedAmount(Integer.valueOf(counted));
                    orc.setSoldAmount(Integer.valueOf(sold));
                    orc.setMissingAmount(Integer.valueOf(missing));
                    orc.setWasteAmount(Integer.valueOf(waste));
                    orc.setMachineSoldAmount(Integer.valueOf(machineSold));
                    orc.setMachineSalesAmount(Integer.valueOf(machineSales));
                    orc.setComplementarySalesAmount(Integer.valueOf(complementarySales));
                    orc.setDiscountAmount(Integer.valueOf(discountSales));
                    orc.setCrewSalesAmount(Integer.valueOf(crewSales));
                }
            }
        }
        if (productIndex.isEmpty()) {
            for (Map.Entry entry : productIndex.entrySet()) {
                for (Map.Entry prods : ((Map)entry.getValue()).entrySet()) {
                    boolean invalid = false;
                    if (((ReturnsCountProductComplete)prods.getValue()).getSoldAmount() != 0) {
                        invalid = true;
                    }
                    if (((ReturnsCountProductComplete)prods.getValue()).getWasteAmount() != 0) {
                        invalid = true;
                    }
                    if (((ReturnsCountProductComplete)prods.getValue()).getMissingAmount() != 0) {
                        invalid = true;
                    }
                    if (((ReturnsCountProductComplete)prods.getValue()).getMachineSalesAmount() != 0) {
                        invalid = true;
                    }
                    if (((ReturnsCountProductComplete)prods.getValue()).getComplementarySalesAmount() != 0) {
                        invalid = true;
                    }
                    if (((ReturnsCountProductComplete)prods.getValue()).getDiscountAmount() != 0) {
                        invalid = true;
                    }
                    if (((ReturnsCountProductComplete)prods.getValue()).getCrewSalesAmount() != 0) {
                        invalid = true;
                    }
                    if (!invalid) continue;
                    warnings.add("Unable to merge Product " + ((ProductComplete)prods.getKey()).getNumber() + " - " + ((ProductComplete)prods.getKey()).getCurrentVariant().getName() + " to new Stowing List");
                }
            }
        }
        StowingToolkit.ensureSeals(returnsCountDataNEW);
        StowingToolkit.revalidateReturnsCount(returnsCountDataNEW);
        ServiceManagerRegistry.getService(FlightServiceManager.class).updateCountAndManualSalesItem(returnsCountDataNEW, fromUpdater);
    }

    public static void ensureSeals(ReturnsCountFlightComplete flight) {
    }

    public static void ensureSealState(FlightLight flight, FlightSealsComplete fsc) {
        if (Boolean.TRUE.equals(flight.getCustomer().getPredefineSealsForEquipments())) {
            if (!fsc.getSeals().isEmpty()) {
                fsc.getSeals().clear();
            }
        } else {
            for (EquipmentSealsComplete seal : fsc.getEquipments()) {
                if (seal.getSeals().isEmpty()) continue;
                for (Map.Entry sv : seal.getSeals().entrySet()) {
                    for (SealComplete sealComplete : (List)sv.getValue()) {
                    }
                }
            }
        }
    }

    public static void initClientIds(StowingListLight ns) {
        if (ns != null && ns.getId() == null && ns.getClientOId() == null) {
            ns.setClientOId(Long.valueOf(ADTO.getNextId()));
            for (SeatConfigurationComplete sc : ns.getSeatConfigurations()) {
                if (sc.getId() != null || ns.getClientOId() != null) continue;
                sc.setClientOId(Long.valueOf(ADTO.getNextId()));
            }
        }
    }
}

