/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import ch.icit.pegasus.server.core.services.system.LoggingService;
import ch.icit.pegasus.server.core.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailToolkit {
    static Logger log = LoggerFactory.getLogger(MailToolkit.class);

    public static byte[] getBytesFromFile(File file) throws IOException {
        byte[] bytes;
        try (FileInputStream is = new FileInputStream(file);){
            int offset;
            long length = file.length();
            if (length > Integer.MAX_VALUE) {
                log.error("File is too large to process");
                byte[] byArray = null;
                return byArray;
            }
            bytes = new byte[(int)length];
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
        }
        return bytes;
    }

    public static void sendWAGOrderMail(String subject, String msg, File attachment, List<String> targetList) throws IOException, ServiceException {
        String senderMail;
        LoggingService ls;
        byte[] screenshot = MailToolkit.getBytesFromFile(attachment);
        try {
            ls = EjbContextFactory.getInstance().getService(LoggingService.class);
        }
        catch (ServiceException e) {
            throw new IOException(e.getMessage(), e);
        }
        String string = senderMail = targetList.isEmpty() ? null : targetList.get(0);
        if (StringUtil.isBlank((String)senderMail)) {
            senderMail = "support@icit.ch";
        }
        ls.sendWAGOrderMail(senderMail, new ListWrapper(targetList), subject, msg, screenshot);
    }

    public static void sendPurchaseOrderMail(String subject, String msg, File attachment, UserComplete currentUser, List<String> targetList) throws IOException, ServiceException {
        LoggingService ls;
        byte[] screenshot = MailToolkit.getBytesFromFile(attachment);
        try {
            ls = EjbContextFactory.getInstance().getService(LoggingService.class);
        }
        catch (ServiceException e) {
            throw new IOException(e.getMessage(), e);
        }
        String senderMail = currentUser.getContact().getEmail();
        if (StringUtil.isBlank((String)senderMail)) {
            senderMail = "support@icit.ch";
        }
        ls.sendPurchaseOrderMail(senderMail, new ListWrapper(targetList), subject, msg, screenshot);
    }
}

