/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CATITFilePathConfig {
    private static String defaultFolder = ".catit";
    static Logger logger = LoggerFactory.getLogger(CATITFilePathConfig.class);

    public static File getTrustStore(String customer) {
        String path = CATITFilePathConfig.getConfigFolder().getAbsolutePath() + File.separator + customer + File.separator + "cert" + File.separator + "truststore.jks";
        return new File(path);
    }

    public static File getKeyStore(String customer) {
        String path = CATITFilePathConfig.getConfigFolder().getAbsolutePath() + File.separator + customer + File.separator + "cert" + File.separator + "keystore.jks";
        return new File(path);
    }

    public static File getAppFolder() {
        File userHome = SystemUtils.getUserHome();
        File tempFile = new File(userHome.getAbsolutePath() + File.separator + defaultFolder + File.separator);
        if (!tempFile.exists()) {
            tempFile.mkdirs();
            try {
                tempFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return tempFile;
    }

    public static File getConfigFolder() {
        File tempFile = new File(CATITFilePathConfig.getAppFolder().getAbsolutePath() + File.separator + "config" + File.separator);
        if (!tempFile.exists()) {
            tempFile.mkdirs();
            try {
                tempFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return tempFile;
    }

    public static File getCustomerSpecificTempDir(String customer) {
        String tempDir = CATITFilePathConfig.getTempDir().getAbsolutePath() + File.separator + "catit-client-" + customer + File.separator;
        File tempFile = new File(tempDir);
        if (!tempFile.exists()) {
            tempFile.mkdirs();
        }
        return tempFile;
    }

    public static File getTempDir() {
        File tempFile = new File(CATITFilePathConfig.getAppFolder().getAbsolutePath() + File.separator + "libs" + File.separator);
        if (!tempFile.exists()) {
            tempFile.mkdirs();
            try {
                tempFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return tempFile;
    }
}

