/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.system;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.InfoBox;
import ch.icit.pegasus.client.util.exception.ClientActionOnServerException;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.masterdata.UserReference;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.DataAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.DataFieldAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.FavoriteModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.LocationAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.SubModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.ModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.system.LocationComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.SetWrapper;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import ch.icit.pegasus.server.core.services.system.AdministrationService;
import ch.icit.pegasus.server.core.services.system.SessionService;
import ch.icit.pegasus.server.core.services.system.SystemSettingsService;
import ch.icit.pegasus.server.core.services.system.UserService;
import ch.icit.pegasus.server.core.util.Tuple;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserServiceManagerImpl
implements UserServiceManager {
    Logger log = LoggerFactory.getLogger(UserServiceManagerImpl.class);
    private UserComplete currentUser;
    private LocationComplete currentLocation;
    private boolean webservice = true;

    @Override
    public void applyUser(UserLight currentUser, UserReference copyFromUser) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(UserService.class).applyUser(currentUser, copyFromUser);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, this.getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public Node<List<ModuleDefinitionComplete>> getAllRegisteredModulesCached() throws ClientServerCallException {
        Node<List<Object>> n = NodeToolkit.getAffixList(ModuleDefinitionComplete.class);
        if (n == null) {
            List l = this.getAllRegisteredModules().getList();
            n = INodeCreator.getDefaultImpl().createNodes(l, false);
            n.setName(ServiceManagerRegistry.getService(DefaultServiceManager.class).getAffixNameForClass(ModuleDefinitionComplete.class));
            NodeToolkit.addAffix(n);
        }
        return n;
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createAccessReport(ListWrapper<UserReference> userReferences) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(UserService.class).createAccessReport(userReferences);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, this.getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<UserComplete> updateLoginVersion(UserReference user, String latestVersion) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(UserService.class).updateLoginVersion(new UserReference(user.getId()), latestVersion);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, this.getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<UserComplete> getLoggedInUser() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(UserService.class).getLoggedInUser();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, this.getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<UserComplete> create(UserComplete user, String password) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(UserService.class).create(user, password);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, this.getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public <U extends UserReference> OptionalWrapper<U> update(U user) throws ClientServerCallException {
        try {
            OptionalWrapper d = EjbContextFactory.getInstance().getService(UserService.class).update(user);
            if (((UserReference)d.getValue()).equals((Object)this.getCurrentUser())) {
                this.getEligibleLocations();
            }
            return d;
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, this.getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public boolean isUsernameAssigned(String username) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(UserService.class).isUsernameAssigned(username);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, this.getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<ModuleDefinitionComplete> getAllRegisteredModules() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(UserService.class).getAllRegisteredModules();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, this.getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    public ListWrapper<SubModuleDefinitionComplete> getAllRegisteredSubModules() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(UserService.class).getAllRegisteredSubModules();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, this.getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ModuleDefinitionComplete> registerModule(ModuleDefinitionComplete m) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(UserService.class).registerModule(m);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, this.getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ModuleDefinitionComplete> updateModule(ModuleDefinitionComplete m) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(UserService.class).updateModule(m);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, this.getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void changePassword(UserReference user, String currentUserPassword, String newPassword) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(UserService.class).changePassword(user, currentUserPassword, newPassword);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, this.getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public boolean changePasswordWithReturn(UserReference user, String currentUserPassword, String newPassword) {
        try {
            this.changePassword(user, currentUserPassword, newPassword);
            return true;
        }
        catch (ClientServerCallException e) {
            ErrorSupport.fireException(Thread.currentThread(), (Exception)((Object)e), e.getMessage(), true, true, this.getCurrentUser());
            return false;
        }
    }

    @Override
    public OptionalWrapper<UserComplete> getUser(UserReference user) throws ClientServerCallException {
        try {
            OptionalWrapper usr = EjbContextFactory.getInstance().getService(UserService.class).getUser(user);
            this.mergeUserRightsWithVirtual((UserComplete)usr.getValue());
            return usr;
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, this.getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<UserLight> getUserLight(UserReference user) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(UserService.class).getUserLight(user);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, this.getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<UserReference> delete(UserReference dto) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(UserService.class).delete(dto);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, this.getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public void switchLocation(LocationComplete location) throws ClientServerCallException {
        this.setCurrentLocation(location);
        try {
            EjbContextFactory.getInstance().getService(UserService.class).switchLocation(location);
            ServiceManagerRegistry.getService(SystemSettingsServiceManager.class).getSettingsUnCached();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, this.getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<LocationAccessRightComplete> getUserRights(UserReference user, LocationComplete location, boolean addIndirectRights) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(UserService.class).getUserRights(user, location, addIndirectRights);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, this.getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<LocationAccessRightComplete> saveUserRights(LocationAccessRightComplete larc) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(UserService.class).saveUserRights(larc);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, this.getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public ListWrapper<LocationComplete> getEligibleLocations() throws ClientServerCallException {
        try {
            List r = EjbContextFactory.getInstance().getService(UserService.class).getEligibleLocations().getList();
            NodeToolkit.removeAffixNamed("userLocations");
            Node n = INodeCreator.getDefaultImpl().createNodes(r, true);
            n.setName("userLocations");
            NodeToolkit.addAffix(n);
            return new ListWrapper(r);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, this.getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public Node<List<LocationComplete>> getAllLocations() {
        Node<List<Object>> affix = NodeToolkit.getAffixList(LocationComplete.class);
        if (affix == null) {
            try {
                List r = EjbContextFactory.getInstance().getService(SystemSettingsService.class).getAllLocations().getList();
                affix = INodeCreator.getDefaultImpl().createNodes(r, false);
                affix.setName(ServiceManagerRegistry.getService(DefaultServiceManager.class).getAffixNameForClass(LocationComplete.class));
                NodeToolkit.addAffix(affix);
            }
            catch (Exception e) {
                ErrorSupport.fireException(Thread.currentThread(), e, "Unable to get all Locations: " + e.getMessage(), true, true, this.getCurrentUser());
            }
        }
        return affix;
    }

    @Override
    public void login(String sessionID) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(UserService.class).login(sessionID);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, this.getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public void logout() throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(UserService.class).logout();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, this.getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    public void keepSessionAlive() throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(UserService.class).keepSessionAlive();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, this.getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<LocationComplete> getCurrentLocation() {
        return new OptionalWrapper((ADTO)this.currentLocation);
    }

    @Override
    public void setCurrentLocation(LocationComplete currentLocation) {
        this.currentLocation = currentLocation;
    }

    @Override
    public InfoBox authenticateUser(String plainName, String plainPwd) throws ClientServerCallException {
        InfoBox infoBox = new InfoBox();
        String sessionID = null;
        EjbContextFactory instance = EjbContextFactory.getInstance();
        try {
            instance.initEjbContext(plainName, plainPwd);
            this.log.info("Login: Trying to get Session ID");
            SessionService service = instance.getService(SessionService.class);
            sessionID = service.requestSessionID();
        }
        catch (Exception e) {
            this.log.error("Login: Not able to get Session ID ", (Throwable)e);
            infoBox.setStatus(-1);
            infoBox.setErrorCode("NOT_OK");
            infoBox.setErrorText("Not able to get Session ID " + e.getMessage());
            ErrorSupport.fireExceptionStacktraceOnly(Thread.currentThread(), e, "Failed to request a session ID from server!");
            return null;
        }
        instance.closeInitialContext();
        try {
            this.log.info("Login: SessionID **********");
            instance.initEjbContext(plainName + "#" + sessionID, plainPwd);
        }
        catch (Exception e) {
            infoBox.setStatus(-1);
            infoBox.setErrorCode("NOT_OK");
            infoBox.setErrorText(e.getMessage());
            this.log.error("Login: Initializing Session failed", (Throwable)e);
            ErrorSupport.fireExceptionStacktraceOnly(Thread.currentThread(), e, "Error occurred while try to login (Login Data wrong).");
        }
        boolean loggedIn = false;
        if (infoBox.getStatus() == 0) {
            infoBox = this.loginUser(infoBox, sessionID);
            loggedIn = true;
        }
        if (infoBox.getStatus() == 0) {
            infoBox = this.initHostService(infoBox);
        }
        if (infoBox.getStatus() == 0) {
            infoBox = this.initAdminService(infoBox);
        }
        if (loggedIn && infoBox.getStatus() != 0) {
            this.logout();
        }
        if (infoBox.getStatus() == 0) {
            UserComplete usr = this.getCurrentUser();
            this.mergeUserRightsWithVirtual(usr);
            this.setCurrentUser(usr);
            infoBox.setUser(this.getCurrentUser());
        }
        return infoBox;
    }

    private void mergeUserRightsWithVirtual(UserComplete usr) {
        try {
            Set userRights = EjbContextFactory.getInstance().getService(UserService.class).getVirtualModuleAccessRights(this.currentLocation, new UserReference(usr.getId())).getSet();
            userRights.addAll(usr.getModules());
            HashMap<ModuleDefinitionComplete, ModuleAccessRightComplete> rights = new HashMap<ModuleDefinitionComplete, ModuleAccessRightComplete>();
            for (ModuleAccessRightComplete a : userRights) {
                if (rights.containsKey(a.getModule())) {
                    ModuleAccessRightComplete old = (ModuleAccessRightComplete)rights.get(a.getModule());
                    this.mergeFields(old, a);
                    this.mergeSubModules(old, a);
                    this.mergeAccessRight(old, a);
                    continue;
                }
                rights.put(a.getModule(), a);
            }
            usr.setModules(new ArrayList(rights.values()));
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, "Error occurred while try to accumulate UserRights." + e.getMessage());
        }
    }

    private void mergeSubModules(ModuleAccessRightComplete old, ModuleAccessRightComplete a) {
        for (SubModuleAccessRightComplete right : a.getSubModules()) {
            boolean found = false;
            for (SubModuleAccessRightComplete or : old.getSubModules()) {
                if (!or.getModule().getInvokingName().equals(right.getModule().getInvokingName())) continue;
                found = true;
            }
            if (found) continue;
            old.getSubModules().add(right);
        }
    }

    private void mergeAccessRight(ModuleAccessRightComplete old, ModuleAccessRightComplete a) {
        for (DataAccessRightComplete right : a.getAccessRights()) {
            boolean found = false;
            for (DataAccessRightComplete or : old.getAccessRights()) {
                if (or.getDataAccessRight().getAccessRight() != right.getDataAccessRight().getAccessRight()) continue;
                found = true;
            }
            if (found) continue;
            old.getAccessRights().add(right);
        }
    }

    private void mergeFields(ModuleAccessRightComplete old, ModuleAccessRightComplete a) {
        for (DataFieldAccessRightComplete right : a.getFieldAccessRights()) {
            boolean found = false;
            for (DataFieldAccessRightComplete or : old.getFieldAccessRights()) {
                if (!or.getField().getName().equals(right.getField().getName()) || or.getAccessRight() != right.getAccessRight()) continue;
                found = true;
            }
            if (found) continue;
            old.getFieldAccessRights().add(right);
        }
    }

    private InfoBox initAdminService(InfoBox infoBox) {
        try {
            AdministrationService as = EjbContextFactory.getInstance().getService(AdministrationService.class);
            if (as != null) {
                as.initServer();
                UserService s = EjbContextFactory.getInstance().getService(UserService.class);
                UserComplete user = (UserComplete)s.getLoggedInUser().getValue();
                this.setCurrentUser(user);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            infoBox.setStatus(-1);
            infoBox.setErrorCode("ADMIN_ERROR");
            infoBox.setErrorText("Error occurred while try to login (Administration Service Exception).");
            ErrorSupport.fireException(Thread.currentThread(), e, "Error occurred while try to login. Administration Service Exception " + e.getMessage());
        }
        return infoBox;
    }

    private InfoBox initHostService(InfoBox infoBox) {
        return infoBox;
    }

    private InfoBox loginUser(InfoBox infoBox, String sessionID) {
        try {
            UserService s = EjbContextFactory.getInstance().getService(UserService.class);
            if (s != null) {
                s.login(sessionID);
                UserComplete user = (UserComplete)s.getLoggedInUser().getValue();
                this.setCurrentUser(user);
                if ("monitor".equals(user.getUserName())) {
                    infoBox.setStatus(-1);
                    infoBox.setErrorCode("NOT_OK");
                    infoBox.setErrorText("Monitor");
                } else {
                    ServiceManagerRegistry.getService(MasterDataServiceManager.class).getAllSuperArticleCategoriesCached();
                    ServiceManagerRegistry.getService(MasterDataServiceManager.class).getAllSuperProductCategoriesCached();
                    ServiceManagerRegistry.getService(MasterDataServiceManager.class).getAllSuperRecipeCategoriesCached();
                    long p = ServiceManagerRegistry.getService(SystemSettingsServiceManager.class).getSettingsCached().getValue().getHeartBeatPeriod();
                    ServiceManagerRegistry.getService(DefaultServiceManager.class).startHeartBeat(p);
                    this.getEligibleLocations();
                    ServiceManagerRegistry.getService(UserServiceManager.class).setCurrentLocation((LocationComplete)s.getCurrentLocation().getValue());
                }
            }
        }
        catch (Exception e) {
            infoBox.setStatus(-1);
            infoBox.setErrorCode("NOT_OK");
            infoBox.setErrorText("Error occurred while try to login (Login Data wrong).");
            ErrorSupport.fireException(Thread.currentThread(), e, "Error occurred while try to login (Login Data wrong)." + e.getMessage());
        }
        return infoBox;
    }

    @Override
    public UserComplete getCurrentUser() {
        return this.currentUser;
    }

    @Override
    public void setCurrentUser(UserComplete newUser) {
        this.currentUser = newUser;
    }

    public ListWrapper<FavoriteModuleAccessRightComplete> updateFavorites(ListWrapper<FavoriteModuleAccessRightComplete> favorites) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(UserService.class).updateFavorites(favorites);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, this.getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public void updateFavorite(ModuleAccessRightComplete accessRight, int index) throws ClientServerCallException {
        FavoriteModuleAccessRightComplete delete = null;
        for (FavoriteModuleAccessRightComplete fmar : this.getCurrentUser().getFavorites()) {
            if (fmar.getIndex() != index) continue;
            delete = fmar;
        }
        if (delete != null) {
            this.getCurrentUser().getFavorites().remove(delete);
        }
        FavoriteModuleAccessRightComplete fmar = new FavoriteModuleAccessRightComplete(accessRight, Integer.valueOf(index));
        this.getCurrentUser().getFavorites().add(fmar);
        this.updateFavorites((ListWrapper<FavoriteModuleAccessRightComplete>)new ListWrapper(this.getCurrentUser().getFavorites()));
    }

    @Override
    public void removeFavorite(ModuleAccessRightComplete accessright, int index) throws ClientServerCallException {
        FavoriteModuleAccessRightComplete delete = null;
        for (FavoriteModuleAccessRightComplete fmar : this.getCurrentUser().getFavorites()) {
            if (fmar.getIndex() != index) continue;
            delete = fmar;
        }
        if (delete != null) {
            this.getCurrentUser().getFavorites().remove(delete);
        }
        this.updateFavorites((ListWrapper<FavoriteModuleAccessRightComplete>)new ListWrapper(this.getCurrentUser().getFavorites()));
    }

    public SetWrapper<ModuleAccessRightComplete> getVirtualModuleAccessRights(LocationComplete location, UserReference user) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(UserService.class).getVirtualModuleAccessRights(location, user);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, this.getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    public ListWrapper<String> getAllUserEmailAddress() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(UserService.class).getAllUserEmailAddress();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, this.getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    private ArrayList<Tuple<String, String>> getAutoLoginTuples() {
        ArrayList<Tuple<String, String>> tuples = new ArrayList<Tuple<String, String>>();
        String currentPath = System.getProperty("user.home") + File.separator + ".catit" + File.separator + "autologin2.catit";
        File f = new File(currentPath);
        if (f.exists()) {
            try {
                JSONParser parser = new JSONParser();
                Object obj = null;
                obj = parser.parse((Reader)new FileReader(f));
                JSONObject jsonObject = (JSONObject)obj;
                JSONArray results = (JSONArray)jsonObject.get((Object)"customers");
                for (JSONObject result : results) {
                    if (!result.containsKey((Object)"host") || !result.get((Object)"host").equals(EjbContextFactory.getInstance().getOrbConfig().getHost())) continue;
                    tuples.add((Tuple<String, String>)new Tuple((Object)((String)result.get((Object)"user")), (Object)((String)result.get((Object)"password"))));
                }
                for (JSONObject result : results) {
                    if (!result.containsKey((Object)"name") || !result.get((Object)"name").equals(EjbContextFactory.getInstance().getOrbConfig().getHost())) continue;
                    tuples.add((Tuple<String, String>)new Tuple((Object)((String)result.get((Object)"user")), (Object)((String)result.get((Object)"password"))));
                }
            }
            catch (IOException | ParseException e) {
                e.printStackTrace();
                return tuples;
            }
        }
        return tuples;
    }

    @Override
    public UserComplete authenticateUserByAutoLogin() throws ClientServerCallException {
        Tuple<String, String> tuple;
        InfoBox infoBox = null;
        ArrayList<Tuple<String, String>> autoLoginTuples = this.getAutoLoginTuples();
        Iterator<Tuple<String, String>> iterator = autoLoginTuples.iterator();
        while (iterator.hasNext() && ((infoBox = this.authenticateUser((String)(tuple = iterator.next()).getS(), (String)tuple.getT())) == null || infoBox.getUser() == null)) {
        }
        return infoBox != null ? infoBox.getUser() : null;
    }

    @Override
    public void resetPassword(UserLight username) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(UserService.class).resetPassword(username);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, this.getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<UserComplete> copyUser(UserReference originalUser, String userName, String password) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(UserService.class).copyUser(originalUser, userName, password);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, this.getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    public OptionalWrapper<UserComplete> getUserByName(String username) throws ServiceException {
        try {
            return EjbContextFactory.getInstance().getService(UserService.class).getUserByName(username);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, this.getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public void setCounterIncorrectLogins(String user) {
        try {
            EjbContextFactory.getInstance().getService(UserService.class).setCounterIncorrectLogins(user);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, this.getCurrentUser());
        }
    }
}

