/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.report;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.RecipeReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.production_new.store.recipe.RecipeStockCheckinGroupReference;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeReference;
import ch.icit.pegasus.server.core.dtos.report.RecipeFactsheetConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.DateWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.MapWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.services.report.RecipeReportService;

public class RecipeReportServiceManagerImpl
implements RecipeReportServiceManager {
    @Override
    public OptionalWrapper<PegasusFileComplete> createStoreEANReport(ListWrapper<StoreReference> stores) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(RecipeReportService.class).createStoreEANReport(stores);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createStoreTransactionReport(ListWrapper<StoreReference> stores, PeriodComplete selectedPeriod) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(RecipeReportService.class).createStoreTransactionReport(stores, selectedPeriod);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createTransactionReport(ListWrapper<RecipeReference> recipes, PeriodComplete period) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(RecipeReportService.class).createTransactionReport(recipes, period);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getRecipeCheckinEANSheet(ListWrapper<RecipeStockCheckinGroupReference> recipes, RecipeFactsheetConfigurationComplete config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(RecipeReportService.class).getRecipeCheckinEANSheet(recipes, config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getRecipeEANSheet(ListWrapper<RecipeReference> recipes, RecipeFactsheetConfigurationComplete config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(RecipeReportService.class).getRecipeEANSheet(recipes, config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createRecipeConsumptionReport(ListWrapper<RecipeComplete> recipeCompleteListWrapper, PeriodComplete period) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(RecipeReportService.class).createRecipeConsumptionReport(recipeCompleteListWrapper, period);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getRecipeContentReport(ListWrapper<RecipeComplete> recipes, TimestampWrapper validity) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(RecipeReportService.class).getRecipeContentReport(recipes, validity);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getValidateYieldsReport(ListWrapper<RecipeComplete> s, ListWrapper<BasicArticleReference> articles) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(RecipeReportService.class).getValidateYieldsReport(s, articles);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getRecipeCards(ListWrapper<RecipeReference> recipes, TimestampWrapper validity) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(RecipeReportService.class).getRecipeCards(recipes, validity);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public MapWrapper<Long, String> getSubRecipes(RecipeReference recipe, TimestampWrapper validityDate) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(RecipeReportService.class).getSubRecipes(recipe, validityDate);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getRecipeCard(RecipeFactsheetConfigurationComplete config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(RecipeReportService.class).getRecipeCard(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createArticleByRecipeReport(ListWrapper<RecipeComplete> catalogs, DateWrapper dueDate) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(RecipeReportService.class).createArticleByRecipeReport(catalogs, dueDate);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }
}

