/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.articlegroup;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.interfaces.articlegroup.ArticleGroupServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientActionOnServerException;
import ch.icit.pegasus.client.util.exception.ClientExceptionType;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.ordering.articlegroup.ArticleGroupComplete;
import ch.icit.pegasus.server.core.dtos.ordering.articlegroup.ArticleGroupReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.services.articlegroup.ArticleGroupService;

public class ArticleGroupServiceManagerImpl
implements ArticleGroupServiceManager {
    @Override
    public OptionalWrapper<ArticleGroupComplete> createArticleGroup(ArticleGroupComplete articleGroup) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(ArticleGroupService.class).createArticleGroup(articleGroup);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage());
            throw new ClientActionOnServerException(e, ClientExceptionType.CREATE);
        }
    }

    @Override
    public OptionalWrapper<ArticleGroupComplete> updateArticleGroup(ArticleGroupComplete articleGroup) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(ArticleGroupService.class).updateArticleGroup(articleGroup);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage());
            throw new ClientActionOnServerException(e, ClientExceptionType.UPDATE);
        }
    }

    @Override
    public OptionalWrapper<ArticleGroupComplete> getArticleGroup(ArticleGroupReference articleGroup) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(ArticleGroupService.class).getArticleGroup(articleGroup);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage());
            throw new ClientActionOnServerException(e, ClientExceptionType.LOAD);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createDetailsExport(ListWrapper<ArticleGroupReference> items) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(ArticleGroupService.class).createDetailsExport(items);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage());
            throw new ClientActionOnServerException(e, ClientExceptionType.LOAD);
        }
    }
}

