/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.converter;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionMovementInformationComplete;

public class InternalConsumptionItemNameConverter
implements Converter<InternalConsumptionMovementInformationComplete, String> {
    @Override
    public String convert(InternalConsumptionMovementInformationComplete o, Node<InternalConsumptionMovementInformationComplete> currentNode, Object ... param) {
        if (o == null) {
            return NULL_RETURN;
        }
        InternalConsumptionMovementInformationComplete unit = o;
        if (unit.getType() == null) {
            return NULL_RETURN;
        }
        switch (unit.getType()) {
            case ARTICLE: {
                return unit.getArticle() != null ? unit.getArticle().getNumber() + " - " + unit.getArticle().getName() : "no article";
            }
            case PRODUCT: {
                return unit.getProduct() != null ? unit.getProduct().getNumber() + " - " + unit.getProduct().getCurrentVariant().getName() : "no product";
            }
            case PRODUCT_COMPONENT: {
                return unit.getProduct() != null ? unit.getProduct().getNumber() + " - " + unit.getProduct().getCurrentVariant().getName() + " - " + unit.getGroupInfo() : "no group";
            }
            case RECIPE: {
                return unit.getRecipe() != null ? unit.getRecipe().getNumber() + " - " + unit.getRecipe().getCurrentVariant().getName() : "no recipe";
            }
            case HOURLY_WORK: {
                return unit.getServiceProduct() != null ? unit.getServiceProduct().getNumber() + " - " + unit.getServiceProduct().getCurrentVariant().getName() : "no service product";
            }
        }
        return NULL_RETURN;
    }

    @Override
    public Class<? extends InternalConsumptionMovementInformationComplete> getParameterClass() {
        return InternalConsumptionMovementInformationComplete.class;
    }
}

