/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.converter;

import ch.icit.pegasus.client.converter.InternationalizedConverter;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.utils.DateUtil;
import ch.icit.pegasus.server.core.util.TimeUtil;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class DateTimeConverter
extends InternationalizedConverter {
    public DateTimeConverter() {
        this("{**$day}.{**$month}.{****$year} - {**$hour}:{**$minute}#DD.MM.YYYY-HH-MM$0123456789DMYH$0123456789");
    }

    public DateTimeConverter(String pattern) {
        super(pattern);
    }

    @Override
    public Object inverseConvert(Object o, Object userObj) {
        Time date = null;
        if (userObj instanceof Time) {
            date = (Time)userObj;
        } else if (userObj instanceof Date) {
            date = new Time(((Date)userObj).getTime());
        } else if (userObj instanceof Timestamp) {
            date = new Time(((Timestamp)userObj).getTime());
        }
        String dString = (String)o;
        if (dString == null || dString.trim().equals("")) {
            return null;
        }
        String day = this.getStringValueOfGroupNamed("day", dString);
        String month = this.getStringValueOfGroupNamed("month", dString);
        String year = this.getStringValueOfGroupNamed("year", dString);
        String hour = this.getStringValueOfGroupNamed("hour", dString);
        String minute = this.getStringValueOfGroupNamed("minute", dString);
        try {
            int aDay = Integer.valueOf(day);
            int aMonth = Integer.valueOf(month);
            int aYear = Integer.valueOf(year);
            int aHour = Integer.valueOf(hour);
            int aMinute = Integer.valueOf(minute);
            --aMonth;
            Calendar c = TimeUtil.createCalendar();
            if (date != null) {
                c.setTimeInMillis(date.getTime());
            }
            c.set(5, aDay);
            c.set(2, aMonth);
            c.set(1, aYear);
            c.set(11, aHour);
            c.set(12, aMinute);
            return DateUtil.getSQLDate((int)aYear, (int)aMonth, (int)aDay, (int)aHour, (int)aMinute, (int)0);
        }
        catch (Exception e) {
            return userObj;
        }
    }

    @Override
    public String convert(Object o, Node currentNode, Object ... param) {
        Time d = null;
        if (o instanceof Time) {
            d = (Time)o;
        } else if (o instanceof Date) {
            d = new Time(((Date)o).getTime());
        } else if (o instanceof Timestamp) {
            d = new Time(((Timestamp)o).getTime());
        }
        Calendar c = TimeUtil.createCalendar();
        if (d == null) {
            return "";
        }
        c.setTime(d);
        String retString = "";
        for (String pat : this.getAllPatterns()) {
            if (pat.contains("$")) {
                String hS;
                int h;
                if (pat.equals("$day")) {
                    h = c.get(5);
                    hS = "" + h;
                    if (hS.length() == 1) {
                        hS = "0" + hS;
                    }
                    retString = retString + hS;
                    continue;
                }
                if (pat.equals("$month")) {
                    h = c.get(2);
                    hS = "" + ++h;
                    if (hS.length() == 1) {
                        hS = "0" + hS;
                    }
                    retString = retString + hS;
                    continue;
                }
                if (pat.equals("$year")) {
                    h = c.get(1);
                    hS = "" + h;
                    while (hS.length() != 4) {
                        hS = "0" + hS;
                    }
                    retString = retString + hS;
                    continue;
                }
                if (pat.equals("$hour")) {
                    h = c.get(11);
                    hS = "" + h;
                    while (hS.length() != 2) {
                        hS = "0" + hS;
                    }
                    retString = retString + hS;
                    continue;
                }
                if (!pat.equals("$minute")) continue;
                h = c.get(12);
                hS = "" + h;
                while (hS.length() != 2) {
                    hS = "0" + hS;
                }
                retString = retString + hS;
                continue;
            }
            retString = retString + pat;
        }
        return retString;
    }

    @Override
    public boolean validateInput(Object input) {
        return true;
    }
}

