/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.lib.login;

import ch.icit.pegasus.lib.login.PegasusLoginParser;
import ch.icit.pegasus.lib.login.SafePasswordHash;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.sql.DataSource;
import org.jboss.logging.Logger;
import org.jboss.security.auth.spi.DatabaseServerLoginModule;

public class PegasusLoginModule
extends DatabaseServerLoginModule {
    private static final String MODE = "java:global/catit/mode";
    private static final String MAIL_SESSION_JNDINAME = "java:/mail/Default";
    private static final String MAIL_ENCODING = "UTF-8";
    private static Logger logger = Logger.getLogger((String)"ch.icit.pegasus.lib.login.PegasusLoginModule");
    private InitialContext context;
    private boolean developmentMode;

    public boolean login() throws LoginException {
        try {
            this.context = new InitialContext();
        }
        catch (NamingException e) {
            logger.error((Object)"Unexpected error", (Throwable)e);
        }
        try {
            if ("development".equals(this.context.lookup(MODE))) {
                this.developmentMode = true;
            }
        }
        catch (NamingException e) {
            logger.info((Object)"java:global/catit/mode not set in standalone.xml", (Throwable)e);
        }
        String userName = PegasusLoginParser.parse(super.getUsernameAndPassword()[0]).getUsername();
        String usersPassword = super.getUsernameAndPassword()[1];
        if (this.limitLoginAttempts()) {
            int maxAllowedLoginAttempts = this.getMaxAllowedLoginAttempts();
            int invalidLoginCount = this.getInvalidLoginCount(userName) / 2;
            if (invalidLoginCount >= maxAllowedLoginAttempts) {
                logger.info((Object)("Locked user tries to login. Number of failed login attempts: " + invalidLoginCount));
                this.incrementInvalidLoginCounter(userName);
                this.loginOk = false;
                throw new FailedLoginException("Account Locked");
            }
        }
        if (this.validatePassword(usersPassword, this.getHashedPassword(userName))) {
            if (this.limitLoginAttempts()) {
                this.resetInvalidLoginCounter(userName);
            }
            if (super.login()) {
                if (!"monitor".equals(userName)) {
                    logger.info((Object)"User logged in");
                }
                return true;
            }
            logger.info((Object)"Failed login attempt");
            return false;
        }
        if (this.limitLoginAttempts()) {
            this.incrementInvalidLoginCounter(userName);
            int invalidLoginCount = this.getInvalidLoginCount(userName) / 2;
            if (invalidLoginCount == this.getMaxAllowedLoginAttempts()) {
                this.sendMail(userName);
                logger.info((Object)("User account locked. Number of failed login attempts: " + invalidLoginCount));
                this.incrementInvalidLoginCounter(userName);
                this.loginOk = false;
                throw new FailedLoginException("Account Locked");
            }
            logger.info((Object)("Failed login attempt number: " + invalidLoginCount));
        } else {
            logger.info((Object)"Failed login attempt.");
        }
        this.loginOk = false;
        return false;
    }

    protected String getUsername() {
        String username = null;
        if (this.getIdentity() != null) {
            username = this.getIdentity().getName();
        }
        return PegasusLoginParser.parse(username).getUsername();
    }

    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        try {
            if (SafePasswordHash.validatePassword(inputPassword, expectedPassword)) {
                return true;
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        if (this.getIdentity() != null) {
            String username = this.getIdentity().getName();
            this.incrementInvalidLoginCounter(username);
        }
        return super.validatePassword(inputPassword, expectedPassword);
    }

    /*
     * Exception decompiling
     */
    private boolean limitLoginAttempts() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private int getMaxAllowedLoginAttempts() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private int getInvalidLoginCount(String username) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementInvalidLoginCounter(String username) {
        Connection con = null;
        try {
            DataSource ds = (DataSource)this.context.lookup(this.dsJndiName);
            con = ds.getConnection();
            try (PreparedStatement ps = con.prepareStatement("UPDATE pegasususer set counterincorrectlogins = counterincorrectlogins + 1 where username=?");){
                ps.setString(1, username);
                ps.executeUpdate();
            }
        }
        catch (NamingException e) {
            logger.error((Object)"Unexpected error", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"Query failed", (Throwable)e);
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Throwable e) {
                logger.error((Object)"Error closing connection", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetInvalidLoginCounter(String username) {
        Connection con = null;
        try {
            DataSource ds = (DataSource)this.context.lookup(this.dsJndiName);
            con = ds.getConnection();
            try (PreparedStatement ps = con.prepareStatement("UPDATE pegasususer set counterincorrectlogins = 0 where username=?");){
                ps.setString(1, username);
                ps.executeUpdate();
            }
        }
        catch (NamingException e) {
            logger.error((Object)"Unexpected error", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"Query failed", (Throwable)e);
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Throwable e) {
                logger.error((Object)"Error closing connection", e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private String getHashedPassword(String username) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private String getUsersEmail(String username) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void sendMail(String userName) {
        String usersEmail = this.getUsersEmail(userName);
        try {
            Object lookup = this.context.lookup(MAIL_SESSION_JNDINAME);
            Session session = (Session)lookup;
            MimeMessage message = new MimeMessage(session);
            String to = usersEmail != null ? usersEmail : "";
            InternetAddress[] recipients = new InternetAddress[]{new InternetAddress(to)};
            InternetAddress[] bcc = new InternetAddress[]{new InternetAddress("support@icit.ch", "CATIT")};
            message.setFrom((Address)new InternetAddress(session.getProperty("mail.from"), "support@icit.ch"));
            message.setSubject("CATIT account has been locked", MAIL_ENCODING);
            message.setRecipients(Message.RecipientType.TO, (Address[])recipients);
            message.setRecipients(Message.RecipientType.BCC, (Address[])bcc);
            String txt = "Your CATIT account has temporarily been locked due to failed login attempts.<br>";
            txt = txt + "<br>";
            txt = txt + "Please contact support@icit.ch to unlock your account";
            message.setContent((Object)txt, "text/html");
            Transport.send((Message)message, (Address[])message.getAllRecipients());
            logger.info((Object)"Account locked mail sent");
        }
        catch (Exception e) {
            logger.error((Object)"Error sending account locked mail", (Throwable)e);
        }
    }
}

